/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.help.DemoInfoUtils;
import com.mathworks.mlwidgets.help.DemoTreeItem;
import com.mathworks.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

class DemosDataHolder {
    private Map<String, DemoTreeItem> fDemosById = new HashMap<String, DemoTreeItem>();
    private Map<String, DemoTreeItem> fDemosByXmlFile = new HashMap<String, DemoTreeItem>();
    private Map<String, Map<String, DemoTreeItem>> fDemosByCategory = new LinkedHashMap<String, Map<String, DemoTreeItem>>();
    private List<DemoTreeItem> fUserDemos = new ArrayList<DemoTreeItem>();
    private final List<String> fDemosXmlFiles;
    private boolean fPopulated = false;

    public DemosDataHolder(List<String> list) {
        List<Object> list2 = list == null ? Collections.emptyList() : new ArrayList<String>(list);
        this.fDemosXmlFiles = list2;
    }

    void addProductItem(String string, DemoTreeItem demoTreeItem) {
        String string2 = FileUtils.normalizePathname((String)demoTreeItem.getXmlFilename());
        this.fDemosByXmlFile.put(string2, demoTreeItem);
        String string3 = string.toLowerCase(Locale.getDefault());
        Map<String, DemoTreeItem> map = this.fDemosByCategory.get(string3);
        if (map == null) {
            map = new LinkedHashMap<String, DemoTreeItem>();
            this.fDemosByCategory.put(string3, map);
        }
        if (string.equalsIgnoreCase(demoTreeItem.getProduct())) {
            for (DemoTreeItem demoTreeItem2 : demoTreeItem.getChildren()) {
                map.put(demoTreeItem2.getLabel(), demoTreeItem2);
            }
            map.put("", demoTreeItem);
        } else {
            map.put(demoTreeItem.getProduct().toLowerCase(Locale.getDefault()), demoTreeItem);
        }
        if (this.isUserDemo(string2)) {
            this.fUserDemos.add(demoTreeItem);
        }
    }

    private boolean isUserDemo(String string) {
        String string2 = new File(Matlab.matlabRoot(), "toolbox").getPath();
        return !string.startsWith(FileUtils.normalizePathname((String)string2));
    }

    List<DemoTreeItem> getUserDemos() {
        return Collections.unmodifiableList(this.fUserDemos);
    }

    void addDemoItem(DemoTreeItem demoTreeItem) {
        String string = DemoInfoUtils.getIdentifier(demoTreeItem);
        if (string != null && !this.fDemosById.containsKey(string)) {
            this.fDemosById.put(string, demoTreeItem);
        }
    }

    DemoTreeItem getDemoTreeItemById(String string) {
        return this.fDemosById.get(string);
    }

    DemoTreeItem getDemoTreeItem(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            return this.getProductItem(string2);
        }
        if (string2 == null || string2.trim().length() == 0) {
            return this.getProductItem(string);
        }
        return this.getItemForCategoryAndProduct(string, string2);
    }

    List<String> getDemosXmlFiles() {
        return Collections.unmodifiableList(this.fDemosXmlFiles);
    }

    private DemoTreeItem getItemForCategoryAndProduct(String string, String string2) {
        String string3 = string.toLowerCase(Locale.getDefault());
        Map<String, DemoTreeItem> map = null;
        for (String string4 : this.fDemosByCategory.keySet()) {
            if (!string4.startsWith(string3)) continue;
            map = this.fDemosByCategory.get(string4);
            break;
        }
        if (map != null) {
            return DemosDataHolder.findItemInMap(string2, map);
        }
        return null;
    }

    private DemoTreeItem getProductItem(String string) {
        if (string == null || string.trim().length() == 0) {
            string = "matlab";
        }
        String string2 = string.toLowerCase(Locale.getDefault());
        Map<String, DemoTreeItem> map = null;
        for (String string3 : this.fDemosByCategory.keySet()) {
            if (!string3.startsWith(string2)) continue;
            map = this.fDemosByCategory.get(string3);
            break;
        }
        if (map != null) {
            return (DemoTreeItem)map.get("");
        }
        return null;
    }

    private static DemoTreeItem findItemInMap(String string, Map<String, DemoTreeItem> map) {
        String string2 = string.toLowerCase(Locale.getDefault());
        for (String string3 : map.keySet()) {
            if (!string3.toLowerCase(Locale.getDefault()).startsWith(string2)) continue;
            return map.get(string3);
        }
        return null;
    }

    DemoTreeItem getDemoTreeItemForXmlFile(String string) {
        String string2 = FileUtils.normalizePathname((String)string);
        return this.fDemosByXmlFile.get(string2);
    }

    void setPopulated(boolean bl) {
        this.fPopulated = bl;
    }

    boolean isPopulated() {
        return this.fPopulated;
    }
}

