/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.mathworks.mlwidgets.actionbrowser.ActionBrowserUtils;
import com.mathworks.mlwidgets.graphics.ModelStateFactory;
import com.mathworks.mwswing.MJUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;

abstract class PlotPickerRenderer {
    protected String[] fKeywordArray;
    protected static Color HIGHLIGHT_COLOR = new Color(153, 255, 255);
    protected static Color SELECTION_COLOR = new Color(211, 221, 231);
    protected static boolean sIsHighContrast = false;

    PlotPickerRenderer() {
    }

    protected StyleRange[] getHiLightedStyleRanges(String string) {
        return PlotPickerRenderer.createHiLightedStyleRanges(string, this.fKeywordArray, this.getFont().getStyle(), this.getForeground());
    }

    static StyleRange[] createHiLightedStyleRanges(String string, String[] stringArray, int n, Color color) {
        if (stringArray == null || stringArray.length == 0) {
            return new StyleRange[0];
        }
        string = string.toLowerCase().trim();
        ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>();
        for (String string2 : stringArray) {
            if (string2.length() < 2) continue;
            int n2 = 0;
            while (string.indexOf(string2, n2) >= 0) {
                n2 = string.indexOf(string2, n2);
                StyleRange styleRange = new StyleRange(n2, string2.length(), n, color, HIGHLIGHT_COLOR, 0);
                arrayList.add(styleRange);
                n2 += string2.length();
            }
        }
        return arrayList.toArray(new StyleRange[0]);
    }

    protected static boolean isMouseInHoverButton(JTable jTable, Rectangle rectangle, Point point) {
        int n = jTable.rowAtPoint(point);
        if (rectangle == null) {
            return false;
        }
        Rectangle rectangle2 = jTable.getCellRect(n, 0, true);
        rectangle2.x += rectangle.x;
        rectangle2.y += rectangle.y;
        rectangle2.width = rectangle.width;
        rectangle2.height = rectangle.height;
        return rectangle2.contains(point);
    }

    abstract Font getFont();

    abstract Color getForeground();

    abstract void hilight();

    void setFilterString(String string) {
        if (string == null) {
            this.fKeywordArray = new String[0];
            return;
        }
        this.fKeywordArray = ActionBrowserUtils.getKeywordArray(string);
    }

    static {
        sIsHighContrast = MJUtilities.isHighContrast();
        if (sIsHighContrast) {
            HIGHLIGHT_COLOR = Color.white;
            SELECTION_COLOR = Color.white;
        }
    }

    static class TranslucentLabel
    extends StyledLabel {
        private boolean iActive = true;

        TranslucentLabel() {
        }

        TranslucentLabel(String string) {
            super(string);
        }

        TranslucentLabel(Icon icon) {
            super(icon);
        }

        void setActive(boolean bl) {
            this.iActive = bl;
        }

        protected void paintComponent(Graphics graphics) {
            if (this.iActive) {
                super.paintComponent(graphics);
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setComposite(AlphaComposite.getInstance(10, 0.5f));
            super.paintComponent((Graphics)graphics2D);
            graphics2D.dispose();
        }
    }

    static class PlotIcon
    implements Icon {
        private ImageIcon iBackgroundIcon;
        private ImageIcon iForegroundIcon;
        static int INACTIVE = 0;
        static int PRESSED = 1;
        static int HOVER = 2;
        static int UP = 3;

        @Override
        public int getIconHeight() {
            return 48;
        }

        @Override
        public int getIconWidth() {
            return 72;
        }

        PlotIcon(ImageIcon imageIcon) {
            this.iForegroundIcon = imageIcon;
        }

        void setState(int n) {
            switch (n) {
                case 0: {
                    this.iBackgroundIcon = null;
                    break;
                }
                case 1: {
                    this.iBackgroundIcon = new ImageIcon(ModelStateFactory.class.getResource("resources/Thumbnail_pressed.png"));
                    break;
                }
                case 2: {
                    this.iBackgroundIcon = new ImageIcon(ModelStateFactory.class.getResource("resources/Thumbnail_hoverover.png"));
                    break;
                }
                case 3: {
                    this.iBackgroundIcon = new ImageIcon(ModelStateFactory.class.getResource("resources/Thumbnail_up.png"));
                }
            }
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.iBackgroundIcon != null) {
                this.iBackgroundIcon.paintIcon(component, graphics, n, n2);
            }
            this.iForegroundIcon.paintIcon(component, graphics, n + 6, n2 + 1);
        }
    }
}

