/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.util;

import com.mathworks.mlwidgets.explorer.util.ExplicitColorAndFontProvider;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJEditorPane;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontListener;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.Predicate;
import com.mathworks.util.tree.ComponentTree;
import com.mathworks.util.tree.Tree;
import com.mathworks.util.tree.TreeUtils;
import com.mathworks.util.tree.VisitStrategy;
import com.mathworks.widgets.grouptable.GroupingTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.JTableHeader;

public final class PrefUtils {
    private PrefUtils() {
    }

    public static void manageFonts(Container container, final String string) {
        ParameterRunnable<Component> parameterRunnable = new ParameterRunnable<Component>(){

            public void run(Component component) {
                if (string == null) {
                    component.setFont(FontPrefs.getTextFont());
                } else {
                    component.setFont(FontPrefs.getFontForComponent((String)string));
                }
                if (component instanceof GroupingTable) {
                    ((GroupingTable)component).adjustRowHeight();
                }
            }
        };
        if (string != null) {
            FontPrefs.addFontListener((String)string, (FontListener)new ComponentListener(container, parameterRunnable));
        } else {
            FontPrefs.addTextFontListener((FontListener)new ComponentListener(container, parameterRunnable));
        }
        PrefUtils.manage(container, parameterRunnable);
    }

    public static void manageTextColor(Container container) {
        ParameterRunnable<Component> parameterRunnable = new ParameterRunnable<Component>(){

            public void run(Component component) {
                component.setForeground(ColorPrefs.getTextColor());
                if (component instanceof MJEditorPane) {
                    ((MJEditorPane)component).setFontColor(ColorPrefs.getTextColor());
                }
            }
        };
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)new ColorListener(container, parameterRunnable));
        PrefUtils.manage(container, parameterRunnable);
    }

    public static void manageBackgroundColor(Container container) {
        ParameterRunnable<Component> parameterRunnable = new ParameterRunnable<Component>(){

            public void run(Component component) {
                component.setBackground(ColorPrefs.getBackgroundColor());
                if (component instanceof MJEditorPane) {
                    ((MJEditorPane)component).setBackgroundColor(ColorPrefs.getBackgroundColor());
                }
            }
        };
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)new ColorListener(container, parameterRunnable));
        PrefUtils.manage(container, parameterRunnable);
    }

    private static void manage(Container container, final ParameterRunnable<Component> parameterRunnable) {
        PrefUtils.runRecursively(container, parameterRunnable);
        ContainerListener containerListener = new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                PrefUtils.runRecursively((Container)containerEvent.getChild(), (ParameterRunnable<Component>)parameterRunnable);
                for (Container container : PrefUtils.findComponentsForFontManagement(containerEvent.getChild(), Container.class)) {
                    container.removeContainerListener(this);
                    container.addContainerListener(this);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                for (Container container : PrefUtils.findComponentsForFontManagement(containerEvent.getChild(), Container.class)) {
                    container.removeContainerListener(this);
                }
            }
        };
        for (Container container2 : PrefUtils.findComponentsForFontManagement(container, Container.class)) {
            container2.addContainerListener(containerListener);
        }
    }

    private static void runRecursively(Container container, ParameterRunnable<Component> parameterRunnable) {
        for (Component component : PrefUtils.findComponentsForFontManagement(container, Component.class)) {
            if (component instanceof JTableHeader || component.getParent() instanceof JTable || component.getParent() instanceof JList || component instanceof JComboBox || component instanceof JButton || component instanceof JToolBar || component instanceof ExplicitColorAndFontProvider) continue;
            parameterRunnable.run((Object)component);
            if (!(component instanceof GroupingTable)) continue;
            ((GroupingTable)component).adjustRowHeight();
        }
    }

    private static <C extends Component> Collection<C> findComponentsForFontManagement(Component component, Class<C> clazz) {
        return TreeUtils.find((Tree)TreeUtils.subtree((Tree)ComponentTree.getInstance((Component)component), (Object)component), (VisitStrategy)new VisitStrategy((Predicate)new Predicate<Component>(){

            public boolean accept(Component component) {
                return !(component.getParent() instanceof JTable) && !(component.getParent() instanceof JList) && !(component instanceof JTableHeader) && !(component instanceof JToolBar) && !(component instanceof MJButton) && !(component instanceof JComboBox) && !(component instanceof ExplicitColorAndFontProvider);
            }
        }, TreeUtils.instanceOf(clazz)), new HashSet());
    }

    private static class ComponentListener
    implements FontListener {
        private Container fComp;
        private ParameterRunnable<Component> fCode;

        ComponentListener(Container container, ParameterRunnable<Component> parameterRunnable) {
            this.fComp = container;
            this.fCode = parameterRunnable;
        }

        public void fontChanged(Font font) {
            PrefUtils.runRecursively(this.fComp, (ParameterRunnable<Component>)this.fCode);
        }
    }

    private static class ColorListener
    implements PrefListener {
        private Container fComp;
        private ParameterRunnable<Component> fCode;

        ColorListener(Container container, ParameterRunnable<Component> parameterRunnable) {
            this.fComp = container;
            this.fCode = parameterRunnable;
        }

        public void prefChanged(PrefEvent prefEvent) {
            PrefUtils.runRecursively(this.fComp, (ParameterRunnable<Component>)this.fCode);
        }
    }
}

