/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.util;

import com.mathworks.jmi.NativeMatlab;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.PathModel;
import com.mathworks.mlwidgets.explorer.model.WritablePathModel;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

public final class MLPathUtils {
    private MLPathUtils() {
    }

    public static boolean isOnPath(PathModel pathModel, FileSystemEntry fileSystemEntry, boolean bl) {
        return pathModel.isActive() && pathModel.contains(fileSystemEntry.isFolder() ? fileSystemEntry.getLocation() : fileSystemEntry.getLocation().getParent(), bl);
    }

    public static boolean isOnPath(PathModel pathModel, Set<FileLocation> set, FileSystemEntry fileSystemEntry) {
        if (MLPathUtils.isPackageOrClassDirectory(fileSystemEntry) || MLPathUtils.isFileInPackageOrClassDirectory(fileSystemEntry)) {
            FileLocation fileLocation = MLPathUtils.getNonPackageOrClassParent(fileSystemEntry);
            return fileLocation != null && set.contains(fileLocation);
        }
        if (MLPathUtils.isPrivate(fileSystemEntry) || MLPathUtils.isFileInNonCurrentPrivateDirectory(pathModel, fileSystemEntry)) {
            return false;
        }
        if (fileSystemEntry.isFolder()) {
            return set.contains(fileSystemEntry.getLocation());
        }
        return fileSystemEntry.getLocation().getParent() != null && set.contains(fileSystemEntry.getLocation().getParent());
    }

    public static boolean isPrivate(FileSystemEntry fileSystemEntry) {
        return fileSystemEntry.isFolder() && MLPathUtils.isPrivate(fileSystemEntry.getLocation().getName());
    }

    public static boolean isPrivate(String string) {
        return string != null && (PlatformInfo.isWindows() ? string.equalsIgnoreCase("private") : string.equals("private"));
    }

    public static boolean isFileInNonCurrentPrivateDirectory(PathModel pathModel, FileSystemEntry fileSystemEntry) {
        return !fileSystemEntry.isFolder() && fileSystemEntry.getLocation().getParent() != null && MLPathUtils.isPrivate(fileSystemEntry.getLocation().getParent().getName()) && !fileSystemEntry.getLocation().getParent().equals((Object)pathModel.getCurrentFolder());
    }

    public static boolean isPackageOrClassDirectory(FileSystemEntry fileSystemEntry) {
        return fileSystemEntry.isFolder() && MLPathUtils.hasPackageOrClassName(fileSystemEntry.getLocation());
    }

    public static boolean isFileInPackageOrClassDirectory(FileSystemEntry fileSystemEntry) {
        return !fileSystemEntry.isFolder() && fileSystemEntry.getLocation().getParent() != null && MLPathUtils.hasPackageOrClassName(fileSystemEntry.getLocation().getParent());
    }

    public static boolean hasPackageOrClassName(FileLocation fileLocation) {
        return fileLocation.getName().startsWith("+") || fileLocation.getName().startsWith("@");
    }

    public static FileLocation getNonPackageOrClassParent(FileSystemEntry fileSystemEntry) {
        FileLocation fileLocation = fileSystemEntry.getLocation();
        if (!fileSystemEntry.isFolder()) {
            fileLocation = fileSystemEntry.getLocation().getParent();
        }
        while (fileLocation != null && MLPathUtils.hasPackageOrClassName(fileLocation)) {
            fileLocation = fileLocation.getParent();
        }
        return fileLocation;
    }

    public static FileLocation getAddableFolder(PathModel pathModel, FileSystemEntry fileSystemEntry) {
        if (MLPathUtils.isPrivate(fileSystemEntry) || MLPathUtils.isFileInNonCurrentPrivateDirectory(pathModel, fileSystemEntry)) {
            return null;
        }
        FileLocation fileLocation = fileSystemEntry.getLocation();
        FileLocation fileLocation2 = fileSystemEntry.getLocation();
        if (!fileSystemEntry.isFolder()) {
            fileLocation2 = fileSystemEntry.getLocation().getParent();
        }
        while (fileLocation2 != null && (MLPathUtils.isPrivate(fileLocation2.getName()) || MLPathUtils.hasPackageOrClassName(fileLocation2))) {
            fileLocation2 = fileLocation2.getParent();
        }
        if (fileLocation2 != null) {
            fileLocation = fileLocation2;
        }
        return fileLocation;
    }

    private static List<File> getRealFolders(List<FileSystemEntry> list, boolean bl) {
        if (bl) {
            FileSystemUtils.addSubfoldersRecursively(list, list);
        }
        ArrayList<File> arrayList = new ArrayList<File>(list.size());
        for (FileSystemEntry fileSystemEntry : list) {
            if (!fileSystemEntry.isReal()) continue;
            if (fileSystemEntry.isFolder()) {
                arrayList.add(new File(fileSystemEntry.getLocation().toString()));
                continue;
            }
            arrayList.add(new File(fileSystemEntry.getLocation().getParent().toString()));
        }
        return arrayList;
    }

    public static void addToPath(final WritablePathModel writablePathModel, final boolean bl, boolean bl2, List<FileSystemEntry> list, final ParameterRunnable<List<FileLocation>> parameterRunnable) {
        final List<File> list2 = MLPathUtils.getRealFolders(list, bl2);
        Collections.sort(list2, UiFileSystemUtils.sortAlphabetically());
        new Thread(new Runnable(){

            @Override
            public void run() {
                MLPathUtils.addToPath(writablePathModel, list2, bl, parameterRunnable == null ? null : new ParameterRunnable<List<File>>(){

                    public void run(List<File> list) {
                        ArrayList<FileLocation> arrayList = new ArrayList<FileLocation>(list.size());
                        for (File file : list) {
                            arrayList.add(new FileLocation(file.getAbsolutePath()));
                        }
                        parameterRunnable.run(arrayList);
                    }
                });
            }
        }).start();
    }

    public static void removeFromPath(WritablePathModel writablePathModel, boolean bl, List<FileSystemEntry> list, final ParameterRunnable<List<FileLocation>> parameterRunnable) {
        List<File> list2 = MLPathUtils.getRealFolders(list, bl);
        MLPathUtils.removeFromPath(writablePathModel, bl, list2, parameterRunnable == null ? null : new ParameterRunnable<List<File>>(){

            public void run(List<File> list) {
                ArrayList<FileLocation> arrayList = new ArrayList<FileLocation>(list.size());
                for (File file : list) {
                    arrayList.add(new FileLocation(file.getAbsolutePath()));
                }
                parameterRunnable.run(arrayList);
            }
        });
    }

    static AsyncReceiver<File> prepareToSafelyDelete(PathModel pathModel, List<File> list, Set<File> set) {
        MLPathUtils.findDirectoriesOnPath(pathModel, list, set);
        if (!set.isEmpty()) {
            return null;
        }
        return new AsyncReceiver<File>(){

            public boolean receive(File file) {
                NativeMatlab.nativeReleaseDeletedDirFromPath((File)file);
                return true;
            }
        };
    }

    static AsyncReceiver<File> prepareToSafelyMove(PathModel pathModel, List<File> list, File file, Set<File> set) {
        MLPathUtils.findDirectoriesOnPath(pathModel, list, set);
        if (!set.isEmpty()) {
            return null;
        }
        final Map<File, File> map = MLPathUtils.createMoveMap(list, list, file);
        return new AsyncReceiver<File>(){

            public boolean receive(File file) {
                for (Map.Entry entry : map.entrySet()) {
                    if (!MLPathUtils.isEqualOrChildOf((File)entry.getValue(), file)) continue;
                    NativeMatlab.nativeReleaseDeletedDirFromPath((File)((File)entry.getKey()));
                }
                return true;
            }
        };
    }

    static Map<File, File> createMoveMap(Collection<File> collection, Collection<File> collection2, File file) {
        HashMap<File, File> hashMap = new HashMap<File, File>();
        block0: for (File file2 : collection2) {
            for (File file3 : collection) {
                if (!MLPathUtils.isEqualOrChildOf(file2, file3)) continue;
                hashMap.put(file2, MLPathUtils.reparent(file3, new File(file, file3.getName()), file2));
                continue block0;
            }
        }
        return hashMap;
    }

    static File reparent(File file, File file2, File file3) {
        Stack<String> stack = new Stack<String>();
        while (!file3.equals(file)) {
            stack.push(file3.getName());
        }
        File file4 = file2;
        while (!stack.isEmpty()) {
            file4 = new File(file4, (String)stack.pop());
        }
        return file4;
    }

    static void findDirectoriesOnPath(PathModel pathModel, Collection<File> collection, Set<File> set) {
        block0: for (FileLocation fileLocation : pathModel.getPath()) {
            for (File file : collection) {
                if (!MLPathUtils.isEqualOrChildOf(fileLocation.toFile(), file.getAbsoluteFile())) continue;
                set.add(fileLocation.toFile());
                continue block0;
            }
        }
    }

    static void addToPath(WritablePathModel writablePathModel, Collection<File> collection, boolean bl, final ParameterRunnable<List<File>> parameterRunnable) {
        final LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        LinkedHashSet<FileLocation> linkedHashSet2 = new LinkedHashSet<FileLocation>();
        Set<String> set = MLPathUtils.getComparablePath(writablePathModel, !bl);
        for (File file : collection) {
            String string = MLPathUtils.toComparablePathElement(file);
            if (set.contains(string) || !MLPathUtils.makesSenseOnPath(string)) continue;
            linkedHashSet.add(file);
            linkedHashSet2.add(new FileLocation(file));
        }
        if (linkedHashSet2.isEmpty()) {
            if (parameterRunnable != null) {
                parameterRunnable.run(new Vector(0));
            }
        } else {
            writablePathModel.prepend(linkedHashSet2, new Runnable(){

                @Override
                public void run() {
                    if (parameterRunnable != null) {
                        parameterRunnable.run(new Vector(linkedHashSet));
                    }
                }
            });
        }
    }

    static void removeFromPath(WritablePathModel writablePathModel, boolean bl, Collection<File> collection, final ParameterRunnable<List<File>> parameterRunnable) {
        final LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        LinkedHashSet<FileLocation> linkedHashSet2 = new LinkedHashSet<FileLocation>();
        Set<String> set = MLPathUtils.getComparablePath(writablePathModel, false);
        if (bl) {
            for (String string : set) {
                File file = new File(string);
                for (File file2 : collection) {
                    if (!MLPathUtils.isEqualOrChildOf(file, file2)) continue;
                    linkedHashSet.add(file);
                    linkedHashSet2.add(new FileLocation(string));
                }
            }
        } else {
            for (File file : collection) {
                if (!set.contains(MLPathUtils.toComparablePathElement(file))) continue;
                linkedHashSet.add(file);
                linkedHashSet2.add(new FileLocation(file.getAbsolutePath()));
            }
        }
        if (linkedHashSet2.isEmpty()) {
            if (parameterRunnable != null) {
                parameterRunnable.run(new Vector(0));
            }
        } else {
            writablePathModel.remove(linkedHashSet2, new Runnable(){

                @Override
                public void run() {
                    if (parameterRunnable != null) {
                        parameterRunnable.run(new Vector(linkedHashSet));
                    }
                }
            });
        }
    }

    static Set<String> getComparablePath(PathModel pathModel, boolean bl) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (FileLocation fileLocation : pathModel.getPath()) {
            linkedHashSet.add(MLPathUtils.toComparablePathElement(fileLocation.toFile()));
        }
        if (bl) {
            linkedHashSet.add(MLPathUtils.toComparablePathElement(pathModel.getCurrentFolder().toFile()));
        }
        return linkedHashSet;
    }

    static String toComparablePathElement(File file) {
        if (PlatformInfo.isWindows()) {
            return file.getAbsolutePath().toLowerCase();
        }
        return file.getAbsolutePath();
    }

    public static boolean makesSenseOnPath(String string) {
        boolean bl = true;
        File file = new File(string);
        if (MLPathUtils.isPrivate(file.getName())) {
            bl = false;
        } else {
            FileLocation fileLocation = new FileLocation(file);
            for (FileLocation fileLocation2 = fileLocation.getParent(); fileLocation2 != null; fileLocation2 = fileLocation2.getParent()) {
                if (!MLPathUtils.isPrivate(fileLocation2.getName())) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private static boolean isEqualOrChildOf(File file, File file2) {
        return new FileLocation(file.getAbsolutePath()).hasPrefix(new FileLocation(file2.getAbsolutePath()));
    }
}

