/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.vfs;

import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualFileSystem;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualTarget;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.Holder;
import com.mathworks.util.ParameterRunnable;
import java.io.IOException;

final class VirtualFileList
implements FileList {
    private final VirtualTarget fTarget;
    private final VirtualFileSystem fSystem;
    private final FileLocation fVirtualParentLocation;
    private final FileList fNonVirtualList;

    VirtualFileList(VirtualFileSystem virtualFileSystem, VirtualTarget virtualTarget, FileLocation fileLocation, FileList fileList) throws IOException {
        this.fSystem = virtualFileSystem;
        this.fTarget = virtualTarget;
        this.fVirtualParentLocation = fileLocation;
        this.fNonVirtualList = fileList;
    }

    public FileSystemEntry getLocationEntry() {
        return this.fSystem.toExternalEntry(this.fVirtualParentLocation, this.fNonVirtualList.getLocationEntry());
    }

    public boolean exists(FileLocation fileLocation) {
        return this.fNonVirtualList.exists(fileLocation);
    }

    public void readFilesAndFolders(AsyncReceiver<FileSystemEntry> asyncReceiver) throws IOException {
        this.fNonVirtualList.readFilesAndFolders((AsyncReceiver)new MountingReceiver(asyncReceiver));
    }

    public void readFolders(AsyncReceiver<FileSystemEntry> asyncReceiver) throws IOException {
        this.fNonVirtualList.readFolders((AsyncReceiver)new MountingReceiver(asyncReceiver));
    }

    public boolean hasFolders() throws IOException {
        final Holder holder = new Holder();
        holder.set((Object)false);
        this.readFolders(new AsyncReceiver<FileSystemEntry>(){

            public boolean receive(FileSystemEntry fileSystemEntry) {
                holder.set((Object)true);
                return false;
            }
        });
        return (Boolean)holder.get();
    }

    public boolean isEmpty() throws IOException {
        return this.fNonVirtualList.isEmpty();
    }

    public void pause(ParameterRunnable<Runnable> parameterRunnable) {
        this.fNonVirtualList.pause(parameterRunnable);
    }

    public void close() {
        this.fNonVirtualList.close();
    }

    public String toString() {
        String string = this.fTarget.getSystem().getClass().getName();
        return "VirtualFileList (" + string.substring(string.lastIndexOf(46) + 1) + ":" + this.fTarget.getLocation() + ") => " + this.fNonVirtualList.toString();
    }

    private class MountingReceiver
    extends AsyncReceiver<FileSystemEntry> {
        private final AsyncReceiver<FileSystemEntry> iReceiver;

        MountingReceiver(AsyncReceiver<FileSystemEntry> asyncReceiver) {
            this.iReceiver = asyncReceiver;
        }

        public boolean receive(FileSystemEntry fileSystemEntry) {
            return this.iReceiver.receive((Object)VirtualFileList.this.fSystem.toExternalEntry(VirtualFileList.this.fTarget, fileSystemEntry));
        }

        public void finished() {
            this.iReceiver.finished();
        }
    }
}

