/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.table;

import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.FileDecorationCache;
import com.mathworks.mlwidgets.explorer.model.table.ExplorerRefreshDaemon;
import com.mathworks.mlwidgets.explorer.model.table.RefreshDaemon;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.CancellationDetectingReceiver;
import com.mathworks.util.CapturingReceiver;
import com.mathworks.util.RequestQueue;
import com.mathworks.widgets.grouptable.ExpansionChangeListener;
import com.mathworks.widgets.grouptable.GroupingTableTransaction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UiFileList {
    private final RequestQueue fRequestQueue;
    private final FileList fList;
    private final boolean fOnlyIncludeFolders;
    private final FileDecorationCache fDecorationCache;
    private final List<ExpansionChangeListener<FileSystemEntry>> fListeners;
    private final List<Runnable> fCompletionListeners;
    private final boolean fFireChange;
    private final RefreshDaemon fRefreshDaemon;
    private volatile CachedData fData;

    public UiFileList(RequestQueue requestQueue, FileList fileList, boolean bl) {
        this(requestQueue, fileList, true, false, bl, ExplorerRefreshDaemon.getInstance());
    }

    public UiFileList(RequestQueue requestQueue, FileList fileList, boolean bl, RefreshDaemon refreshDaemon) {
        this(requestQueue, fileList, true, false, bl, refreshDaemon);
    }

    public UiFileList(RequestQueue requestQueue, FileList fileList, boolean bl, boolean bl2, RefreshDaemon refreshDaemon) {
        this(requestQueue, fileList, bl, bl2, false, refreshDaemon);
    }

    public UiFileList(RequestQueue requestQueue, FileList fileList, boolean bl, boolean bl2, boolean bl3, RefreshDaemon refreshDaemon) {
        this.fList = fileList;
        this.fRequestQueue = requestQueue;
        this.fOnlyIncludeFolders = bl2;
        this.fListeners = new LinkedList<ExpansionChangeListener<FileSystemEntry>>();
        this.fCompletionListeners = new LinkedList<Runnable>();
        this.fDecorationCache = new FileDecorationCache();
        this.fFireChange = bl3;
        this.fRefreshDaemon = refreshDaemon;
        this.fDecorationCache.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FileLocation fileLocation = (FileLocation)changeEvent.getSource();
                FileSystemEntry fileSystemEntry = UiFileList.this.getEntryIfCached(fileLocation);
                if (fileSystemEntry != null) {
                    GroupingTableTransaction groupingTableTransaction = new GroupingTableTransaction();
                    groupingTableTransaction.add(GroupingTableTransaction.Type.CHANGE, (Object)fileSystemEntry);
                    UiFileList.this.fireListeners((GroupingTableTransaction<FileSystemEntry>)groupingTableTransaction, false);
                }
            }
        });
        if (bl) {
            this.fRefreshDaemon.register(this);
        }
    }

    public RequestQueue getRequestQueue() {
        return this.fRequestQueue;
    }

    public FileDecorations getDecorations(FileSystemEntry fileSystemEntry, ExtensionRegistry extensionRegistry) {
        return this.fDecorationCache.getDecorations(fileSystemEntry, extensionRegistry);
    }

    public FileSystemEntry getLocationEntry() {
        return this.fList.getLocationEntry();
    }

    public FileSystemEntry getEntryIfCached(FileLocation fileLocation) {
        CachedData cachedData = this.fData;
        Map<FileLocation, FileSystemEntry> map = cachedData == null ? null : cachedData.getEntries();
        return map != null ? map.get(fileLocation) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletionListener(Runnable runnable) {
        List<Runnable> list = this.fCompletionListeners;
        synchronized (list) {
            this.fCompletionListeners.add(runnable);
        }
    }

    public void addListener(final ExpansionChangeListener<FileSystemEntry> expansionChangeListener) {
        this.fRequestQueue.request(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = UiFileList.this.fListeners;
                synchronized (list) {
                    UiFileList.this.fListeners.add(expansionChangeListener);
                }
            }
        });
    }

    public void removeListener(final ExpansionChangeListener<FileSystemEntry> expansionChangeListener) {
        this.fRequestQueue.request(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = UiFileList.this.fListeners;
                synchronized (list) {
                    UiFileList.this.fListeners.remove(expansionChangeListener);
                }
            }
        });
    }

    public void read(final AsyncReceiver<FileSystemEntry> asyncReceiver) {
        this.fRequestQueue.request(new Runnable(){

            @Override
            public void run() {
                Map map = UiFileList.this.getCachedEntries();
                if (map != null) {
                    UiFileList.sendCachedData(map, (AsyncReceiver<FileSystemEntry>)asyncReceiver);
                    UiFileList.this.fireCompletionListeners();
                } else {
                    UiFileList.this.readAndUpdateCache(true, (CapturingReceiver<FileSystemEntry>)((CapturingReceiver)new CapturingReceiver<FileSystemEntry>(asyncReceiver){

                        public void finished() {
                            super.finished();
                            UiFileList.this.fireCompletionListeners();
                        }
                    }));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCompletionListeners() {
        ArrayList<Runnable> arrayList;
        List<Runnable> list = this.fCompletionListeners;
        synchronized (list) {
            arrayList = new ArrayList<Runnable>(this.fCompletionListeners);
            this.fCompletionListeners.clear();
        }
        for (Runnable runnable : arrayList) {
            MJUtilities.runOnEventDispatchThread((Runnable)runnable);
        }
    }

    public boolean isEmpty() {
        CachedData cachedData = this.fData;
        try {
            if (cachedData == null) {
                this.fData = cachedData = new CachedData(null, this.fList.isEmpty());
            }
            return cachedData.isEmpty();
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public void close() {
        this.fList.close();
        this.fRefreshDaemon.unregister(this);
        this.fireCompletionListeners();
        this.fRequestQueue.request(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = UiFileList.this.fListeners;
                synchronized (list) {
                    UiFileList.this.fListeners.clear();
                }
            }
        });
    }

    public void refresh() {
        this.fRequestQueue.request(new Runnable(){

            @Override
            public void run() {
                if (UiFileList.this.fData == null && UiFileList.this.fFireChange) {
                    UiFileList.this.fData = new CachedData(new HashMap<FileLocation, FileSystemEntry>(0), true);
                }
                if (UiFileList.this.fData != null) {
                    UiFileList.this.readAndUpdateCache(false, (CapturingReceiver<FileSystemEntry>)new CapturingReceiver());
                }
            }
        });
    }

    private Map<FileLocation, FileSystemEntry> getCachedEntries() {
        CachedData cachedData = this.fData;
        return cachedData == null ? null : cachedData.getEntries();
    }

    private void readAndUpdateCache(boolean bl, CapturingReceiver<FileSystemEntry> capturingReceiver) {
        if (!this.fFireChange && !bl && this.getCachedEntries() == null) {
            try {
                this.updateCache(new CachedData(null, this.fList.isEmpty()));
            }
            catch (IOException iOException) {
                this.updateCache(new CachedData(null, true));
            }
            return;
        }
        CancellationDetectingReceiver cancellationDetectingReceiver = new CancellationDetectingReceiver(capturingReceiver);
        try {
            if (this.fOnlyIncludeFolders) {
                this.fList.readFolders((AsyncReceiver)cancellationDetectingReceiver);
            } else {
                this.fList.readFilesAndFolders((AsyncReceiver)cancellationDetectingReceiver);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!cancellationDetectingReceiver.wasCanceled()) {
            List list = capturingReceiver.getCapturedData();
            this.updateCache(new CachedData(UiFileList.convertToMap(list), list.isEmpty()));
        } else if (this.getCachedEntries() != null && !capturingReceiver.getCapturedData().isEmpty()) {
            this.updateCache(new CachedData(null, false));
        }
    }

    private static void sendCachedData(Map<FileLocation, FileSystemEntry> map, AsyncReceiver<FileSystemEntry> asyncReceiver) {
        for (FileSystemEntry fileSystemEntry : map.values()) {
            if (!asyncReceiver.receive((Object)fileSystemEntry)) break;
        }
        asyncReceiver.finished();
    }

    private void updateCache(CachedData cachedData) {
        if (this.fData != null) {
            this.diffAndSendEvents(cachedData);
        }
        this.fData = cachedData;
    }

    private static Map<FileLocation, FileSystemEntry> convertToMap(List<FileSystemEntry> list) {
        HashMap<FileLocation, FileSystemEntry> hashMap = new HashMap<FileLocation, FileSystemEntry>(list.size());
        for (FileSystemEntry fileSystemEntry : list) {
            hashMap.put(fileSystemEntry.getLocation(), fileSystemEntry);
        }
        return hashMap;
    }

    private void diffAndSendEvents(CachedData cachedData) {
        GroupingTableTransaction groupingTableTransaction = new GroupingTableTransaction();
        Map<FileLocation, FileSystemEntry> map = cachedData.getEntries();
        Map<FileLocation, FileSystemEntry> map2 = this.getCachedEntries();
        if (map2 == null) {
            map2 = new HashMap<FileLocation, FileSystemEntry>(0);
        }
        boolean bl = false;
        if (map != null) {
            HashSet<FileSystemEntry> hashSet = new HashSet<FileSystemEntry>(map.values());
            for (Map.Entry<FileLocation, FileSystemEntry> fileSystemEntry : map2.entrySet()) {
                FileSystemEntry fileSystemEntry2 = map.get(fileSystemEntry.getKey());
                if (fileSystemEntry2 == null) {
                    groupingTableTransaction.add(GroupingTableTransaction.Type.REMOVE, (Object)fileSystemEntry.getValue());
                    this.fDecorationCache.flush(fileSystemEntry.getKey());
                    bl = true;
                } else if (!fileSystemEntry.getValue().matches(fileSystemEntry2)) {
                    groupingTableTransaction.add(GroupingTableTransaction.Type.CHANGE, (Object)fileSystemEntry2);
                    this.fDecorationCache.markStale(fileSystemEntry2.getLocation(), fileSystemEntry2);
                    bl = true;
                }
                hashSet.remove(fileSystemEntry.getValue());
            }
            for (FileSystemEntry fileSystemEntry : hashSet) {
                groupingTableTransaction.add(GroupingTableTransaction.Type.ADD, (Object)fileSystemEntry);
                bl = true;
            }
        }
        boolean bl2 = this.fData.isEmpty() != cachedData.isEmpty();
        this.fData = cachedData;
        if (bl || bl2) {
            this.fireListeners((GroupingTableTransaction<FileSystemEntry>)groupingTableTransaction, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireListeners(GroupingTableTransaction<FileSystemEntry> groupingTableTransaction, boolean bl) {
        ArrayList<ExpansionChangeListener<FileSystemEntry>> arrayList;
        List<ExpansionChangeListener<FileSystemEntry>> list = this.fListeners;
        synchronized (list) {
            arrayList = new ArrayList<ExpansionChangeListener<FileSystemEntry>>(this.fListeners);
        }
        for (ExpansionChangeListener expansionChangeListener : arrayList) {
            expansionChangeListener.childrenChanged(groupingTableTransaction);
            if (!bl) continue;
            expansionChangeListener.hasChildrenChanged();
        }
    }

    public String toString() {
        return "UiFileList, cache = " + (this.fData == null ? "null" : this.fData) + ", " + this.fList.toString();
    }

    private static class CachedData {
        private final Map<FileLocation, FileSystemEntry> fEntries;
        private final boolean fEmpty;

        CachedData(Map<FileLocation, FileSystemEntry> map, boolean bl) {
            this.fEntries = map == null ? null : Collections.unmodifiableMap(new HashMap<FileLocation, FileSystemEntry>(map));
            this.fEmpty = bl;
        }

        public boolean isEmpty() {
            return this.fEmpty;
        }

        public Map<FileLocation, FileSystemEntry> getEntries() {
            return this.fEntries;
        }

        public String toString() {
            return "(" + (this.fEntries == null ? "no" : Integer.toString(this.fEntries.size())) + " cached entries, empty = " + this.fEmpty + ")";
        }
    }
}

