/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.table;

import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.ExplorerExtensionRegistry;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.table.FileSystemExpansionProvider;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.mlwidgets.explorer.widgets.table.FileNameEditor;
import com.mathworks.mlwidgets.explorer.widgets.table.FileTable;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.util.Converter;
import com.mathworks.widgets.ValidityWithHelp;
import com.mathworks.widgets.grouptable.CloseableEditor;
import com.mathworks.widgets.grouptable.GroupingMode;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import com.mathworks.widgets.grouptable.GroupingTableEditor;
import java.awt.Component;
import java.io.IOException;
import java.util.Comparator;

public final class NameColumn {
    private final GroupingTableColumn<FileSystemEntry> fColumn;
    public static final String KEY = "name";
    private final FileSystemExpansionProvider fProvider;

    public NameColumn() {
        this(null);
    }

    public NameColumn(FileSystemExpansionProvider fileSystemExpansionProvider) {
        this.fProvider = fileSystemExpansionProvider;
        this.fColumn = new GroupingTableColumn(KEY, ExplorerResources.getString("table.name"), false, String.class, null, (Converter)new Converter<FileSystemEntry, String>(){

            public String convert(FileSystemEntry fileSystemEntry) {
                boolean bl = NameColumn.this.fProvider == null ? ((Boolean)UiFileSystemUtils.getDecorationSynchronously(fileSystemEntry, CoreFileDecoration.IS_DIRTY_FLAG, ExplorerExtensionRegistry.getInstance())).booleanValue() : ((Boolean)NameColumn.this.fProvider.getDecoration(fileSystemEntry, CoreFileDecoration.IS_DIRTY_FLAG)).booleanValue();
                String string = bl ? fileSystemEntry.getName() + '*' : fileSystemEntry.getName();
                return string;
            }
        }, (GroupingTableEditor)new GroupingTableEditor<FileSystemEntry>(){

            public boolean isEditable(FileSystemEntry fileSystemEntry) {
                return true;
            }

            public ValidityWithHelp validateEdit(FileSystemEntry fileSystemEntry, String string) {
                return MLFileSystemUtils.validateRename(fileSystemEntry, string);
            }

            public FileSystemEntry edit(Component component, FileSystemEntry fileSystemEntry, String string) {
                try {
                    return MLFileSystemUtils.rename(component, fileSystemEntry, string);
                }
                catch (IOException iOException) {
                    MJOptionPane.showMessageDialog((Component)component, (Object)ExplorerResources.getString("rename.error"), (String)ExplorerResources.getString("rename.error.title"), (int)0);
                    return null;
                }
            }

            public CloseableEditor createCellEditor(GroupingTable<FileSystemEntry> groupingTable) {
                return new FileNameEditor((FileTable)groupingTable).getEditor();
            }
        }, (Comparator)new Comparator<FileSystemEntry>(){

            @Override
            public int compare(FileSystemEntry fileSystemEntry, FileSystemEntry fileSystemEntry2) {
                return UiFileSystemUtils.compareFileNamesForDisplay(fileSystemEntry.getName(), fileSystemEntry2.getName());
            }
        }, new GroupingMode[0]);
    }

    public GroupingTableColumn<FileSystemEntry> getColumn() {
        return this.fColumn;
    }
}

