/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.actions;

import com.mathworks.matlab.api.explorer.MenuSection;
import com.mathworks.mlwidgets.explorer.model.actions.DynamicMenuContext;
import com.mathworks.mlwidgets.explorer.model.actions.Menu;
import com.mathworks.mlwidgets.explorer.model.actions.RegularMenu;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;

public class Context<T>
implements DynamicMenuContext {
    private final T[] fContext;
    private final Comparator<MenuSection> fComparator;
    private final MenuSection[] fAllowedSections;
    private final Map<MenuSection, List<Object>> fActions;
    private final List<Action> fAllActions;

    public Context(T[] TArray, Comparator<MenuSection> comparator, MenuSection[] menuSectionArray) {
        this.fContext = TArray;
        this.fComparator = comparator;
        this.fAllowedSections = menuSectionArray;
        this.fActions = new HashMap<MenuSection, List<Object>>();
        this.fAllActions = new LinkedList<Action>();
    }

    void add(MenuSection menuSection, Object object) {
        if (!this.allowed(menuSection)) {
            return;
        }
        List<Object> list = this.fActions.get(menuSection);
        if (list == null) {
            list = new LinkedList<Object>();
            this.fActions.put(menuSection, list);
        }
        if (object instanceof Action) {
            this.fAllActions.add((Action)object);
        }
        list.add(object);
    }

    @Override
    public void addAction(MenuSection menuSection, Action action) {
        if (!this.allowed(menuSection)) {
            return;
        }
        this.add(menuSection, action);
    }

    @Override
    public void addSection(MenuSection menuSection) {
        if (!this.allowed(menuSection) || menuSection.getParent() == null) {
            return;
        }
        this.add(menuSection.getParent(), menuSection);
    }

    @Override
    public void addComponent(MenuSection menuSection, Component component) {
        if (!this.allowed(menuSection)) {
            return;
        }
        this.add(menuSection, component);
    }

    @Override
    public void addActionIfEnabled(MenuSection menuSection, Action action) {
        if (this.allowed(menuSection) && action.isEnabled()) {
            this.addAction(menuSection, action);
        }
    }

    @Override
    public T[] getContext() {
        return this.fContext == null ? null : (Object[])this.fContext.clone();
    }

    @Override
    public Action[] getAllActions() {
        return this.fAllActions.toArray(new Action[this.fAllActions.size()]);
    }

    boolean allowed(MenuSection menuSection) {
        return this.fAllowedSections == null || this.fAllowedSections.length == 0 || Arrays.asList(this.fAllowedSections).contains(menuSection);
    }

    public void createMenu(Menu menu) {
        this.createMenu(null, menu);
    }

    public void createMenu(MenuSection menuSection, Menu menu) {
        List<MenuSection> list = this.getChildrenInOrder(menuSection);
        for (MenuSection menuSection2 : list) {
            boolean bl;
            boolean bl2 = bl = menu.getCount() > 0;
            if (bl) {
                menu.addSeparator();
            }
            int n = menu.getCount();
            for (Object object : this.getAllItems(menuSection2)) {
                this.add(object, menu);
            }
            int n2 = menu.getCount();
            if (n != n2 || !bl) continue;
            menu.remove(n - 1);
        }
    }

    public void add(Object object, Menu menu) {
        if (object instanceof MenuSection) {
            List<Object> list;
            MenuSection menuSection = (MenuSection)object;
            if (menuSection.isSubMenuAllowed() && !(list = this.getAllItems(menuSection)).isEmpty()) {
                if (!menuSection.isSubMenuAllowed() || list.size() == 1 && !menuSection.isSubMenuForced()) {
                    for (Object object2 : list) {
                        this.add(object2, menu);
                    }
                } else {
                    RegularMenu regularMenu = new RegularMenu(menuSection.getName());
                    for (Object object3 : this.fActions.get(menuSection)) {
                        this.add(object3, regularMenu);
                    }
                    menu.add(regularMenu.getComponent());
                }
            }
        } else {
            menu.add(object);
        }
    }

    public List<MenuSection> getChildrenInOrder(MenuSection menuSection) {
        Vector<MenuSection> vector = new Vector<MenuSection>();
        for (MenuSection menuSection2 : this.fActions.keySet()) {
            if (menuSection2.getParent() != menuSection) continue;
            vector.add(menuSection2);
        }
        Collections.sort(vector, this.fComparator);
        return vector;
    }

    public List<Object> getAllItems(MenuSection menuSection) {
        Vector<Object> vector = new Vector<Object>();
        List<Object> list = this.fActions.get(menuSection);
        if (list != null) {
            for (Object object : list) {
                vector.add(object);
            }
        }
        for (MenuSection menuSection2 : this.getChildrenInOrder(menuSection)) {
            if (vector.indexOf(menuSection2) >= 0) continue;
            vector.add(menuSection2);
        }
        return vector;
    }
}

