/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.matlab;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.matlab.api.explorer.NewFileTemplate;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.mlwidgets.explorer.extensions.matlab.MATFileUtils;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationContext;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.mlwidgets.explorer.widgets.table.FileTable;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.transfer.ReceiveHandler;
import com.mathworks.widgets.grouptable.transfer.Transfer;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public final class VariableTransferHandler
implements ReceiveHandler<FileSystemEntry> {
    private final NavigationContext fContext;

    public VariableTransferHandler(NavigationContext navigationContext) {
        this.fContext = navigationContext;
    }

    public boolean accept(FileSystemEntry fileSystemEntry, Transfer transfer, boolean bl) {
        if (!transfer.isDataFlavorAvailable(MLDataFlavor.simpleVariableListFlavor)) {
            return false;
        }
        if (fileSystemEntry == null) {
            FileSystemEntry fileSystemEntry2 = this.fContext.getLocationEntry();
            return FileSystemUtils.checkWritePermission(fileSystemEntry2);
        }
        return !fileSystemEntry.isFolder() && fileSystemEntry.getLocation().checkExtension(new String[]{".mat"}) && FileSystemUtils.checkWritePermission(fileSystemEntry);
    }

    public boolean shouldForceCopy(Transfer transfer) {
        return false;
    }

    public Status transfer(final GroupingTable<FileSystemEntry> groupingTable, FileSystemEntry fileSystemEntry, final Transfer transfer, boolean bl, boolean bl2, boolean bl3) {
        final Status status = new Status(ExplorerResources.getString("progress.writingmat"), false);
        if (fileSystemEntry == null) {
            FileLocation fileLocation = this.fContext.getLocation();
            final NewFileTemplate newFileTemplate = new NewFileTemplate(){
                private boolean fWritten;

                public String getName() {
                    return ExplorerResources.getString("template.matfile");
                }

                public String getDefaultFileName(FileSystem fileSystem, FileLocation fileLocation) {
                    return "Untitled.mat";
                }

                public void writeDefaultContent(FileSystemTransaction fileSystemTransaction, FileLocation fileLocation) throws IOException {
                    if (this.fWritten) {
                        return;
                    }
                    List list = transfer.getTransferList(MLDataFlavor.simpleVariableListFlavor);
                    File file = new File(fileLocation.toString());
                    MATFileUtils.save((Component)groupingTable, file, MATFileUtils.getVariableNames(list), true);
                    this.fWritten = true;
                }

                public void writeDefaultContent(Writer writer, FileLocation fileLocation) {
                    throw new UnsupportedOperationException();
                }
            };
            UiFileSystemUtils.createNewFile(newFileTemplate, this.fContext.getSystem(), fileLocation, new ParameterRunnable<FileSystemEntry>(){

                public void run(final FileSystemEntry fileSystemEntry) {
                    status.markCompleted();
                    ((FileTable)groupingTable).continueAfterPendingTransactions(new Runnable(){

                        @Override
                        public void run() {
                            ((FileTable)groupingTable).renameNewFile(fileSystemEntry, newFileTemplate);
                        }
                    });
                }
            }, new ParameterRunnable<IOException>(){

                public void run(IOException iOException) {
                    status.markCompleted();
                }
            });
        } else {
            List list;
            File file = new File(fileSystemEntry.getLocation().toString());
            if (transfer.isDataFlavorAvailable(MLDataFlavor.simpleVariableListFlavor) && MATFileUtils.confirmOverwriteFileIfNecessary(groupingTable, list = transfer.getTransferList(MLDataFlavor.simpleVariableListFlavor), file)) {
                MATFileUtils.save(groupingTable, file, MATFileUtils.getVariableNames(list), false);
            }
            status.markCompleted();
        }
        return status;
    }
}

