/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.matlab;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MLFileUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.explorer.ActionConfiguration;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.FileDecoration;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileDecorators;
import com.mathworks.matlab.api.explorer.FileInfoProvider;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlwidgets.dialog.PathChange;
import com.mathworks.mlwidgets.explorer.extensions.matlab.H1Retriever;
import com.mathworks.mlwidgets.explorer.extensions.matlab.MFileType;
import com.mathworks.mlwidgets.explorer.extensions.matlab.MFileTypeFinder;
import com.mathworks.mlwidgets.explorer.extensions.matlab.MatlabCodeFileDetailPanel;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.util.Converter;
import com.mathworks.util.DeferrableRetriever;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.StringUtils;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public final class MatlabCodeFileInfoProvider
implements FileInfoProvider,
ActionProvider {
    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return !fileSystemEntry.isFolder() && MLFileUtils.isMatlabCodeFile((String)fileSystemEntry.getLocation().toString());
    }

    public void configureDecorations(final FileSystemEntry fileSystemEntry, FileDecorators fileDecorators, FileDecorations fileDecorations) {
        FileDecoration fileDecoration = new FileDecoration("m-file-type");
        fileDecorators.set(fileDecoration, (DeferrableRetriever)new DeferrableRetriever<MFileType>(){

            public void run(ParameterRunnable<MFileType> parameterRunnable, Runnable runnable) {
                parameterRunnable.run((Object)MFileTypeFinder.findMFileType(fileSystemEntry));
            }
        });
        fileDecorators.set(CoreFileDecoration.TYPE_NAME, fileDecoration, (Converter)new Converter<MFileType, String>(){

            public String convert(MFileType mFileType) {
                return mFileType.getDescription();
            }
        });
        fileDecorators.set(CoreFileDecoration.ICON, fileDecoration, (Converter)new Converter<MFileType, Icon>(){

            public Icon convert(MFileType mFileType) {
                return mFileType.getIcon();
            }
        });
        fileDecorators.set(CoreFileDecoration.DESCRIPTION, (DeferrableRetriever)new H1Retriever(fileSystemEntry));
        fileDecorators.set(CoreFileDecoration.DETAIL_PANEL, MatlabCodeFileDetailPanel.class, new Object[]{fileSystemEntry, fileDecorations});
    }

    public void configureActions(ActionRegistry actionRegistry) {
        actionRegistry.getAction(CoreActionID.OPEN_AS_TEXT).setEnabled(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.OPEN_AS_TEXT).setVisibleOnContextMenu(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.OPEN_OUTSIDE_MATLAB).setEnabled(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.OPEN_OUTSIDE_MATLAB).setVisibleOnContextMenu(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.IMPORT_DATA).setEnabled(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.IMPORT_DATA).setVisibleOnContextMenu(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.VIEW_HELP).setCode(SelectionMode.EXPLICIT_MULTIPLE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                ArrayList<Status> arrayList = new ArrayList<Status>();
                for (FileSystemEntry fileSystemEntry : actionInput.getSelection()) {
                    final Status status = new Status();
                    arrayList.add(status);
                    try {
                        final FileSystemEntry fileSystemEntry2 = MLFileSystemUtils.getMatlabAccessibleEntry(fileSystemEntry);
                        final File file = new File(fileSystemEntry2.getLocation().toString());
                        new PathChange((Frame)SwingUtilities.windowForComponent(actionInput.getComponent()), ExplorerResources.getString("title"), ExplorerResources.getString("msg.ToViewHelp"), file.getAbsolutePath(), file, new CompletionObserver(){

                            public void completed(int n, Object object) {
                                String string = MatlabPath.getQualifiedFunctionOrMethodName((File)file);
                                new Matlab().evalNoOutput("doc('" + StringUtils.quoteSingleQuotes((String)string) + "')");
                                status.markCompleted();
                                MLFileSystemUtils.releaseMatlabAccessibleEntry(fileSystemEntry2);
                            }
                        }, "matlab_env_csh", true);
                    }
                    catch (IOException iOException) {
                        status.markCompleted();
                    }
                }
                return new Status(arrayList);
            }
        });
    }
}

