/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.basic;

import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.extensions.basic.CoreExternalActionProvider;
import com.mathworks.mlwidgets.explorer.extensions.basic.CoreReadActionProvider;
import com.mathworks.mlwidgets.explorer.extensions.basic.CoreWriteActionProvider;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;

public final class CoreActionProvider
implements ActionProvider {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.explorer.resources.RES_Explorer");
    private final Collection<ActionProvider> fDelegateActionProviders = new ArrayList<ActionProvider>();

    public CoreActionProvider() {
        this.fDelegateActionProviders.add(new CoreReadActionProvider());
        this.fDelegateActionProviders.add(new CoreWriteActionProvider());
        this.fDelegateActionProviders.add(new CoreExternalActionProvider());
    }

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return true;
    }

    public void configureActions(ActionRegistry actionRegistry) {
        for (ActionProvider actionProvider : this.fDelegateActionProviders) {
            actionProvider.configureActions(actionRegistry);
        }
    }

    public static String formatLabel(String string, String string2, List<FileSystemEntry> list) {
        if (list.size() == 1) {
            return MessageFormat.format(ExplorerResources.getString(string), list.get(0).getName());
        }
        return ExplorerResources.getString(string2);
    }
}

