/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.basic;

import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.Row;
import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.actions.CoreMenuSection;
import com.mathworks.mlwidgets.explorer.model.actions.TableActionInput;
import com.mathworks.mlwidgets.explorer.widgets.table.FileTable;
import com.mathworks.widgets.grouptable.GroupingTableRow;
import java.util.List;

public final class BasicTableActionProvider
implements ActionProvider {
    private static final ActionDefinition SELECT_TO_BEGINNING = new ActionDefinition("selection-begin", true, ExplorerResources.getString("context.selectToBeginning"));
    private static final ActionDefinition SELECT_TO_END = new ActionDefinition("selection-end", true, ExplorerResources.getString("context.selectToEnd"));
    private static final ActionDefinition MOVE_TO_BEGINNING = new ActionDefinition("caret-begin", true, ExplorerResources.getString("context.moveToBeginning"));
    private static final ActionDefinition MOVE_TO_END = new ActionDefinition("caret-end", true, ExplorerResources.getString("context.moveToEnd"));
    private static final ActionDefinition EXPAND = new ActionDefinition("expand", true);
    private static final ActionDefinition EXPAND_OR_SELECT = new ActionDefinition("expand-or-select", true);
    private static final ActionDefinition COLLAPSE = new ActionDefinition("collapse", true);
    private static final ActionDefinition COLLAPSE_OR_SELECT = new ActionDefinition("collapse-or-select", true);
    private static final ActionDefinition COLLAPSE_ALL = new ActionDefinition("collapseAll", CoreMenuSection.REFRESH.getSection(), ExplorerResources.getString("context.collapseAll"));

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return true;
    }

    public void configureActions(ActionRegistry actionRegistry) {
        actionRegistry.defineAction(SELECT_TO_BEGINNING).setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileTable fileTable = ((TableActionInput)actionInput).getTable();
                int n = fileTable.getSelectionModel().getAnchorSelectionIndex();
                if (n > -1) {
                    fileTable.clearSelection();
                    fileTable.getSelectionModel().setSelectionInterval(n, 0);
                    fileTable.scrollRowToVisible(0);
                }
                return Status.COMPLETED;
            }
        });
        actionRegistry.defineAction(SELECT_TO_END).setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileTable fileTable = ((TableActionInput)actionInput).getTable();
                int n = fileTable.getSelectionModel().getAnchorSelectionIndex();
                if (n > -1) {
                    int n2 = fileTable.getRowCount() - 1;
                    fileTable.clearSelection();
                    fileTable.getSelectionModel().setSelectionInterval(n, n2);
                    fileTable.scrollRowToVisible(n2);
                }
                return Status.COMPLETED;
            }
        });
        actionRegistry.defineAction(MOVE_TO_BEGINNING).setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileTable fileTable = ((TableActionInput)actionInput).getTable();
                if (fileTable.getRowCount() > 0) {
                    fileTable.getSelectionModel().setSelectionInterval(0, 0);
                    fileTable.scrollRowToVisible(0);
                }
                return Status.COMPLETED;
            }
        });
        actionRegistry.defineAction(MOVE_TO_END).setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileTable fileTable = ((TableActionInput)actionInput).getTable();
                if (fileTable.getRowCount() > 0) {
                    int n = fileTable.getRowCount() - 1;
                    fileTable.getSelectionModel().setSelectionInterval(n, n);
                    fileTable.scrollRowToVisible(n);
                }
                return Status.COMPLETED;
            }
        });
        actionRegistry.defineAction(EXPAND).setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileTable fileTable = ((TableActionInput)actionInput).getTable();
                int n = fileTable.getSelectedRow();
                if (n > -1) {
                    fileTable.expandRow(n, true);
                }
                return Status.COMPLETED;
            }
        });
        actionRegistry.defineAction(COLLAPSE).setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileTable fileTable = ((TableActionInput)actionInput).getTable();
                int n = fileTable.getSelectedRow();
                if (n > -1) {
                    fileTable.expandRow(n, false);
                }
                return Status.COMPLETED;
            }
        });
        actionRegistry.defineAction(EXPAND_OR_SELECT).setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileTable fileTable = ((TableActionInput)actionInput).getTable();
                int n = fileTable.getSelectedRow();
                if (n > -1) {
                    GroupingTableRow groupingTableRow = fileTable.getRowAt(n);
                    if (groupingTableRow != null && groupingTableRow instanceof Expandable && ((Expandable)groupingTableRow).isExpanded()) {
                        int n2;
                        ExpandableRow expandableRow = (ExpandableRow)groupingTableRow;
                        List list = expandableRow.getChildren();
                        if (!list.isEmpty() && (n2 = fileTable.getRowIndex((Row)list.get(0))) > -1) {
                            fileTable.getSelectionModel().setSelectionInterval(n2, n2);
                            fileTable.scrollRowToVisible(n2);
                        }
                    } else {
                        fileTable.expandRow(n, true);
                    }
                }
                return Status.COMPLETED;
            }
        });
        actionRegistry.defineAction(COLLAPSE_OR_SELECT).setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileTable fileTable = ((TableActionInput)actionInput).getTable();
                int n = fileTable.getSelectedRow();
                if (n > -1) {
                    GroupingTableRow groupingTableRow = fileTable.getRowAt(n);
                    if (!(groupingTableRow == null || groupingTableRow instanceof Expandable && ((Expandable)groupingTableRow).isExpanded())) {
                        int n2 = ((TableActionInput)actionInput).getParentRowIndex();
                        if (n2 > -1) {
                            fileTable.getSelectionModel().setSelectionInterval(n2, n2);
                            fileTable.scrollRowToVisible(n2);
                        }
                    } else {
                        fileTable.expandRow(n, false);
                    }
                }
                return Status.COMPLETED;
            }
        });
        actionRegistry.defineAction(COLLAPSE_ALL).setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileTable fileTable = ((TableActionInput)actionInput).getTable();
                fileTable.collapseFirstLevel();
                if (fileTable.getConfiguration().getGroupMode() != null) {
                    fileTable.getConfiguration().collapseAllGroups();
                }
                return Status.COMPLETED;
            }
        });
    }
}

