/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.archive;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.extensions.archive.ZipFileSystem;
import com.mathworks.mlwidgets.explorer.model.AbstractFileList;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.Holder;
import com.mathworks.util.Predicate;
import java.io.IOException;
import java.util.HashSet;

final class ZipFileList
extends AbstractFileList {
    private final ZipFileSystem fZipFileSystem;
    private final FileLocation fLocation;

    ZipFileList(ZipFileSystem zipFileSystem, FileLocation fileLocation) throws IOException {
        super((FileSystem)zipFileSystem, fileLocation);
        this.fZipFileSystem = zipFileSystem;
        this.fLocation = fileLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFilesAndFolders(final AsyncReceiver<FileSystemEntry> asyncReceiver) throws IOException {
        try {
            final HashSet hashSet = new HashSet();
            this.fZipFileSystem.getEntries(new Predicate<FileSystemEntry>(){

                public boolean accept(FileSystemEntry fileSystemEntry) {
                    return !hashSet.add(fileSystemEntry.getLocation()) || !fileSystemEntry.getLocation().isDirectChildOf(ZipFileList.this.fLocation) || asyncReceiver.receive((Object)fileSystemEntry);
                }
            });
        }
        finally {
            asyncReceiver.finished();
        }
    }

    @Override
    public boolean isEmpty() throws IOException {
        final Holder holder = new Holder();
        holder.set((Object)true);
        this.fZipFileSystem.getEntries(new Predicate<FileSystemEntry>(){

            public boolean accept(FileSystemEntry fileSystemEntry) {
                if (fileSystemEntry.getLocation().hasPrefix(ZipFileList.this.fLocation)) {
                    holder.set((Object)false);
                    return false;
                }
                return true;
            }
        });
        return (Boolean)holder.get();
    }
}

