/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.archive;

import com.mathworks.matlab.api.explorer.ActionConfiguration;
import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileDecorators;
import com.mathworks.matlab.api.explorer.FileInfoProvider;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.MountLevel;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlwidgets.explorer.extensions.archive.ArchiveType;
import com.mathworks.mlwidgets.explorer.extensions.archive.ZipFileSystem;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.actions.CoreMenuSection;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualFileSystem;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.UiFileTransfer;
import com.mathworks.mlwidgets.explorer.util.UiFileTransferType;
import com.mathworks.mlwidgets.explorer.widgets.table.FileTable;
import com.mathworks.util.AsyncReceiver;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ZipFileInfoProvider
implements FileInfoProvider,
ActionProvider {
    private static final ActionDefinition EXTRACT = new ActionDefinition("extract-archive", true, CoreMenuSection.OPEN.getSection(), ExplorerResources.getString("context.extract"));

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return fileSystemEntry.getLocation().checkExtension(new String[]{"zip", "jar"});
    }

    public void configureDecorations(FileSystemEntry fileSystemEntry, FileDecorators fileDecorators, FileDecorations fileDecorations) {
    }

    public void configureActions(ActionRegistry actionRegistry) {
        actionRegistry.getAction(CoreActionID.OPEN_AS_TEXT).setEnabled(ActionConfiguration.NEVER);
        StatusRunnable<ActionInput> statusRunnable = new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                return ZipFileInfoProvider.extractArchives(actionInput);
            }
        };
        actionRegistry.defineAction(EXTRACT).setCode(SelectionMode.EXPLICIT_MULTIPLE_SELECTION, (StatusRunnable)statusRunnable);
        actionRegistry.getAction(CoreActionID.OPEN).setCode(SelectionMode.EXPLICIT_MULTIPLE_SELECTION, (StatusRunnable)statusRunnable);
        actionRegistry.setActionPosition(EXTRACT, actionRegistry.getAction(CoreActionID.OPEN).getDefinition());
        actionRegistry.getAction(CoreActionID.OPEN).setVisibleOnContextMenu(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.OPEN).setEnabled(ActionConfiguration.ALWAYS);
        actionRegistry.getAction(CoreActionID.NEW_FILE_MENU).setVisibleOnContextMenu(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.NEW_FILE_MENU).setEnabled(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.NEW_FOLDER).setVisibleOnContextMenu(ActionConfiguration.NEVER);
        actionRegistry.getAction(CoreActionID.NEW_FOLDER).setEnabled(ActionConfiguration.NEVER);
    }

    private static Status extractArchives(final ActionInput actionInput) {
        final ArrayList<Status> arrayList = new ArrayList<Status>();
        final List<FileSystemEntry> list = FileSystemUtils.getUnderlyingEntries(actionInput.getSelection());
        FileSystemEntry fileSystemEntry = null;
        if (list.size() == 1) {
            fileSystemEntry = list.get(0);
        }
        String string = fileSystemEntry != null ? MessageFormat.format(ExplorerResources.getString("progress.extract"), fileSystemEntry.getName()) : ExplorerResources.getString("progress.extract.multiple");
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(new Status(string, true));
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < list.size(); ++i) {
                    FileSystemEntry fileSystemEntry = (FileSystemEntry)list.get(i);
                    Status status = (Status)arrayList.get(i);
                    ArchiveType archiveType = ArchiveType.get(fileSystemEntry);
                    if (archiveType != null) {
                        File file = FileSystemUtils.getClosestRealAncestor(fileSystemEntry);
                        File file2 = new File(file, ZipFileInfoProvider.stripExtension(fileSystemEntry.getName()));
                        ZipFileInfoProvider.extractArchive(status, actionInput.getComponent(), fileSystemEntry, file2);
                        continue;
                    }
                    status.markCompleted();
                }
            }
        }, "ZipFileInfoProvider A").start();
        return new Status(arrayList);
    }

    private static String stripExtension(String string) {
        String string2 = string.substring(0, string.lastIndexOf(46));
        if (string2.toLowerCase().endsWith(".tar")) {
            string2 = string2.substring(0, string2.length() - 4);
        }
        return string2;
    }

    private static void extractArchive(final Status status, final Component component, final FileSystemEntry fileSystemEntry, File file) {
        try {
            final VirtualFileSystem virtualFileSystem = new VirtualFileSystem();
            final ZipFileSystem zipFileSystem = new ZipFileSystem(fileSystemEntry, MountLevel.LOCK_ALLOWED);
            virtualFileSystem.mount(fileSystemEntry.getLocation(), zipFileSystem);
            FileSystemEntry fileSystemEntry2 = virtualFileSystem.getEntry(fileSystemEntry.getLocation());
            UiFileTransfer uiFileTransfer = new UiFileTransfer(component, UiFileTransferType.EXTRACT_ARCHIVE, RealFileSystem.getInstance(), new FileLocation(file), fileSystemEntry.getLocation(), Arrays.asList(fileSystemEntry2), new AsyncReceiver<FileLocation>(){

                public boolean receive(FileLocation fileLocation) {
                    if (component instanceof FileTable) {
                        try {
                            FileTable fileTable = (FileTable)((Object)component);
                            FileSystemEntry fileSystemEntry2 = fileTable.getContext().getSystem().getEntry(fileLocation);
                            fileTable.selectNewFile(fileSystemEntry2, true, true);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return true;
                }

                public void finished() {
                    zipFileSystem.close();
                    virtualFileSystem.unmount(fileSystemEntry.getLocation());
                    status.markCompleted();
                }
            });
            new Thread((Runnable)uiFileTransfer, "ZipFileInfoProvider B").start();
        }
        catch (IOException iOException) {
            UiFileTransferType.EXTRACT_ARCHIVE.showError(component, fileSystemEntry);
            status.markCompleted();
        }
    }
}

