/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.archive;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.extensions.archive.ZipFileSystem;
import com.mathworks.mlwidgets.explorer.extensions.archive.ZipInput;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.util.Predicate;
import com.mathworks.util.ThrowableClosure;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;

public final class CommonsCompressZipInput
implements ZipInput {
    public static final String UTF_8 = "UTF-8";
    private final FileSystemEntry fZipFile;
    private FileSystemEntry fRealZipFile;
    private ZipFile fCommonsCompressZipFile;
    private volatile int fInputStreamCount;
    private volatile Long fLastInputStreamThreadId;

    public CommonsCompressZipInput(FileSystemEntry fileSystemEntry) {
        this.fZipFile = fileSystemEntry;
    }

    @Override
    public void getEntries(final ZipFileSystem zipFileSystem, final Predicate<FileSystemEntry> predicate) throws IOException {
        this.withZipFile(new ThrowableClosure<Void, ZipFile, IOException>(){

            public Void run(ZipFile zipFile) throws IOException {
                Enumeration enumeration = zipFile.getEntries();
                while (enumeration.hasMoreElements()) {
                    ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)enumeration.nextElement();
                    if (predicate.accept((Object)CommonsCompressZipInput.wrapEntry(zipFileSystem, zipArchiveEntry))) continue;
                    return null;
                }
                return null;
            }
        });
    }

    @Override
    public InputStream getInputStream(final FileLocation fileLocation) throws IOException {
        return this.withZipFile(new ThrowableClosure<InputStream, ZipFile, IOException>(){

            public InputStream run(ZipFile zipFile) throws IOException {
                String string = FilenameUtils.normalize((String)fileLocation.toString());
                ZipArchiveEntry zipArchiveEntry = zipFile.getEntry(string);
                if (zipArchiveEntry == null) {
                    zipArchiveEntry = zipFile.getEntry(string.replace(File.separatorChar, '/'));
                }
                if (zipArchiveEntry == null) {
                    zipArchiveEntry = zipFile.getEntry(string.replace(File.separatorChar, '\\'));
                }
                if (zipArchiveEntry == null && string.startsWith("/")) {
                    zipArchiveEntry = zipFile.getEntry(string.substring(1));
                }
                if (zipArchiveEntry == null) {
                    zipArchiveEntry = CommonsCompressZipInput.getEntryWithSeparatorPrefix(zipFile, string);
                }
                if (zipArchiveEntry == null) {
                    throw new IOException("Location does not exist: " + fileLocation);
                }
                return new InputStreamFilter(zipFile.getInputStream(zipArchiveEntry));
            }
        });
    }

    public static ZipArchiveEntry getEntryWithSeparatorPrefix(ZipFile zipFile, String string) {
        String string2 = "/".concat(string.replace(File.separator, "/"));
        return zipFile.getEntry(string2);
    }

    @Override
    public boolean isLocked() {
        return this.fInputStreamCount > 0 && this.fLastInputStreamThreadId != null && Thread.currentThread().getId() != this.fLastInputStreamThreadId.longValue();
    }

    private <T> T withZipFile(ThrowableClosure<T, ZipFile, IOException> throwableClosure) throws IOException {
        if (this.fRealZipFile == null) {
            this.fRealZipFile = MLFileSystemUtils.getMatlabAccessibleEntry(this.fZipFile);
        }
        if (this.fCommonsCompressZipFile == null) {
            this.fCommonsCompressZipFile = new ZipFile(this.fRealZipFile.getLocation().toFile(), UTF_8);
        }
        return (T)throwableClosure.run((Object)this.fCommonsCompressZipFile);
    }

    @Override
    public void close() throws IOException {
        if (this.fCommonsCompressZipFile != null) {
            this.fCommonsCompressZipFile.close();
        }
        if (this.fRealZipFile != null) {
            MLFileSystemUtils.releaseMatlabAccessibleEntry(this.fRealZipFile);
        }
    }

    private static FileSystemEntry wrapEntry(ZipFileSystem zipFileSystem, ZipArchiveEntry zipArchiveEntry) {
        return new FileSystemEntry((FileSystem)zipFileSystem, new FileLocation(zipArchiveEntry.getName()), false, zipArchiveEntry.isDirectory(), zipArchiveEntry.getSize(), zipArchiveEntry.getTime(), 0L);
    }

    private class InputStreamFilter
    extends FilterInputStream {
        InputStreamFilter(InputStream inputStream) {
            super(inputStream);
            CommonsCompressZipInput.this.fInputStreamCount++;
            CommonsCompressZipInput.this.fLastInputStreamThreadId = Thread.currentThread().getId();
        }

        @Override
        public void close() throws IOException {
            super.close();
            CommonsCompressZipInput.this.fInputStreamCount--;
        }
    }
}

