/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.debug;

import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorEvent;
import com.mathworks.matlab.api.editor.actions.DebuggerActions;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.widgets.debug.DebuggerManager;
import com.mathworks.widgets.editor.SelfRemovingEditorEventListener;
import java.awt.event.ActionEvent;
import org.apache.commons.lang.Validate;

public class RunOrContinueAction
extends MJAbstractAction {
    private final MJAbstractAction fRunAction;
    private final DebuggerManager.DebuggerManagerStateListener fDebuggerManagerStateListener = this.createDebuggerManagerStateListener();
    private final Editor fEditor;

    public RunOrContinueAction(MJAbstractAction mJAbstractAction, Editor editor) {
        Validate.notNull((Object)mJAbstractAction, (String)"The default run action can not be null");
        Validate.notNull((Object)editor, (String)"The editor can not be null");
        this.fRunAction = mJAbstractAction;
        this.fEditor = editor;
        MatlabKeyBindings.getManager().addKeyBindingAndActionInfo(mJAbstractAction.getContextID(), mJAbstractAction.getActionID(), (ExtendedAction)this);
        DebuggerManager.addDebugManagerStateListener((DebuggerManager.DebuggerManagerStateListener)this.fDebuggerManagerStateListener);
        this.registerSelfRemovingEditorEventListener(editor);
    }

    private void updateActionPropertiesIfEditorIsOpen() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (RunOrContinueAction.this.fEditor.isOpen()) {
                    RunOrContinueAction.this.updateActionProperties();
                }
            }
        });
    }

    private void updateActionProperties() {
        if (DebuggerManager.isDebugging()) {
            this.setName((String)DebuggerManager.getInstance().getContinueAction().getValue("Name"));
            this.setEnabled(DebuggerManager.getInstance().getContinueAction().isEnabled());
        } else {
            this.setName(this.fRunAction.getName());
            this.setEnabled(this.fRunAction.isEnabled());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (DebuggerManager.isDebugging()) {
            DebuggerManager.getInstance().getContinueActionNoEcho().actionPerformed(actionEvent);
        } else {
            this.fRunAction.actionPerformed(actionEvent);
        }
    }

    private DebuggerManager.DebuggerManagerStateListener createDebuggerManagerStateListener() {
        return new DebuggerManager.DebuggerManagerStateListener(){

            public void stateUpdated(DebuggerManager.DebuggerTransition debuggerTransition, Class<? extends DebuggerActions> clazz) {
                RunOrContinueAction.this.updateActionPropertiesIfEditorIsOpen();
            }
        };
    }

    private void registerSelfRemovingEditorEventListener(Editor editor) {
        new SelfRemovingEditorEventListener(editor){

            public void cleanup() {
                DebuggerManager.removeDebugManagerStateListener((DebuggerManager.DebuggerManagerStateListener)RunOrContinueAction.this.fDebuggerManagerStateListener);
            }

            public void handleEventOccurred(EditorEvent editorEvent) {
                if (editorEvent == EditorEvent.RENAMED || editorEvent == EditorEvent.DIRTY_STATE_CHANGED || editorEvent == EditorEvent.ACTIVATED) {
                    RunOrContinueAction.this.updateActionPropertiesIfEditorIsOpen();
                }
            }
        };
    }
}

