/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.cwd;

import com.mathworks.common.icons.FolderIcon;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mlwidgets.cwd.CwdDisplayPrefs;
import com.mathworks.mlwidgets.path.PathUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistrant;
import com.mathworks.services.Prefs;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.ComponentIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class CwdComponentSet {
    private static DefaultComboBoxModel sComboModel;
    private static boolean sComboActionListenersAreEnabled;
    private final MJComboBox fDirectoryCombo;
    private final MJButton fBrowseButton;
    private final MJButton fGoUpButton;
    private final JComponent fBrowseComponent;
    private final JComponent fGoUpComponent;
    private final ImageIcon fBrowseIcon;
    private final GoUpAction fGoUpAction;
    private final FolderChooserAction fBrowseAction;
    private PathAction fPathAction;
    private Component fPreviousFocusOwner;
    private List<Component> fFocusList = new ArrayList<Component>(3);
    private boolean fLastChangeFailed;
    private boolean fIsEditingEntry;
    private boolean fShowingWarningDialog;
    private static final ResourceBundle sRes;
    private static final String HISTORY_FILE_NAME = "cwdhistory.m";
    private static final String COMBO_ACTION_COMMAND = "SelectionChanged";

    public CwdComponentSet() {
        CustomFocusHandler customFocusHandler = new CustomFocusHandler();
        CustomKeyHandler customKeyHandler = new CustomKeyHandler();
        if (sComboModel == null) {
            sComboModel = new DefaultComboBoxModel();
            CwdComponentSet.loadHistory();
        }
        this.fDirectoryCombo = new CustomComboBox();
        MJUtilities.registerWithKeyBindingManager((KeyBindingManagerRegistrant)this.fDirectoryCombo, (KeyBindingManager)MatlabKeyBindings.getManager(), (String)"MATLABDesktop");
        this.fDirectoryCombo.getAccessibleContext().setAccessibleName(sRes.getString("CurrentDirectoryTitle"));
        this.fDirectoryCombo.setEditable(true);
        this.fDirectoryCombo.setModel((ComboBoxModel)sComboModel);
        this.fDirectoryCombo.setMaximumRowCount(16);
        this.fDirectoryCombo.setTipWhenTruncatedEnabled(true);
        this.fDirectoryCombo.setName("Current Directory History");
        this.fDirectoryCombo.setActionCommand(COMBO_ACTION_COMMAND);
        this.fDirectoryCombo.getEditor().getEditorComponent().addFocusListener(customFocusHandler);
        this.fDirectoryCombo.getEditor().getEditorComponent().addKeyListener(customKeyHandler);
        this.fDirectoryCombo.getEditor().getEditorComponent().setFocusTraversalKeysEnabled(false);
        this.fFocusList.add(this.fDirectoryCombo.getEditor().getEditorComponent());
        this.fDirectoryCombo.addActionListener((ActionListener)new ComboBoxActionListener());
        this.fBrowseAction = new FolderChooserAction();
        if (PlatformInfo.isWindowsModernAppearance()) {
            this.fBrowseButton = new MJButton((Action)((Object)this.fBrowseAction));
            this.fBrowseButton.setMargin(new Insets(0, 2, 0, 2));
            this.fBrowseComponent = Box.createHorizontalBox();
            this.fBrowseComponent.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.fBrowseComponent.add((Component)this.fBrowseButton);
        } else if (PlatformInfo.isMacintosh()) {
            this.fBrowseButton = new MJButton((Action)((Object)this.fBrowseAction)){

                public Dimension getPreferredSize() {
                    if (this.getText() == null || this.getIcon() != null) {
                        return super.getPreferredSize();
                    }
                    FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                    Insets insets = this.getMargin();
                    return new Dimension(insets.left + insets.right + fontMetrics.stringWidth(this.getText()), 16);
                }
            };
            this.fBrowseButton.setFocusTraversable(false);
            this.fBrowseButton.setMargin(new Insets(0, 3, 0, 3));
            this.fBrowseComponent = this.fBrowseButton;
        } else {
            this.fBrowseButton = new MJButton((Action)((Object)this.fBrowseAction));
            this.fBrowseButton.setMargin(new Insets(0, 0, 0, 0));
            this.fBrowseButton.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2), this.fBrowseButton.getBorder()));
            this.fBrowseComponent = this.fBrowseButton;
        }
        this.fBrowseButton.getAccessibleContext().setAccessibleName(sRes.getString("BrowseforFolder"));
        this.fBrowseButton.addFocusListener((FocusListener)customFocusHandler);
        this.fBrowseButton.addKeyListener((KeyListener)customKeyHandler);
        this.fBrowseButton.setFocusTraversalKeysEnabled(false);
        this.fFocusList.add((Component)this.fBrowseButton);
        this.fBrowseIcon = ComponentIcon.createIcon((JComponent)this.fBrowseButton);
        this.fGoUpAction = new GoUpAction();
        if (PlatformInfo.isWindowsModernAppearance()) {
            this.fGoUpButton = new MJButton((Action)((Object)this.fGoUpAction));
            this.fGoUpButton.hideText();
            this.fGoUpButton.setMargin(new Insets(1, 1, 1, 1));
            this.fGoUpButton.setFlyOverAppearance(true);
            this.fGoUpComponent = Box.createHorizontalBox();
            this.fGoUpComponent.add((Component)this.fGoUpButton);
        } else {
            this.fGoUpButton = new MJButton((Action)((Object)this.fGoUpAction));
            MJToolBar.configureButton((MJButton)this.fGoUpButton);
            this.fGoUpComponent = this.fGoUpButton;
        }
        this.fGoUpButton.addFocusListener((FocusListener)customFocusHandler);
        this.fGoUpButton.addKeyListener((KeyListener)customKeyHandler);
        this.fGoUpButton.setFocusTraversalKeysEnabled(false);
        this.fFocusList.add((Component)this.fGoUpButton);
        String string = System.getProperty("user.dir");
        if (string != null && !string.equals("")) {
            this.recordDirectory(string);
        }
        this.fPathAction = new PathAction();
        MatlabPath.addActionListener((ActionListener)this.fPathAction);
        this.refresh();
    }

    public JComboBox getDirectoryCombo() {
        return this.fDirectoryCombo;
    }

    public JComponent getBrowseButton() {
        return this.fBrowseComponent;
    }

    public JComponent getUpOneButton() {
        return this.fGoUpComponent;
    }

    public String getDirectoryLabel() {
        String string = sRes.getString("CurrentDirectoryLabel");
        if (string.endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public String getBrowseLabel() {
        return this.fBrowseAction.getTip();
    }

    public String getUpOneLabel() {
        return this.fGoUpAction.getName();
    }

    public Icon getBrowseIcon() {
        return this.fBrowseIcon;
    }

    public Icon getUpOneIcon() {
        return this.fGoUpAction.getButtonOnlyIcon();
    }

    public void cleanup() {
        this.fDirectoryCombo.setModel(new DefaultComboBoxModel());
    }

    public void refresh() {
        this.fIsEditingEntry = false;
        this.fLastChangeFailed = false;
        this.recordDirectory(MatlabPath.getCWD());
    }

    private void addItem(String string) {
        sComboActionListenersAreEnabled = false;
        if (PlatformInfo.isWindows()) {
            int n = sComboModel.getSize();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)sComboModel.getElementAt(i);
                if (!string2.toLowerCase().equals(string.toLowerCase())) continue;
                sComboModel.removeElement(string2);
                break;
            }
        } else {
            sComboModel.removeElement(string);
        }
        sComboModel.insertElementAt(string, 0);
        this.fDirectoryCombo.getEditor().setItem(string);
        this.fDirectoryCombo.setSelectedItem((Object)string);
        sComboActionListenersAreEnabled = true;
    }

    private void recordDirectory(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        string = string.trim();
        if (PlatformInfo.isUnix() && string.equals("")) {
            string = "/";
        }
        boolean bl = !(PlatformInfo.isUnix() && string.equals("/") || PlatformInfo.isWindows() && (string.length() == 3 && string.endsWith(":\\") || CwdComponentSet.isTopOfUNCPath(string)));
        this.fGoUpAction.setEnabled(bl);
        if (!bl && this.fGoUpButton.hasFocus()) {
            this.fDirectoryCombo.requestFocus();
        }
        this.setGoUpButtonFocusEnabled(bl && this.fBrowseButton.isFocusTraversable());
        this.addItem(string);
    }

    private static boolean isTopOfUNCPath(String string) {
        if (!string.startsWith("\\\\")) {
            return false;
        }
        int n = string.indexOf("\\", 2);
        return string.indexOf("\\", n + 1) == -1;
    }

    private static File getHistoryFile() {
        return new File(Prefs.getPropertyDirectory(), HISTORY_FILE_NAME);
    }

    private static void loadHistory() {
        File file = CwdComponentSet.getHistoryFile();
        if (file.exists()) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                while ((string = bufferedReader.readLine()) != null) {
                    if ((string = string.trim()).length() <= 0) continue;
                    sComboModel.addElement(string);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void saveHistory() {
        if (sComboModel == null) {
            return;
        }
        File file = CwdComponentSet.getHistoryFile();
        try {
            file.delete();
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            int n = CwdDisplayPrefs.getNumDirectoriesToSave();
            int n2 = sComboModel.getSize();
            if (n > n2) {
                n = n2;
            }
            for (int i = 0; i < n; ++i) {
                String string = (String)sComboModel.getElementAt(i);
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void clearHistory() {
        if (sComboModel != null) {
            sComboModel.removeAllElements();
        }
    }

    void relinquishFocus() {
        if (this.fPreviousFocusOwner != null) {
            this.fPreviousFocusOwner.requestFocus();
            this.fPreviousFocusOwner = null;
        }
    }

    private void setButtonFocusEnabled(boolean bl) {
        if (!PlatformInfo.isMacintosh()) {
            this.setBrowseButtonFocusEnabled(bl);
            this.setGoUpButtonFocusEnabled(bl);
        }
    }

    private void setBrowseButtonFocusEnabled(boolean bl) {
        if (!PlatformInfo.isMacintosh()) {
            this.fBrowseButton.setFocusTraversable(bl);
            this.fBrowseButton.setDefaultCapable(bl);
        }
    }

    private void setGoUpButtonFocusEnabled(boolean bl) {
        if (!PlatformInfo.isMacintosh()) {
            boolean bl2 = bl && this.fGoUpButton.isEnabled();
            this.fGoUpButton.setFocusTraversable(bl2);
            this.fGoUpButton.setDefaultCapable(bl2);
        }
    }

    static {
        sComboActionListenersAreEnabled = true;
        sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.cwd.resources.RES_Cwd");
    }

    private class CustomKeyHandler
    extends KeyAdapter {
        private CustomKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 27 || n == 9 && keyEvent.isControlDown()) {
                CwdComponentSet.this.relinquishFocus();
                CwdComponentSet.this.setButtonFocusEnabled(false);
            } else if (n == 9) {
                Component component = this.getNextComponent(keyEvent.getComponent());
                if (component != null) {
                    component.requestFocusInWindow();
                } else {
                    CwdComponentSet.this.relinquishFocus();
                    CwdComponentSet.this.setButtonFocusEnabled(false);
                }
            } else if (n == 10 && keyEvent.getSource() == CwdComponentSet.this.fDirectoryCombo.getEditor().getEditorComponent()) {
                CwdComponentSet.this.setButtonFocusEnabled(false);
            }
        }

        private Component getNextComponent(Component component) {
            if (PlatformInfo.isMacintosh()) {
                return null;
            }
            int n = CwdComponentSet.this.fFocusList.indexOf(component);
            if (n == -1) {
                return null;
            }
            for (int i = n + 1; i != n; ++i) {
                Component component2;
                if (i >= CwdComponentSet.this.fFocusList.size()) {
                    i = 0;
                }
                if (!(component2 = (Component)CwdComponentSet.this.fFocusList.get(i)).isShowing() || !component2.isFocusTraversable()) continue;
                return component2;
            }
            return null;
        }
    }

    private class CustomFocusHandler
    extends FocusAdapter {
        private CustomFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getOppositeComponent();
            if (component != null && CwdComponentSet.this.fPreviousFocusOwner == null && !(component instanceof JRootPane) && SwingUtilities.windowForComponent(component) == SwingUtilities.windowForComponent(focusEvent.getComponent())) {
                CwdComponentSet.this.fPreviousFocusOwner = component;
            }
            CwdComponentSet.this.setButtonFocusEnabled(true);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                Component component;
                if (focusEvent.getComponent() == CwdComponentSet.this.fDirectoryCombo.getEditor().getEditorComponent() && !CwdComponentSet.this.fShowingWarningDialog) {
                    CwdComponentSet.this.refresh();
                }
                if ((component = focusEvent.getOppositeComponent()) != CwdComponentSet.this.fDirectoryCombo.getEditor().getEditorComponent() && component != CwdComponentSet.this.fBrowseButton && component != CwdComponentSet.this.fGoUpButton) {
                    CwdComponentSet.this.fPreviousFocusOwner = null;
                    CwdComponentSet.this.setButtonFocusEnabled(false);
                }
            }
        }
    }

    class GoUpAction
    extends MJAbstractAction {
        public GoUpAction() {
            super(sRes.getString("GoUpaDirectory"));
            this.setButtonOnlyIcon(FolderIcon.DIR_UP.getIcon());
            this.setTip(sRes.getString("GoUpaDirectory"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MatlabPath.setCWD((String)"..");
            CwdComponentSet.this.refresh();
        }
    }

    private class FolderChooserAction
    extends MJAbstractAction {
        public FolderChooserAction() {
            super(sRes.getString("BrowseforFolder"));
            this.setName("...");
            this.setTip(sRes.getString("BrowseforFolder"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == null) {
                return;
            }
            if (string.equals("...")) {
                File file;
                MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
                mJFileChooserPerPlatform.setDialogTitle(sRes.getString("SelectDirectory"));
                mJFileChooserPerPlatform.setFileSelectionMode(1);
                mJFileChooserPerPlatform.showOpenDialog((Component)actionEvent.getSource());
                if (mJFileChooserPerPlatform.getState() == 0 && (file = mJFileChooserPerPlatform.getSelectedFile()) != null) {
                    MatlabPath.setCWD((String)file.getAbsolutePath());
                }
            }
        }
    }

    private class PathAction
    implements ActionListener {
        private PathAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string != null && string.equals("CWD_CHANGE")) {
                if (!CwdComponentSet.this.fIsEditingEntry || !CwdComponentSet.this.fLastChangeFailed) {
                    CwdComponentSet.this.refresh();
                }
                if (!CwdComponentSet.this.fLastChangeFailed && CwdComponentSet.this.fDirectoryCombo.getEditor().getEditorComponent().isFocusOwner()) {
                    CwdComponentSet.this.relinquishFocus();
                }
            }
        }
    }

    private class DeferredComboboxResponse
    implements Runnable {
        private DeferredComboboxResponse() {
        }

        @Override
        public void run() {
            if (!CwdComponentSet.this.fDirectoryCombo.isPopupVisible()) {
                CwdComponentSet.this.fLastChangeFailed = false;
                CwdComponentSet.this.fIsEditingEntry = CwdComponentSet.this.fDirectoryCombo.getEditor().getEditorComponent().hasFocus();
                MatlabPath.setCWD((String)((String)CwdComponentSet.this.fDirectoryCombo.getSelectedItem()), (CompletionObserver)new CwdCompletionObserver());
            }
        }
    }

    private class ComboBoxActionListener
    implements ActionListener {
        private ComboBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!sComboActionListenersAreEnabled) {
                return;
            }
            if (!CwdComponentSet.COMBO_ACTION_COMMAND.equals(actionEvent.getActionCommand()) || CwdComponentSet.this.fDirectoryCombo.isPopupVisible()) {
                SwingUtilities.invokeLater(new DeferredComboboxResponse());
            }
        }
    }

    private class CustomComboBox
    extends MJComboBox {
        private CustomComboBox() {
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            ++dimension.width;
            return dimension;
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public void removeNotify() {
            super.removeNotify();
            MatlabPath.removeActionListener((ActionListener)CwdComponentSet.this.fPathAction);
            CwdComponentSet.this.fPathAction = null;
            CwdComponentSet.saveHistory();
        }

        public void addNotify() {
            super.addNotify();
            if (CwdComponentSet.this.fPathAction == null) {
                CwdComponentSet.this.fPathAction = new PathAction();
                MatlabPath.addActionListener((ActionListener)CwdComponentSet.this.fPathAction);
            }
            CwdComponentSet.this.refresh();
        }
    }

    private class CwdCompletionObserver
    implements CompletionObserver {
        private CwdCompletionObserver() {
        }

        public void completed(int n, Object object) {
            if (Matlab.getExecutionStatus((int)n) != 0) {
                CwdComponentSet.this.fLastChangeFailed = true;
                CwdComponentSet.this.fShowingWarningDialog = true;
                MJOptionPane.showMessageDialog((Component)CwdComponentSet.this.fDirectoryCombo, (Object)object, (String)sRes.getString("CurrentDirectoryTitle"), (int)2);
                CwdComponentSet.this.fShowingWarningDialog = false;
            } else if (PathUtils.changeNotificationWarningThrown(object)) {
                CwdComponentSet.this.fShowingWarningDialog = true;
                PathUtils.showChangeNotificationDialog((Frame)SwingUtilities.windowForComponent((Component)CwdComponentSet.this.fDirectoryCombo), 1);
                CwdComponentSet.this.fShowingWarningDialog = false;
            }
        }
    }
}

