/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.ui;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import com.mathworks.mlwidgets.configeditor.ConfigurationUtils;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationManager;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationNameUtils;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationSelectionListener;
import com.mathworks.mlwidgets.configeditor.data.RunConfiguration;
import com.mathworks.mlwidgets.configeditor.plugin.ConfigurationPluginUtils;
import com.mathworks.mlwidgets.configeditor.ui.ComponentDetailsEditor;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationGroupByFile;
import com.mathworks.mlwidgets.configeditor.ui.UiSupport;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.widgets.glazedlists.DisposableList;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ConfigurationUiUtils {
    private static final String EDIT_CONFIGURATIONS_MENU_ITEM = "editConfigurations";
    private static ConfigurationGroupByFile sConfigurationGroup = new ConfigurationGroupByFile();

    public static String getDisplayName(AbstractFileConfiguration abstractFileConfiguration) {
        return ConfigurationUiUtils.getUISupport(abstractFileConfiguration.getType()).getDisplayName(abstractFileConfiguration);
    }

    public static String getActionString(AbstractFileConfiguration.Type type) {
        return ConfigurationUiUtils.getUISupport(type).getActionString();
    }

    public static String getActionName(AbstractFileConfiguration.Type type) {
        return ConfigurationUiUtils.getUISupport(type).getActionName();
    }

    public static String getIncorrectExtensionErrorMessage(AbstractFileConfiguration.Type type) {
        return ConfigurationUiUtils.getUISupport(type).getIncorrectExtensionErrorMessage();
    }

    public static String getTooltip(AbstractFileConfiguration abstractFileConfiguration) {
        return ConfigurationUiUtils.getUISupport(abstractFileConfiguration.getType()).getTooltip(abstractFileConfiguration);
    }

    public static Icon getIcon(AbstractFileConfiguration abstractFileConfiguration) {
        return ConfigurationUiUtils.getUISupport(abstractFileConfiguration.getType()).getIcon(abstractFileConfiguration);
    }

    public static Font getFont(Font font, AbstractFileConfiguration abstractFileConfiguration) {
        return ConfigurationUiUtils.getUISupport(abstractFileConfiguration.getType()).getFont(font, abstractFileConfiguration);
    }

    public static ComponentDetailsEditor createEditorComponent(AbstractFileConfiguration.Type type) {
        return ConfigurationUiUtils.getUISupport(type).createEditorComponent();
    }

    public static String getConfigurationActionName(AbstractFileConfiguration.Type type) {
        return ConfigurationUiUtils.getUISupport(type).getActionName();
    }

    public static String getHelpKey(AbstractFileConfiguration abstractFileConfiguration) {
        return abstractFileConfiguration == null ? ConfigurationUiUtils.getUISupport(RunConfiguration.TYPE).getHelpKey() : ConfigurationUiUtils.getUISupport(abstractFileConfiguration.getType()).getHelpKey();
    }

    public static Set<AbstractFileConfiguration.Type> getTypesWithUiSupports() {
        HashSet<AbstractFileConfiguration.Type> hashSet = new HashSet<AbstractFileConfiguration.Type>();
        hashSet.add(ConfigurationGroupByFile.FileGroupingConfiguration.TYPE);
        hashSet.addAll(ConfigurationPluginUtils.getPluginManager().getPluginTypes());
        return hashSet;
    }

    private static <E extends AbstractFileConfiguration> UiSupport<E> getUISupport(AbstractFileConfiguration.Type<E> type) {
        return type.equals(ConfigurationGroupByFile.FileGroupingConfiguration.TYPE) ? sConfigurationGroup.getUiSupport() : ConfigurationPluginUtils.getPluginManager().getPlugin(type).getUISupport();
    }

    public static <E extends AbstractFileConfiguration> void fillPopupMenuWithConfigurationsForFile(JPopupMenu jPopupMenu, boolean bl, File file, final ConfigurationSelectionListener configurationSelectionListener, final ActionListener actionListener, AbstractFileConfiguration.Type<E> type) {
        MJAbstractAction mJAbstractAction;
        AbstractFileConfiguration abstractFileConfiguration3;
        DisposableList disposableList = file == null ? new DisposableList((TransformedList)new FilterList((EventList)new BasicEventList()), new TransformedList[0]) : ConfigurationManager.getInstance().getConfigurationsForFile(file, type);
        AbstractFileConfiguration abstractFileConfiguration2 = null;
        if (file != null) {
            if (disposableList.size() == 0) {
                disposableList.dispose();
                disposableList = new DisposableList((TransformedList)new FilterList((EventList)new BasicEventList()), new TransformedList[0]);
                abstractFileConfiguration2 = (AbstractFileConfiguration)ConfigurationManager.getInstance().getMostRecentlyActionedConfigurationForFileOrDefault(file, type);
                disposableList.add(abstractFileConfiguration2);
            } else {
                abstractFileConfiguration2 = (AbstractFileConfiguration)ConfigurationManager.getInstance().getMostRecentlyActionedConfigurationForFileOrDefault(file, type);
            }
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        SortedList sortedList = new SortedList((EventList)disposableList, ConfigurationNameUtils.getConfigurationNameSorter());
        for (final AbstractFileConfiguration abstractFileConfiguration3 : sortedList) {
            mJAbstractAction = new MJAbstractAction(abstractFileConfiguration3.getName()){

                public void actionPerformed(ActionEvent actionEvent) {
                    configurationSelectionListener.configurationSelected(abstractFileConfiguration3);
                }
            };
            MJCheckBoxMenuItem mJCheckBoxMenuItem = new MJCheckBoxMenuItem((Action)mJAbstractAction);
            mJCheckBoxMenuItem.setToolTipText(ConfigurationUiUtils.getTooltip(abstractFileConfiguration3));
            buttonGroup.add((AbstractButton)mJCheckBoxMenuItem);
            mJCheckBoxMenuItem.setEnabled(bl);
            assert (abstractFileConfiguration2 != null);
            if (abstractFileConfiguration2.equals(abstractFileConfiguration3)) {
                mJCheckBoxMenuItem.setSelected(true);
            }
            jPopupMenu.add((JMenuItem)mJCheckBoxMenuItem);
        }
        if (file != null) {
            jPopupMenu.addSeparator();
        }
        String string = file == null ? MessageFormat.format(ConfigurationUtils.lookup("edit.configurations.menuitem"), ConfigurationUiUtils.getActionName(type)) : MessageFormat.format(ConfigurationUiUtils.getActionString(type), file.getName());
        abstractFileConfiguration3 = new MJAbstractAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                actionListener.actionPerformed(actionEvent);
            }
        };
        mJAbstractAction = new MJMenuItem((Action)((Object)abstractFileConfiguration3));
        mJAbstractAction.setActionCommand(EDIT_CONFIGURATIONS_MENU_ITEM);
        jPopupMenu.add((JMenuItem)mJAbstractAction);
        sortedList.dispose();
        disposableList.dispose();
    }

    public static boolean isEditConfigurationsAction(ActionEvent actionEvent) {
        return actionEvent != null && actionEvent.getActionCommand().equals(EDIT_CONFIGURATIONS_MENU_ITEM);
    }
}

