/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor.ui;

import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.mlwidgets.configeditor.ConfigurationUtils;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationManager;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationSelectionListener;
import com.mathworks.mlwidgets.configeditor.data.PublishConfiguration;
import com.mathworks.mlwidgets.configeditor.plugin.ConfigurationPlugin;
import com.mathworks.mlwidgets.configeditor.plugin.ConfigurationPluginUtils;
import com.mathworks.mlwidgets.configeditor.ui.AbstractConfigurationGroup;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationGroupByFile;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationGroupSelectionListener;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.widgets.ButtonFactory;
import com.mathworks.widgets.PopupMenuCustomizer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ConfigurationExplorerButtonPanel
implements ConfigurationSelectionListener,
ConfigurationGroupSelectionListener {
    private MJPanel fPanel = new MJPanel();
    private final MJButton fAddButton = new MJButton((Icon)MiscellaneousIcon.ADD_ENTRY.getIcon());
    private final MJButton fRemoveButton = new MJButton((Icon)MiscellaneousIcon.REMOVE_ENTRY.getIcon());
    private final MJButton fUndoButton = new MJButton((Icon)CommonIcon.UNDO.getIcon());
    private ListEventListener<AbstractFileConfiguration> fListEventListener;
    private final AddActionListener fAddActionListener;

    public ConfigurationExplorerButtonPanel(AddActionListener addActionListener) {
        if (addActionListener == null) {
            throw new IllegalArgumentException("AddRequestListener cannot be null");
        }
        this.fAddActionListener = addActionListener;
        this.init();
    }

    private void init() {
        JComponent jComponent = ButtonFactory.makeComponentUtilityButtonGroup((AbstractButton[])new AbstractButton[]{this.fAddButton, this.fRemoveButton});
        JComponent jComponent2 = ButtonFactory.makeComponentUtilityButtonGroup((AbstractButton[])new AbstractButton[]{this.fUndoButton});
        this.fAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationExplorerButtonPanel.this.doAddRequested(PublishConfiguration.TYPE);
            }
        });
        FormLayout formLayout = new FormLayout("d, d:grow, d", "d");
        CellConstraints cellConstraints = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)this.fPanel);
        panelBuilder.add((Component)jComponent, cellConstraints.xy(1, 1, "left, top"));
        panelBuilder.add((Component)jComponent2, cellConstraints.xy(3, 1, "right, top"));
        this.fRemoveButton.setEnabled(false);
        this.fUndoButton.setEnabled(false);
        this.initNames();
        this.initToolTips();
        this.initListeners();
    }

    private void initNames() {
        this.fAddButton.setName("AddButton");
        this.fRemoveButton.setName("RemoveButton");
        this.fUndoButton.setName("UndoButton");
    }

    private void initToolTips() {
        this.fUndoButton.setToolTipText(ConfigurationUtils.lookup("undo.button.tooltip"));
    }

    private void initListeners() {
        this.fListEventListener = new ListEventListener<AbstractFileConfiguration>(){

            public void listChanged(ListEvent<AbstractFileConfiguration> listEvent) {
                ConfigurationExplorerButtonPanel.this.fUndoButton.setEnabled(!ConfigurationManager.getInstance().getUndoableDeletedConfigurations().isEmpty());
            }
        };
        ConfigurationManager.getInstance().getUndoableDeletedConfigurations().addListEventListener(this.fListEventListener);
    }

    public void cleanup() {
        ConfigurationManager.getInstance().getUndoableDeletedConfigurations().removeListEventListener(this.fListEventListener);
    }

    public Component getComponent() {
        return this.fPanel;
    }

    private void refreshToolTips(File file) {
        String string = file == null ? null : MessageFormat.format(ConfigurationUtils.lookup("add.button.tooltip"), file.getName());
        this.fAddButton.setToolTipText(string);
        String string2 = file == null ? null : MessageFormat.format(ConfigurationUtils.lookup("remove.button.tooltip.group"), file.getName());
        this.fRemoveButton.setToolTipText(string2);
    }

    private void refreshToolTips(AbstractFileConfiguration abstractFileConfiguration) {
        String string = abstractFileConfiguration == null ? null : MessageFormat.format(ConfigurationUtils.lookup("add.button.tooltip"), abstractFileConfiguration.getAssociatedFileName());
        this.fAddButton.setToolTipText(string);
        String string2 = abstractFileConfiguration == null ? null : MessageFormat.format(ConfigurationUtils.lookup("remove.button.tooltip.single"), abstractFileConfiguration.getName());
        this.fRemoveButton.setToolTipText(string2);
    }

    private PopupMenuCustomizer createPopupMenuCustomizer() {
        return new PopupMenuCustomizer(){

            public void customize(JPopupMenu jPopupMenu) {
                jPopupMenu.removeAll();
                for (final AbstractFileConfiguration.Type type : ConfigurationPluginUtils.getPluginManager().getPluginTypes()) {
                    ConfigurationPlugin configurationPlugin = ConfigurationPluginUtils.getPluginManager().getPlugin(type);
                    String string = configurationPlugin.getName();
                    Icon icon = configurationPlugin.getUISupport().getIcon(null);
                    MJMenuItem mJMenuItem = new MJMenuItem((Action)new MJAbstractAction(string, icon){

                        public void actionPerformed(ActionEvent actionEvent) {
                            ConfigurationExplorerButtonPanel.this.doAddRequested(type);
                        }
                    });
                    jPopupMenu.add((JMenuItem)mJMenuItem);
                }
            }
        };
    }

    private void doAddRequested(AbstractFileConfiguration.Type<?> type) {
        this.fAddActionListener.addRequested(type);
    }

    public MJButton getAddButton() {
        return this.fAddButton;
    }

    public MJButton getRemoveButton() {
        return this.fRemoveButton;
    }

    public MJButton getUndoButton() {
        return this.fUndoButton;
    }

    @Override
    public void configurationSelected(AbstractFileConfiguration abstractFileConfiguration) {
        this.refreshToolTips(abstractFileConfiguration);
        this.fRemoveButton.setEnabled(abstractFileConfiguration != null);
    }

    @Override
    public void configurationGroupSelected(AbstractConfigurationGroup.GroupingConfiguration groupingConfiguration) {
        if (groupingConfiguration instanceof ConfigurationGroupByFile.FileGroupingConfiguration) {
            this.refreshToolTips(groupingConfiguration.getAssociatedFile());
        }
        this.fRemoveButton.setEnabled(groupingConfiguration.getAssociatedFile() != null);
    }

    public static interface AddActionListener {
        public void addRequested(AbstractFileConfiguration.Type<?> var1);
    }
}

