/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.ArrayDialog;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.DoerCompletionObserver;
import com.mathworks.mlwidgets.array.InvertableRunnable;
import com.mathworks.mlwidgets.array.UndoerCompletionObserver;
import com.mathworks.mlwidgets.array.WorkspaceUndoManager;
import com.mathworks.mlwidgets.array.data.CellArrayValue;
import com.mathworks.mlwidgets.array.data.FunctionHandleValue;
import com.mathworks.mlwidgets.array.data.ITabularObjectArrayValue;
import com.mathworks.mlwidgets.array.data.ReadOnlyValue;
import com.mathworks.mlwidgets.workspace.MatlabWorkspaceListener;
import com.mathworks.mlwidgets.workspace.WorkspaceMCRProvider;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.spreadsheet.IReadOnlyData;
import com.mathworks.widgets.spreadsheet.data.ComplexArray;
import com.mathworks.widgets.spreadsheet.data.ComplexArrayDouble;
import com.mathworks.widgets.spreadsheet.data.ComplexScalar;
import com.mathworks.widgets.spreadsheet.format.Formattable;
import com.mathworks.widgets.spreadsheet.format.Formatter;
import java.util.Hashtable;
import java.util.Map;

public class ValueDataSection
implements Formattable,
IReadOnlyData {
    private int fStartRow;
    private int fStartColumn;
    private int fEndRow;
    private int fEndColumn;
    private String[][] fStrings = null;
    private boolean[][] fBooleans = null;
    private String fString = null;
    private ReadOnlyValue fROValue = null;
    private FunctionHandleValue fFHValue = null;
    private ComplexArray fComplexArray = null;
    private ComplexScalar fComplexScalar = null;
    private CellArrayValue fCellArrayValue = null;
    private ITabularObjectArrayValue fTabularObjectArrayValue = null;
    private WorkspaceVariable fVariable;
    private Map<Integer, Map<Integer, String>> fTempColumns = new Hashtable<Integer, Map<Integer, String>>();
    private boolean fUITableUsage = false;
    private int fOldPathCounter = 0;
    private int fNewPathCounter = 0;

    public int getOldPathCounter() {
        return this.fOldPathCounter;
    }

    protected void setOldPathCounter(int n) {
        this.fOldPathCounter = n;
    }

    public int getNewPathCounter() {
        return this.fNewPathCounter;
    }

    protected void setNewPathCounter(int n) {
        this.fNewPathCounter = n;
    }

    private void setPositions(int n, int n2, int n3, int n4) {
        this.fStartRow = n;
        this.fStartColumn = n2;
        this.fEndRow = n3;
        this.fEndColumn = n4;
    }

    public ValueDataSection(WorkspaceVariable workspaceVariable, int n, int n2, int n3, int n4, ComplexArray complexArray) {
        this(workspaceVariable, n, n2, n3, n4);
        this.fComplexArray = complexArray;
    }

    public ValueDataSection(WorkspaceVariable workspaceVariable, int n, int n2, int n3, int n4, ComplexScalar complexScalar) {
        this(workspaceVariable, n, n2, n3, n4);
        this.fComplexScalar = complexScalar;
    }

    public ValueDataSection(WorkspaceVariable workspaceVariable, int n, int n2, int n3, int n4, String[][] stringArray) {
        this(workspaceVariable, n, n2, n3, n4);
        this.fStrings = stringArray;
    }

    public ValueDataSection(WorkspaceVariable workspaceVariable, int n, int n2, int n3, int n4, boolean[][] blArray) {
        this(workspaceVariable, n, n2, n3, n4);
        this.fBooleans = blArray;
    }

    public ValueDataSection(WorkspaceVariable workspaceVariable, int n, int n2, int n3, int n4, String string) {
        this(workspaceVariable, n, n2, n3, n4);
        this.fString = string;
    }

    public ValueDataSection(WorkspaceVariable workspaceVariable, int n, int n2, int n3, int n4, CellArrayValue cellArrayValue) {
        this(workspaceVariable, n, n2, n3, n4);
        this.fCellArrayValue = cellArrayValue;
    }

    public ValueDataSection(WorkspaceVariable workspaceVariable, int n, int n2, int n3, int n4, ReadOnlyValue readOnlyValue) {
        this(workspaceVariable, n, n2, n3, n4);
        this.fROValue = readOnlyValue;
    }

    public ValueDataSection(WorkspaceVariable workspaceVariable, int n, int n2, int n3, int n4, FunctionHandleValue functionHandleValue) {
        this(workspaceVariable, n, n2, n3, n4);
        this.fFHValue = functionHandleValue;
    }

    private ValueDataSection(WorkspaceVariable workspaceVariable, int n, int n2, int n3, int n4) {
        this.fVariable = workspaceVariable;
        this.setPositions(n, n2, n3, n4);
    }

    public ValueDataSection(WorkspaceVariable workspaceVariable, int n, int n2, int n3, int n4, ITabularObjectArrayValue iTabularObjectArrayValue) {
        this(workspaceVariable, n, n2, n3, n4);
        this.fTabularObjectArrayValue = iTabularObjectArrayValue;
    }

    public void setUITableUsage(boolean bl) {
        this.fUITableUsage = bl;
    }

    public boolean isEmpty() {
        return this.fComplexArray == null && this.fComplexScalar == null && this.fStrings == null && this.fString == null && this.fROValue == null && this.fFHValue == null && this.fBooleans == null && this.fCellArrayValue == null && this.fTabularObjectArrayValue == null;
    }

    boolean isComplexScalar() {
        return this.fComplexScalar != null;
    }

    boolean isComplexArray() {
        return this.fComplexArray != null;
    }

    public String[][] getStrings() {
        return this.fStrings != null ? (String[][])this.fStrings.clone() : (String[][])null;
    }

    String getReadOnlyDescription() {
        return this.fROValue == null ? null : this.fROValue.toString();
    }

    boolean isString() {
        return this.fStrings != null;
    }

    public boolean isReadOnly() {
        return this.fROValue != null || this.fStrings != null;
    }

    public String getString() {
        return this.fString;
    }

    public int getStartRow() {
        return this.fStartRow;
    }

    public int getStartColumn() {
        return this.fStartColumn;
    }

    public int getEndRow() {
        return this.fEndRow;
    }

    public int getEndColumn() {
        return this.fEndColumn;
    }

    public boolean hasDataAt(int n, int n2) {
        int n3;
        int n4 = n - this.getStartRow();
        return this.hasRealDataAt(n4, n3 = n2 - this.getStartColumn()) || this.hasTempDataAt(n4, n3);
    }

    private boolean hasRealDataAt(int n, int n2) {
        return n >= this.getStartRow() && n2 >= this.getStartColumn() && n <= this.getEndRow() && n2 <= this.getEndColumn();
    }

    private boolean hasTempDataAt(int n, int n2) {
        Map<Integer, String> map;
        return this.fTempColumns.containsKey(n2) && (map = this.fTempColumns.get(n2)).containsKey(n);
    }

    public Object getValueAt(int n, int n2) {
        return this.getValueAt(n, n2, false);
    }

    Object getValueAt(int n, int n2, boolean bl) {
        int n3 = n - this.getStartRow();
        int n4 = n2 - this.getStartColumn();
        if (this.hasTempDataAt(n, n2)) {
            return this.getTempValueAt(n3, n4);
        }
        if (this.hasRealDataAt(n, n2)) {
            return this.getRealValueAt(n3, n4, bl);
        }
        return ComplexArrayDouble.getEmptyRealInstance();
    }

    private Object getTempValueAt(int n, int n2) {
        Map<Integer, String> map;
        int n3 = n + this.getStartRow();
        int n4 = n2 + this.getStartColumn();
        if (this.fTempColumns.containsKey(n4) && (map = this.fTempColumns.get(n4)).containsKey(n3)) {
            return map.get(n3);
        }
        return null;
    }

    private Object getRealValueAt(int n, int n2, boolean bl) {
        if (this.isEmpty()) {
            return ComplexArrayDouble.getEmptyRealInstance();
        }
        if (this.fComplexArray != null) {
            return this.fComplexArray.getValueAt(n, n2);
        }
        if (this.fComplexScalar != null) {
            return this.fComplexScalar;
        }
        if (this.fBooleans != null) {
            return this.fBooleans[n][n2] ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.fStrings != null) {
            return ValueDataSection.quotify(this.fStrings[n][n2], bl);
        }
        if (this.fString != null && n == 0 && n2 == 0) {
            return ValueDataSection.quotify(this.fString, bl);
        }
        if (this.fCellArrayValue != null) {
            return this.fCellArrayValue.getValueAt(n, n2);
        }
        if (this.fTabularObjectArrayValue != null) {
            return this.fTabularObjectArrayValue.getValueAt(n, n2 + this.getStartColumn(), bl);
        }
        if (this.fROValue != null && n == 0 && n2 == 0) {
            return this.fROValue.toString();
        }
        if (this.fFHValue != null && n == 0 && n2 == 0) {
            return this.fFHValue.toString();
        }
        return null;
    }

    private static String quotify(String string, boolean bl) {
        if (bl) {
            return '\'' + StringUtils.quoteSingleQuotes((String)string) + '\'';
        }
        return string;
    }

    public void setValuesAt(Object[][] objectArray, int n, int n2, int n3, int n4, Object[] objectArray2, WorkspaceUndoManager workspaceUndoManager, CompletionObserver completionObserver) {
        boolean bl;
        boolean bl2 = bl = this.fString != null;
        if (objectArray2 == null) {
            StringBuilder stringBuilder = new StringBuilder(this.fVariable.getWorkspaceVariableNameTemp());
            if (!bl) {
                stringBuilder.append('(').append(n + 1).append(':').append(n2 + 1).append(',').append(n3 + 1).append(':').append(n4 + 1).append(')');
            }
            int[] nArray = com.mathworks.util.ArrayUtils.getArrayLengths((Object)objectArray);
            int n5 = nArray[0];
            int n6 = nArray[1];
            StringBuilder stringBuilder2 = new StringBuilder();
            if (n5 > 1 || n6 > 1) {
                stringBuilder2.append("[");
            }
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n6; ++j) {
                    if (!bl) {
                        stringBuilder2.append(objectArray[i][j].toString());
                    } else {
                        stringBuilder2.append('\'').append(StringUtils.quoteSingleQuotes((String)objectArray[i][j].toString())).append('\'');
                    }
                    if (j < n6 - 1) {
                        stringBuilder2.append(',');
                    }
                    this.setTempValueAt(objectArray[i][j], i + n, j + n3);
                }
                if (i >= n5 - 1) continue;
                stringBuilder2.append(';');
            }
            if (n5 > 1 || n6 > 1) {
                stringBuilder2.append(']');
            }
            WorkspaceUndoManager.UndoKey undoKey = WorkspaceUndoManager.getNewKey(workspaceUndoManager);
            if (this.fTabularObjectArrayValue != null) {
                this.fTabularObjectArrayValue.setValuesAt(this.fVariable, n, n3, stringBuilder2.toString(), workspaceUndoManager, undoKey);
            } else {
                new SetValuesAtDoer(this.fVariable, stringBuilder.toString(), stringBuilder2.toString(), workspaceUndoManager, undoKey, completionObserver, n + 1, n2 + 1, n3 + 1, n4 + 1).run();
            }
        }
    }

    private void setTempValueAt(Object object, int n, int n2) {
        Map<Object, Object> map;
        if (this.fTempColumns.containsKey(n2)) {
            map = this.fTempColumns.get(n2);
        } else {
            map = new Hashtable();
            this.fTempColumns.put(n2, map);
        }
        map.put(n, object.toString());
    }

    public String format(Formatter formatter, boolean bl) {
        if (this.fComplexScalar != null) {
            if (formatter != null) {
                return formatter.format(this.fComplexScalar);
            }
            return this.fComplexScalar.toString();
        }
        if (this.fComplexArray != null) {
            if (!bl && this.fComplexArray.isEmpty()) {
                return "";
            }
            if (formatter != null) {
                return formatter.format(this.fComplexArray);
            }
            return this.fComplexArray.toString();
        }
        if (this.fBooleans != null) {
            boolean[] blArray;
            if (formatter != null) {
                return formatter.format((Object)this.fBooleans);
            }
            if (this.fBooleans.length == 1 && (blArray = this.fBooleans[0]).length == 1) {
                return String.valueOf(blArray[0]);
            }
            return this.fBooleans.toString();
        }
        if (this.fString != null) {
            if (this.fUITableUsage) {
                return this.fString;
            }
            return '\'' + StringUtils.quoteSingleQuotes((String)this.fString) + '\'';
        }
        if (this.fROValue != null) {
            return this.fROValue.toString();
        }
        if (this.fFHValue != null) {
            return this.fFHValue.toString();
        }
        if (this.fStrings != null) {
            if (this.fStrings.length == 0 || this.fStrings[0] == null) {
                return "0x0 cell";
            }
            return this.fStrings.length + "x" + this.fStrings[0].length + " cell";
        }
        return super.toString();
    }

    public String format(Formatter formatter) {
        return this.format(formatter, true);
    }

    public String toString() {
        return this.format(null, true);
    }

    private class RefreshOnErrorCO
    implements CompletionObserver {
        private CompletionObserver iSupplied;
        private CompletionObserver iDoer = null;

        RefreshOnErrorCO(CompletionObserver completionObserver) {
            this.iSupplied = completionObserver;
        }

        public void completed(int n, Object object) {
            if (Matlab.getExecutionStatus((int)n) != 0) {
                ValueDataSection.this.fTempColumns = new Hashtable();
            }
            this.iSupplied.completed(n, object);
            if (this.iDoer != null) {
                this.iDoer.completed(n, object);
            }
        }
    }

    private class SetValuesAtUndoer
    extends SetValuesAtRunnable {
        SetValuesAtUndoer(WorkspaceVariable workspaceVariable, String string, String string2, WorkspaceUndoManager workspaceUndoManager, WorkspaceUndoManager.UndoKey undoKey, CompletionObserver completionObserver, int n, int n2, int n3, int n4) {
            super(workspaceVariable, string, string2, workspaceUndoManager, undoKey, completionObserver, n, n2, n3, n4);
        }

        private void runDefaultWorkspace() {
            String string = WorkspaceUndoManager.UndoKey.translateKeyForMatlab(this.iKey);
            WorkspaceMCRProvider.getMCRForUserActions().eval(this.iVariable.getVariableName() + " = arrayviewfunc('undoVDSAssignment', " + string + ");", (CompletionObserver)new UndoerCompletionObserver(this.iUndoManager));
        }

        private void runNonDefaultWorkspace() {
            WorkspaceMCRProvider.getMCRForUserActions().feval("arrayviewfunc", new Object[]{"undo", ValueDataSection.this.fVariable, this.iKey.stringValue()}, (CompletionObserver)new UndoerCompletionObserver(this.iUndoManager));
        }

        @Override
        public void run() {
            if (this.iUndoManager != null) {
                this.iUndoManager.receiveNextUndoableEdit();
            }
            if (this.iVariable.isDefaultWorkspace()) {
                this.runDefaultWorkspace();
            } else {
                this.runNonDefaultWorkspace();
            }
        }

        @Override
        public InvertableRunnable getInverse() {
            return new SetValuesAtDoer(this.iVariable, this.iLHS, this.iRHS, this.iUndoManager, this.iKey, this.iObserver, this.iRowStart, this.iRowEnd, this.iColumnStart, this.iColumnEnd);
        }
    }

    private class SetValuesAtDoer
    extends SetValuesAtRunnable {
        SetValuesAtDoer(WorkspaceVariable workspaceVariable, String string, String string2, WorkspaceUndoManager workspaceUndoManager, WorkspaceUndoManager.UndoKey undoKey, CompletionObserver completionObserver, int n, int n2, int n3, int n4) {
            super(workspaceVariable, string, string2, workspaceUndoManager, undoKey, completionObserver, n, n2, n3, n4);
        }

        private void runDefaultWorkspace() {
            String string = WorkspaceUndoManager.UndoKey.translateKeyForMatlab(this.iKey);
            CompletionObserver completionObserver = ArrayDialog.getErrorDialogCompletionObserver(ArrayUtils.getResource("alert.SpecialCharEntryIncompatibilityNumArray"), new RefreshOnErrorCO(new DoerCompletionObserver(this, this.iUndoManager)), false, true);
            String string2 = this.iLHS + " = arrayviewfunc('doVDSAssignment', " + this.iVariable.getVariableName() + ", " + this.iRHS + ", " + string + ");";
            if (Matlab.isMatlabAvailable()) {
                WorkspaceMCRProvider.getMCRForUserActions().eval(string2, completionObserver);
                if (this.iVariable.getVariableName().equals("ans")) {
                    MatlabWorkspaceListener.reportWSChange();
                }
            }
            ValueDataSection.this.fOldPathCounter++;
        }

        private void runNonDefaultWorkspace() {
            String string = this.iKey.stringValue();
            CompletionObserver completionObserver = ArrayDialog.getErrorDialogCompletionObserver((CompletionObserver)new RefreshOnErrorCO(new DoerCompletionObserver(this, this.iUndoManager)), true);
            Object[] objectArray = new Object[]{"vdsSetValuesAt", ValueDataSection.this.fVariable, string, this.iRHS, this.iRowStart, this.iRowEnd, this.iColumnStart, this.iColumnEnd};
            if (Matlab.isMatlabAvailable()) {
                WorkspaceMCRProvider.getMCRForUserActions().feval("arrayviewfunc", objectArray, completionObserver);
            }
            ValueDataSection.this.fNewPathCounter++;
        }

        @Override
        public void run() {
            if (ArrayUtils.isLogging()) {
                ArrayUtils.log(this.getClass(), 1, this.iLHS + ", " + this.iRHS + ", " + this.iKey);
            }
            if (this.iUndoManager != null) {
                this.iUndoManager.receiveNextUndoableEdit();
            }
            if (this.iVariable.isDefaultWorkspace()) {
                this.runDefaultWorkspace();
            } else {
                this.runNonDefaultWorkspace();
            }
        }

        @Override
        public InvertableRunnable getInverse() {
            return new SetValuesAtUndoer(this.iVariable, this.iLHS, this.iRHS, this.iUndoManager, this.iKey, this.iObserver, this.iRowStart, this.iRowEnd, this.iColumnStart, this.iColumnEnd);
        }
    }

    public static abstract class SetValuesAtRunnable
    implements InvertableRunnable {
        protected String iLHS;
        protected String iRHS;
        protected CompletionObserver iObserver;
        protected WorkspaceUndoManager.UndoKey iKey;
        protected WorkspaceUndoManager iUndoManager;
        protected WorkspaceVariable iVariable;
        protected int iRowStart;
        protected int iRowEnd;
        protected int iColumnStart;
        protected int iColumnEnd;

        SetValuesAtRunnable(WorkspaceVariable workspaceVariable, String string, String string2, WorkspaceUndoManager workspaceUndoManager, WorkspaceUndoManager.UndoKey undoKey, CompletionObserver completionObserver, int n, int n2, int n3, int n4) {
            this.iVariable = workspaceVariable;
            this.iLHS = string;
            this.iRHS = string2;
            this.iObserver = completionObserver;
            this.iKey = undoKey;
            this.iUndoManager = workspaceUndoManager;
            this.iRowStart = n;
            this.iRowEnd = n2;
            this.iColumnStart = n3;
            this.iColumnEnd = n4;
        }
    }
}

