/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.INewVariableProvider;
import com.mathworks.mlwidgets.array.ISortLabelProvider;
import com.mathworks.mlwidgets.array.ITableController;
import com.mathworks.mlwidgets.array.StructArrayDataProxy;
import com.mathworks.mlwidgets.array.StructArrayPanel;
import com.mathworks.mlwidgets.array.StructArrayTable;
import com.mathworks.mlwidgets.array.TabularObjectEditorProvider;
import com.mathworks.mlwidgets.array.TabularObjectTableModel;
import com.mathworks.mlwidgets.array.ValueMetaInfo;
import com.mathworks.mlwidgets.array.VarEditorDataProxy;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

public final class StructArrayEditorProvider
extends TabularObjectEditorProvider
implements ISortLabelProvider {
    private StructArrayEditorProvider(TabularObjectTableModel tabularObjectTableModel, StructArrayTable structArrayTable, StructArrayPanel structArrayPanel) {
        super(tabularObjectTableModel, structArrayTable, structArrayPanel);
    }

    public static StructArrayEditorProvider createProvider(WorkspaceVariable workspaceVariable) {
        StructArrayDataProxy structArrayDataProxy = new StructArrayDataProxy(workspaceVariable.getWorkspaceID());
        TabularObjectTableModel tabularObjectTableModel = new TabularObjectTableModel(workspaceVariable, structArrayDataProxy, true);
        StructArrayTable structArrayTable = new StructArrayTable(tabularObjectTableModel, structArrayDataProxy);
        StructArrayPanel structArrayPanel = new StructArrayPanel(structArrayTable);
        structArrayPanel.setName("StructArrayPanel");
        return new StructArrayEditorProvider(tabularObjectTableModel, structArrayTable, structArrayPanel);
    }

    private static StructArrayEditorProvider createProvider(WorkspaceVariable workspaceVariable, StructArrayTable structArrayTable, StructArrayPanel structArrayPanel, TabularObjectTableModel tabularObjectTableModel, VarEditorDataProxy varEditorDataProxy) {
        structArrayPanel.setName("StructArrayPanel");
        return new StructArrayEditorProvider(tabularObjectTableModel, structArrayTable, structArrayPanel);
    }

    @Override
    public List<INewVariableProvider.CreationParams> getCreationParamsForSelection() {
        ArrayList<INewVariableProvider.CreationParams> arrayList = new ArrayList<INewVariableProvider.CreationParams>();
        arrayList.add(INewVariableProvider.CreationParams.STRUCTURE);
        if (this.getTable().getSelectedColumnCount() > 1) {
            arrayList.add(INewVariableProvider.CreationParams.SEPARATE_VARS);
        }
        arrayList.add(INewVariableProvider.CreationParams.NUMERIC_ARRAY);
        arrayList.add(INewVariableProvider.CreationParams.TABLE);
        return arrayList;
    }

    @Override
    public String getSortLabel(ITableController.SortDirection sortDirection) {
        if (sortDirection == ITableController.SortDirection.ASCENDING) {
            return ArrayUtils.getResource("structureArray.sortAscending");
        }
        return ArrayUtils.getResource("structureArray.sortDescending");
    }

    @Override
    public String getSortTooltip(ITableController.SortDirection sortDirection) {
        return this.getSortLabel(sortDirection);
    }

    public void removeEmptyRowsAndColumns(ValueMetaInfo valueMetaInfo) {
        int n = valueMetaInfo.getRowCount();
        int n2 = valueMetaInfo.getColumnCount();
        if (n >= this.getModel().getLastDataRow() && n2 >= this.getModel().getLastDataColumn()) {
            return;
        }
        if (n < this.getModel().getLastDataRow()) {
            this.getTable().removeEmptyRows(n);
        }
        if (n2 < this.getModel().getLastDataColumn()) {
            this.getTable().removeEmptyColumns(n2);
        }
        this.getModel().setValueMetaInfo(valueMetaInfo);
    }

    @Override
    public void setOpenActionListener(ActionListener actionListener) {
        this.fModel.setOpenActionListener(actionListener);
    }
}

