/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlwidgets.array.AbstractFormatToolsetSupplier;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.ValueEditorProvider;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.plaf.ToolstripIcons;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.FormattableDisplay;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;

public class FormatToolsetSupplier
extends AbstractFormatToolsetSupplier
implements TSToolSet.ToolSupplier,
PopupListener,
ListActionListener {
    private Object fActionProvider = null;
    private FormattableDisplay fDisplay = null;
    private final Collection<String> fIDStrings = new Vector<String>();
    private final Vector<FormatIdentifier> fIDs = new Vector();
    private String fCurrItem = "Short";
    private FormatIdentifier fPreferencesFormat = null;
    private FormatIdentifier fCurrentFormat = null;
    private FormatIdentifier fTempDisplayFormat = null;

    FormatToolsetSupplier(Object object, FormattableDisplay formattableDisplay) {
        this.fActionProvider = object;
        this.fDisplay = formattableDisplay;
        if (formattableDisplay != null) {
            this.fCurrentFormat = this.fTempDisplayFormat = formattableDisplay.getFormat();
            this.fPreferencesFormat = this.fTempDisplayFormat;
            this.fCurrItem = FormatToolsetSupplier.getDisplayName(this.fPreferencesFormat);
            if (this.fPreferencesFormat == FormatIdentifier.SHORT_G || this.fPreferencesFormat == FormatIdentifier.LONG_G) {
                this.fPreferredSize = new Dimension(240, 21);
            }
        }
    }

    public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
        FormattableDisplay formattableDisplay;
        String string = ArrayUtils.getResource("numericFormat.tooltip");
        NumberFormatDropDownButton numberFormatDropDownButton = new NumberFormatDropDownButton(string);
        string = string.replaceAll("&", "");
        numberFormatDropDownButton.setToolTipText(string);
        numberFormatDropDownButton.setPopupListener(this);
        numberFormatDropDownButton.setPreferredSize(this.fPreferredSize);
        numberFormatDropDownButton.setBorder(BorderFactory.createBevelBorder(1));
        boolean bl = false;
        if (this.fActionProvider != null && this.fActionProvider instanceof ValueEditorProvider && (formattableDisplay = ((ValueEditorProvider)this.fActionProvider).getFormattableDisplay()) != null) {
            bl = true;
        }
        numberFormatDropDownButton.setEnabled(bl);
        return numberFormatDropDownButton;
    }

    @Override
    void showMousedOverFormat(MouseEvent mouseEvent) {
        PopupList popupList = (PopupList)mouseEvent.getSource();
        int n = popupList.locationToIndex(mouseEvent.getPoint());
        if (n < this.fIDs.size()) {
            if (this.fTempDisplayFormat != this.fIDs.get(n)) {
                this.fTempDisplayFormat = this.fIDs.get(n);
                this.fDisplay.setFormat(this.fTempDisplayFormat);
            }
        } else {
            this.revertToCurrentFormat();
        }
    }

    @Override
    void revertToCurrentFormat() {
        this.fDisplay.setFormat(this.fCurrentFormat);
        this.fTempDisplayFormat = this.fCurrentFormat;
    }

    @Override
    void handleKeyPress(boolean bl) {
        int n = bl ? 1 : -1;
        int n2 = this.fIDs.indexOf(this.fTempDisplayFormat) + n;
        if (bl && n2 == this.fIDs.size()) {
            n2 = 0;
        } else if (!bl && n2 < 0) {
            n2 = this.fIDs.size() - 1;
        }
        this.fTempDisplayFormat = this.fIDs.get(n2);
        this.fDisplay.setFormat(this.fTempDisplayFormat);
    }

    public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
        popupCallback.show((JComponent)this.createList());
    }

    private PopupList createList() {
        PopupList popupList;
        ArrayList<ListItem> arrayList = new ArrayList<ListItem>();
        this.fIDs.clear();
        this.fIDStrings.clear();
        this.fTempDisplayFormat = this.fCurrentFormat;
        boolean bl = false;
        for (FormatIdentifier formatIdentifier : FormatIdentifier.values()) {
            String string = FormatToolsetSupplier.getSampleForFormat(formatIdentifier);
            if (string == null) continue;
            this.addFormatItemToList(arrayList, formatIdentifier, string);
            if (formatIdentifier != this.fPreferencesFormat) continue;
            bl = true;
        }
        if (!bl) {
            popupList = FormatToolsetSupplier.getSampleForNonStandardFormat(this.fPreferencesFormat);
            this.addFormatItemToList(arrayList, this.fPreferencesFormat, (String)popupList);
        }
        popupList = new PopupList(arrayList.toArray(new ListItem[arrayList.size()]));
        popupList.setName("numericFormat");
        popupList.setListStyle(ListStyle.SINGLE_LINE_DESCRIPTION);
        popupList.addListActionListener((ListActionListener)this);
        popupList.addMouseListener((MouseListener)this);
        popupList.addMouseMotionListener((MouseMotionListener)this);
        popupList.addKeyListener((KeyListener)this);
        return popupList;
    }

    private void addFormatItemToList(Collection<ListItem> collection, FormatIdentifier formatIdentifier, String string) {
        String string2;
        boolean bl = (string2 = FormatToolsetSupplier.getDisplayName(formatIdentifier)).equals(this.fCurrItem);
        ListItem listItem = ListItem.newItem((String)string2, (String)string, (String)string2, (Icon)(bl ? ToolstripIcons.CHECKBOX_CHECKED_POPUPLIST.getIcon() : this.fSpacerIcon));
        collection.add(listItem);
        this.fIDStrings.add(string2);
        this.fIDs.add(formatIdentifier);
    }

    private static String getDisplayName(FormatIdentifier formatIdentifier) {
        String string = "numericFormat." + formatIdentifier;
        return ArrayUtils.getResource(string.replace(' ', '-'));
    }

    public void listItemSelected(ListActionEvent listActionEvent) {
        String string;
        this.fCurrItem = string = listActionEvent.getListItem().getName();
        int n = 0;
        for (String string2 : this.fIDStrings) {
            if (string2.equals(string)) {
                this.fCurrentFormat = this.fIDs.get(n);
                this.fDisplay.setFormat(this.fCurrentFormat);
                break;
            }
            ++n;
        }
    }

    private static String getSampleForFormat(FormatIdentifier formatIdentifier) {
        String string = null;
        switch (formatIdentifier) {
            case SHORT: 
            case LONG: 
            case SHORT_E: 
            case LONG_E: 
            case SHORT_ENG: 
            case LONG_ENG: {
                string = formatIdentifier.getSample();
            }
        }
        return string;
    }

    private static String getSampleForNonStandardFormat(FormatIdentifier formatIdentifier) {
        String string = null;
        switch (formatIdentifier) {
            case SHORT_G: 
            case LONG_G: 
            case PLUS: 
            case BANK: 
            case RATIONAL: {
                string = formatIdentifier.getSample();
            }
        }
        return string;
    }

    private class NumberFormatDropDownButton
    extends AbstractFormatToolsetSupplier.FormatDropDownButton {
        NumberFormatDropDownButton(String string) {
            super(string);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.drawString(FormatToolsetSupplier.this.fCurrItem, 5, 15);
        }
    }
}

