/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.CategoricalVariableProxy;
import com.mathworks.mlwidgets.array.DatetimeDurationPanel;
import com.mathworks.mlwidgets.array.DatetimeDurationTableModel;
import com.mathworks.mlwidgets.array.DatetimeTable;
import com.mathworks.mlwidgets.array.FormatToolsetSupplierFactory;
import com.mathworks.mlwidgets.array.INewVariableProvider;
import com.mathworks.mlwidgets.array.ITransposeProvider;
import com.mathworks.mlwidgets.array.TabularObjectEditorProvider;
import com.mathworks.mlwidgets.array.TabularObjectTableModel;
import com.mathworks.mlwidgets.array.ValueMetaInfo;
import com.mathworks.mlwidgets.array.VarEditorDataProxy;
import com.mathworks.mlwidgets.array.VariableFormatSpecifier;
import com.mathworks.mlwidgets.array.data.DatetimeArray;
import com.mathworks.widgets.spreadsheet.ISpreadsheetSelectionController;
import com.mathworks.widgets.spreadsheet.RangeSelectionModel;
import com.mathworks.widgets.spreadsheet.format.FormattableDisplay;
import java.util.ArrayList;
import java.util.List;

public class DatetimeEditorProvider
extends TabularObjectEditorProvider
implements ISpreadsheetSelectionController,
ITransposeProvider,
VariableFormatSpecifier {
    private static VarEditorDataProxy sDataProxy;

    public DatetimeEditorProvider(TabularObjectTableModel tabularObjectTableModel, DatetimeTable datetimeTable, DatetimeDurationPanel datetimeDurationPanel) {
        super(tabularObjectTableModel, datetimeTable, datetimeDurationPanel);
    }

    public static DatetimeEditorProvider createProvider(WorkspaceVariable workspaceVariable) {
        sDataProxy = new CategoricalVariableProxy(workspaceVariable.getWorkspaceID());
        DatetimeDurationTableModel datetimeDurationTableModel = new DatetimeDurationTableModel(workspaceVariable, sDataProxy, DatetimeArray.class, "datetime");
        DatetimeTable datetimeTable = new DatetimeTable(datetimeDurationTableModel);
        DatetimeDurationPanel datetimeDurationPanel = new DatetimeDurationPanel(datetimeTable);
        datetimeDurationPanel.setName("DatetimePanel");
        return new DatetimeEditorProvider((TabularObjectTableModel)datetimeDurationTableModel, datetimeTable, datetimeDurationPanel);
    }

    private static DatetimeEditorProvider createProvider(DatetimeDurationTableModel datetimeDurationTableModel, DatetimeTable datetimeTable, DatetimeDurationPanel datetimeDurationPanel) {
        datetimeDurationPanel.setName("DatetimePanel");
        return new DatetimeEditorProvider((TabularObjectTableModel)datetimeDurationTableModel, datetimeTable, datetimeDurationPanel);
    }

    public RangeSelectionModel getSpreadsheetRowSelectionModel() {
        return this.getTable().getSpreadsheetRowSelectionModel();
    }

    public RangeSelectionModel getSpreadsheetColumnSelectionModel() {
        return this.getTable().getSpreadsheetColumnSelectionModel();
    }

    @Override
    public List<INewVariableProvider.CreationParams> getCreationParamsForSelection() {
        ArrayList<INewVariableProvider.CreationParams> arrayList = new ArrayList<INewVariableProvider.CreationParams>();
        arrayList.add(INewVariableProvider.CreationParams.DATETIME);
        if (this.getTable().getSelectedColumnCount() > 1) {
            arrayList.add(INewVariableProvider.CreationParams.SEPARATE_VARS);
        }
        arrayList.add(INewVariableProvider.CreationParams.CELL_ARRAY);
        return arrayList;
    }

    public void removeEmptyRowsAndColumns(ValueMetaInfo valueMetaInfo) {
        int n = valueMetaInfo.getRowCount();
        int n2 = valueMetaInfo.getColumnCount();
        if (n >= this.getModel().getLastDataRow() && n2 >= this.getModel().getLastDataColumn()) {
            return;
        }
        if (n < this.getModel().getLastDataRow()) {
            this.getTable().removeEmptyRows(n);
        }
        if (n2 < this.getModel().getLastDataColumn()) {
            this.getTable().removeEmptyColumns(n2);
        }
        this.getModel().setValueMetaInfo(valueMetaInfo);
    }

    @Override
    public void updateData() {
        this.superUpdateData();
    }

    @Override
    public void transposeVariable() {
        this.fModel.transpose();
    }

    @Override
    public FormattableDisplay getFormattableDisplay() {
        return null;
    }

    @Override
    public List<FormatToolsetSupplierFactory.FormatSupported> getSupportedFormats() {
        ArrayList<FormatToolsetSupplierFactory.FormatSupported> arrayList = new ArrayList<FormatToolsetSupplierFactory.FormatSupported>();
        arrayList.add(FormatToolsetSupplierFactory.FormatSupported.DATETIME);
        return arrayList;
    }

    @Override
    public void setFormat(FormatToolsetSupplierFactory.FormatSupported formatSupported, String string) {
        this.fModel.setVariableFormat(string);
    }

    @Override
    public String getFormat(String string) {
        return (String)sDataProxy.getColumnNamesAndMetaData(string);
    }
}

