/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.SynchronousInvokeUtility;
import java.awt.Window;
import javax.swing.JDialog;

public final class ArrayDialog {
    private static boolean sDialogShowPending = false;
    private static boolean sDialogShowing = false;

    public static void showErrorDialog(String string) {
        String string2 = string.replace('\r', '\n');
        while (string2.endsWith("\n")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.isEmpty()) {
            string2 = ArrayUtils.getResource("status.Error");
        }
        final String string3 = string2;
        sDialogShowPending = true;
        if (Matlab.isMatlabAvailable()) {
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    sDialogShowPending = false;
                    sDialogShowing = true;
                    MJOptionPane.showMessageDialog(null, (Object)string3, (String)ArrayDialog.getTitle(), (int)0);
                    sDialogShowing = true;
                }
            });
        }
    }

    private static String getTitle() {
        return ArrayUtils.getResource("alert.Title");
    }

    public static boolean closeOpenErrorDialog() {
        assert (Matlab.isMatlabAvailable() && NativeMatlab.nativeIsMatlabThread());
        if (!sDialogShowPending && !sDialogShowing) {
            return false;
        }
        int n = 0;
        while (n++ < 1000 && sDialogShowPending) {
            NativeMatlab.processPendingEvents();
        }
        if (sDialogShowPending) {
            try {
                Matlab.mtEval((String)"error('polling for error dialog creation failed')");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return false;
        }
        boolean bl = false;
        if (sDialogShowing) {
            int n2 = 0;
            boolean bl2 = false;
            while (n2++ < 100 && !bl2) {
                Window[] windowArray;
                SynchronousInvokeUtility.echo();
                for (Window window : windowArray = Window.getWindows()) {
                    if ("MJOptionPaneDialog".equals(window.getName())) {
                        final JDialog jDialog = (JDialog)window;
                        if (ArrayDialog.getTitle().equals(jDialog.getTitle())) {
                            bl2 = jDialog.isVisible();
                            try {
                                AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        jDialog.setVisible(false);
                                        jDialog.dispose();
                                    }
                                });
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                    }
                    bl = bl2;
                }
            }
        }
        return bl;
    }

    public static CompletionObserver getErrorDialogCompletionObserver() {
        return ArrayDialog.getErrorDialogCompletionObserver(null, null);
    }

    public static CompletionObserver getErrorDialogCompletionObserver(CompletionObserver completionObserver, String string) {
        return new EvalHandler(completionObserver, string);
    }

    public static CompletionObserver getErrorDialogCompletionObserver(CompletionObserver completionObserver, boolean bl) {
        return new EvalHandler(completionObserver, null, bl);
    }

    public static CompletionObserver getErrorDialogCompletionObserver(String string, CompletionObserver completionObserver, boolean bl) {
        return new EvalHandler(completionObserver, string, bl);
    }

    public static CompletionObserver getErrorDialogCompletionObserver(String string, CompletionObserver completionObserver, boolean bl, boolean bl2) {
        return new EvalHandler(completionObserver, string, false, bl2);
    }

    public static CompletionObserver getErrorDialogCompletionObserver(CompletionObserver completionObserver) {
        return ArrayDialog.getErrorDialogCompletionObserver(null, completionObserver, false);
    }

    public static class EvalHandler
    implements CompletionObserver {
        private String iPreferredErrorMessage;
        private CompletionObserver iSourceObserver;
        private boolean iOutputIsMessage;
        private boolean iArrayViewFuncErrorFlag = false;
        public String completedResult;

        EvalHandler(CompletionObserver completionObserver, String string, boolean bl) {
            this.iSourceObserver = completionObserver;
            this.iPreferredErrorMessage = string;
            this.iOutputIsMessage = bl;
        }

        EvalHandler(CompletionObserver completionObserver, String string) {
            this.iSourceObserver = completionObserver;
            this.iPreferredErrorMessage = string;
            this.iOutputIsMessage = false;
        }

        public EvalHandler(CompletionObserver completionObserver, String string, boolean bl, boolean bl2) {
            this.iSourceObserver = completionObserver;
            this.iPreferredErrorMessage = string;
            this.iOutputIsMessage = bl;
            this.iArrayViewFuncErrorFlag = bl2;
        }

        public void completed(int n, Object object) {
            boolean bl = false;
            if (this.iOutputIsMessage) {
                if (object instanceof String) {
                    bl = true;
                }
            } else if (Matlab.getExecutionStatus((int)n) != 0 && object instanceof String) {
                bl = true;
            }
            if (bl) {
                String string = (String)object;
                if (this.iPreferredErrorMessage != null) {
                    if (!this.iArrayViewFuncErrorFlag) {
                        string = this.iPreferredErrorMessage;
                    } else if (string.contains("arrayviewfunc")) {
                        string = this.iPreferredErrorMessage;
                    }
                }
                this.showErrorMsg(string);
            }
            if (this.iSourceObserver != null) {
                this.iSourceObserver.completed(n, object);
            }
        }

        public void showErrorMsg(String string) {
            ArrayDialog.showErrorDialog(string);
        }

        public void callCompleted(int n, Object object) {
            this.completed(n, object);
        }
    }
}

