/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.actionbrowser;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.actionbrowser.DragableGripper;
import com.mathworks.mlwidgets.actionbrowser.MACCornerGrip;
import com.mathworks.mlwidgets.actionbrowser.TearOffAble;
import com.mathworks.mlwidgets.actionbrowser.TearOffCloser;
import com.mathworks.mwswing.ComponentMover;
import com.mathworks.mwswing.MJCornerGrip;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJGrip;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTTitleButton;
import com.mathworks.widgets.desk.Desktop;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class TearOffDialog
extends MJDialog
implements TearOffAble {
    private static final long serialVersionUID = 1L;
    private DragableGripper fGripper;
    private MJPanel fGripperPanel;
    private MJGrip fFrameMover;
    private MJPanel fTitlePanel;
    private MJLabel fTitleLabel;
    private MJPanel fContentPanel;
    private MJPanel fScopePanel;
    private DTTitleButton fCloseButton;
    private DTTitleButton fRestoreButton;
    private DTTitleButton fMaximizeButton;
    private boolean fShowMaximizeRestoreButtons;
    private boolean fMaximumWindowMode;
    private Rectangle fRestoreBounds;
    private JComponent fCornerGripper;
    private MJPanel fResizeStatusBar;
    protected static boolean sIsMacPlatform = PlatformInfo.isMacintosh();
    private TearOffCloser fCloser = null;
    private WindowListener fTitlebarWindowListener = null;
    private FloatingState fFloatingState = FloatingState.TRANSIENT;
    private static final int TITLEBAR_HEIGHT = 16;
    private static final int BORDER_WIDTH = 1;
    private static Color DEFAULT_BACKGROUND_COLOR = new Color(240, 240, 240);
    private static Color GRAY_COLOR = new Color(191, 205, 219);
    private static ResourceBundle resources = ResourceBundle.getBundle("com.mathworks.mlwidgets.actionbrowser.resources.RES_ActionBrowser");

    public TearOffDialog(Frame frame) {
        this(frame, (JComponent)new MJPanel());
    }

    public TearOffDialog(Dialog dialog) {
        this(dialog, (JComponent)new MJPanel());
    }

    public TearOffDialog(Frame frame, JComponent jComponent) {
        this(frame, jComponent, (JComponent)new MJPanel());
    }

    public TearOffDialog(Frame frame, JComponent jComponent, JComponent jComponent2) {
        this(frame, jComponent, jComponent2, false);
    }

    public TearOffDialog(Frame frame, boolean bl) {
        this(frame, (JComponent)new MJPanel(), (JComponent)new MJPanel(), bl);
    }

    public TearOffDialog(Dialog dialog, JComponent jComponent) {
        this(dialog, jComponent, (JComponent)new MJPanel());
    }

    public TearOffDialog(Dialog dialog, JComponent jComponent, JComponent jComponent2) {
        this(dialog, jComponent, jComponent2, false);
    }

    public TearOffDialog(Dialog dialog, boolean bl) {
        this(dialog, (JComponent)new MJPanel(), (JComponent)new MJPanel(), bl);
    }

    public TearOffDialog(Frame frame, JComponent jComponent, JComponent jComponent2, boolean bl) {
        super(frame);
        this.fShowMaximizeRestoreButtons = bl;
        this.initWidgets();
        this.fContentPanel.add((Component)jComponent, (Object)"Center");
        this.fScopePanel.add((Component)jComponent2, (Object)"Center");
        this.fCloser = new DefaultTearOffCloser();
        this.fFloatingState = FloatingState.FLOATING;
        this.makeTransient();
    }

    public TearOffDialog(Dialog dialog, JComponent jComponent, JComponent jComponent2, boolean bl) {
        super(dialog);
        this.fShowMaximizeRestoreButtons = bl;
        this.initWidgets();
        this.fContentPanel.add((Component)jComponent, (Object)"Center");
        this.fScopePanel.add((Component)jComponent2, (Object)"Center");
        this.fCloser = new DefaultTearOffCloser();
        this.fFloatingState = FloatingState.FLOATING;
        this.makeTransient();
    }

    public void setContentPanel(JComponent jComponent) {
        this.fContentPanel.removeAll();
        this.fContentPanel.add((Component)jComponent, (Object)"Center");
        this.fContentPanel.revalidate();
        this.repaint();
    }

    public void setScopePanel(JComponent jComponent) {
        this.fScopePanel.removeAll();
        this.fScopePanel.add((Component)jComponent, (Object)"Center");
        this.fScopePanel.revalidate();
        this.repaint();
    }

    public void setCloser(TearOffCloser tearOffCloser) {
        assert (tearOffCloser != null);
        this.uninstallCloser();
        this.fCloser = tearOffCloser;
        if (!this.isFloating() && this.isVisible()) {
            this.installCloser();
        }
    }

    public void open() {
        if (!this.isFloating() && !this.isVisible()) {
            this.installCloser();
        }
        this.setVisible(true);
    }

    public void open(boolean bl) {
        if (bl) {
            this.makeFloating();
        } else {
            this.makeTransient();
        }
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
        this.makeTransient();
        this.uninstallCloser();
    }

    private void maximize() {
        this.fMaximumWindowMode = true;
        this.resetMaximizeRestoreWindowSettings(this.fMaximizeButton);
    }

    private void restore() {
        this.fMaximumWindowMode = false;
        this.resetMaximizeRestoreWindowSettings(this.fRestoreButton);
    }

    private void resetMaximizeRestoreWindowSettings(DTTitleButton dTTitleButton) {
        Rectangle rectangle = WindowUtils.getScreenBoundsWithOrNearestToPoint((Point)this.getLocationOnScreen());
        if (this.fMaximumWindowMode) {
            this.fRestoreBounds = this.getBounds();
            this.fResizeStatusBar.remove((Component)this.fCornerGripper);
        } else {
            rectangle.setBounds(this.fRestoreBounds);
            this.fResizeStatusBar.add((Component)this.fCornerGripper, (Object)"East");
        }
        this.setBounds(rectangle);
        this.fTitlePanel.remove((Component)dTTitleButton);
        ArrayList arrayList = this.getTitlePanelButtonList();
        this.buildTitlePanel(arrayList);
    }

    private ArrayList getTitlePanelButtonList() {
        ArrayList<DTTitleButton> arrayList = new ArrayList<DTTitleButton>();
        if (this.fShowMaximizeRestoreButtons) {
            DTTitleButton dTTitleButton = this.fMaximumWindowMode ? this.fRestoreButton : this.fMaximizeButton;
            arrayList.add(dTTitleButton);
            arrayList.add(this.fCloseButton);
        } else {
            arrayList.add(this.fCloseButton);
        }
        if (sIsMacPlatform) {
            Collections.reverse(arrayList);
        }
        return arrayList;
    }

    private void buildTitlePanel(ArrayList arrayList) {
        int n;
        String string;
        CellConstraints cellConstraints = new CellConstraints();
        String string2 = sIsMacPlatform ? "left" : "right";
        String string3 = string = sIsMacPlatform ? "center" : "left";
        if (!sIsMacPlatform) {
            this.fTitlePanel.add((Component)this.fTitleLabel, (Object)cellConstraints.xy(1, 1, string + ", center"));
        }
        int n2 = 0;
        if (arrayList != null) {
            for (n = 0; n < arrayList.size(); ++n) {
                JButton jButton = (JButton)arrayList.get(n);
                this.fTitlePanel.add((Component)jButton, (Object)cellConstraints.xy(n + 1, 1, string2 + ", center"));
                ++n2;
            }
        }
        if (sIsMacPlatform) {
            n = n2 == 1 ? n2 : n2 + 1;
            this.fTitlePanel.add((Component)this.fTitleLabel, (Object)cellConstraints.xy(n, 1, string + ", center"));
        }
        n2 = 0;
        n = this.fShowMaximizeRestoreButtons ? 3 : 1;
        this.fTitlePanel.add((Component)this.fFrameMover, (Object)cellConstraints.xyw(1, 1, n, "fill, fill"));
    }

    public void setTitle(String string) {
        super.setTitle(string);
        if (this.fTitleLabel != null) {
            this.fTitleLabel.setText(string);
            this.repaint();
        }
    }

    private void initWidgets() {
        MACCornerGrip mACCornerGrip;
        this.setUndecorated(true);
        this.setMinimumSize(new Dimension(150, 150));
        this.setName("TearOff");
        this.setCloseOnEscapeEnabled(true);
        this.setDefaultCloseOperation(1);
        WindowUtils.setSizeInDlus((Window)((Object)this), (int)232, (int)182);
        this.addTitlebarWindowListener();
        this.fGripper = new DragableGripper(this, resources.getString("TearOffDialog.ClickPrompt"));
        this.fGripper.setName("fGripper");
        this.setComponentToMove();
        this.fFrameMover = new MJGrip();
        this.fFrameMover.setName("fFrameMover");
        this.fFrameMover.setBorder(BorderFactory.createEmptyBorder(8, 2, 8, 2));
        this.fFrameMover.setPreferredSize(new Dimension(8, 16));
        this.fFrameMover.setShouldDrawGripper(false);
        this.fFrameMover.setShouldDrawGradient(true);
        this.fFrameMover.setComponentToMove((Component)((Object)this));
        if (this.fShowMaximizeRestoreButtons) {
            this.fRestoreButton = new DTTitleButton(4);
            this.fRestoreButton.setName("fRestoreButton");
            this.fRestoreButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TearOffDialog.this.restore();
                }
            });
            this.fMaximizeButton = new DTTitleButton(3);
            this.fMaximizeButton.setName("fMaximizeButton");
            this.fMaximizeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TearOffDialog.this.maximize();
                }
            });
        }
        this.fCloseButton = new DTTitleButton(7);
        this.fCloseButton.setName("fCloseButton");
        this.fCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TearOffDialog.this.close();
            }
        });
        this.fTitleLabel = new MJLabel();
        this.fTitleLabel.setFont(UIManager.getFont("InternalFrame.titleFont"));
        String string = "d:grow";
        if (this.fShowMaximizeRestoreButtons) {
            string = sIsMacPlatform ? "d, 10px, d:grow" : "d:grow, d, d";
        }
        String string2 = "d";
        this.fTitlePanel = new MJPanel((LayoutManager)new FormLayout(string, string2));
        this.fMaximumWindowMode = false;
        ArrayList arrayList = this.getTitlePanelButtonList();
        this.buildTitlePanel(arrayList);
        this.fGripperPanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fGripperPanel.add((Component)((Object)this.fGripper), (Object)"North");
        this.fGripperPanel.add((Component)this.fTitlePanel, (Object)"Center");
        this.fContentPanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fContentPanel.setBackground(DEFAULT_BACKGROUND_COLOR);
        this.fContentPanel.setBorder((Border)BorderFactory.createMatteBorder(1, 0, 1, 0, GRAY_COLOR));
        if (sIsMacPlatform) {
            mACCornerGrip = MACCornerGrip.createAlwaysVisibleCornerGrip();
        } else {
            MJCornerGrip mJCornerGrip = MJCornerGrip.createAlwaysVisibleCornerGrip();
            mJCornerGrip.setEnforceMinimumSize(true);
            mACCornerGrip = mJCornerGrip;
        }
        this.fCornerGripper = mACCornerGrip;
        this.fScopePanel = new MJPanel((LayoutManager)new BorderLayout());
        this.fResizeStatusBar = new MJPanel((LayoutManager)new BorderLayout());
        this.fResizeStatusBar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fResizeStatusBar.setBackground(DEFAULT_BACKGROUND_COLOR);
        this.fResizeStatusBar.add((Component)mACCornerGrip, (Object)"East");
        this.fResizeStatusBar.add((Component)this.fScopePanel, (Object)"Center");
        this.fRestoreBounds = this.fResizeStatusBar.getBounds();
        this.getContentPane().setBackground(DEFAULT_BACKGROUND_COLOR);
        this.getContentPane().add((Component)this.fGripperPanel, "North");
        this.getContentPane().add((Component)this.fContentPanel, "Center");
        this.getContentPane().add((Component)this.fResizeStatusBar, "South");
    }

    private void setComponentToMove() {
        ComponentMover componentMover = new ComponentMover((Component)((Object)this));
        this.fGripper.addMouseListener((MouseListener)componentMover);
        this.fGripper.addMouseMotionListener((MouseMotionListener)componentMover);
    }

    private void addTitlebarWindowListener() {
        if (this.fTitlebarWindowListener != null) {
            return;
        }
        this.fTitlebarWindowListener = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                TearOffDialog.this.setActive(true);
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                TearOffDialog.this.setActive(false);
            }
        };
        this.addWindowListener(this.fTitlebarWindowListener);
    }

    private void setActive(boolean bl) {
        Color color;
        Color color2 = color = bl ? TearOffDialog.getPopupSelectionColor() : TearOffDialog.getPopupNonselectionColor();
        if (this.isFloating()) {
            this.fGripperPanel.setBackground(color);
        }
        this.fCloseButton.setActive(bl);
        if (this.fShowMaximizeRestoreButtons) {
            this.fMaximizeButton.setActive(bl);
            this.fRestoreButton.setActive(bl);
        }
        Border border = BorderFactory.createLineBorder(color, 1);
        ((JComponent)this.getContentPane()).setBorder(border);
    }

    private static Color getPopupNonselectionColor() {
        return UIManager.getColor("InternalFrame.inactiveTitleBackground");
    }

    private static Color getPopupSelectionColor() {
        return PlatformInfo.isMacintosh() ? UIManager.getColor("TextField.selectionBackground") : UIManager.getColor("InternalFrame.activeTitleBackground");
    }

    public void dispose() {
        this.close();
        this.fGripper = null;
        this.fGripperPanel = null;
        this.fTitlePanel = null;
        this.fFrameMover = null;
        this.fCloseButton = null;
        this.fMaximizeButton = null;
        this.fRestoreButton = null;
        this.fScopePanel = null;
        this.fContentPanel = null;
        this.removeWindowListener(this.fTitlebarWindowListener);
        this.fTitlebarWindowListener = null;
        super.dispose();
    }

    public void makeTransient() {
        if (!this.isFloating()) {
            return;
        }
        this.fFloatingState = FloatingState.TRANSIENT;
        this.installCloser();
        int n = this.getHeight() + this.fGripper.getHeight() - 16;
        this.setSize(this.getWidth(), n);
        this.fFrameMover.setCursor(new Cursor(13));
        this.fTitlePanel.setVisible(false);
        this.fGripper.setVisible(true);
        this.fGripperPanel.setBackground(DEFAULT_BACKGROUND_COLOR);
        this.fGripperPanel.revalidate();
        this.repaint();
    }

    @Override
    public void makeFloating() {
        if (this.isFloating()) {
            return;
        }
        this.fFloatingState = FloatingState.FLOATING;
        this.uninstallCloser();
        int n = this.getHeight() - this.fGripper.getHeight() + 16;
        this.setSize(this.getWidth(), n);
        this.fFrameMover.setCursor(null);
        this.fTitlePanel.setVisible(true);
        this.fGripper.setVisible(false);
        this.fGripperPanel.revalidate();
        this.repaint();
    }

    @Override
    public void floatingComplete() {
        this.fFrameMover.setCursor(null);
    }

    public boolean isFloating() {
        return this.fFloatingState == FloatingState.FLOATING;
    }

    private void installCloser() {
        this.fCloser.install(this);
    }

    private void uninstallCloser() {
        this.fCloser.uninstall(this);
    }

    public static MJFrame getDefaultHostFrame() {
        DTFrame dTFrame = null;
        if (Matlab.isMatlabAvailable()) {
            Desktop desktop = MatlabDesktopServices.getDesktop();
            Component component = desktop.getSelected();
            if (component != null) {
                dTFrame = desktop.getContainingFrame(component);
            } else {
                String string = desktop.getSelectedGroup();
                if (string != null) {
                    dTFrame = desktop.getFrameContainingGroup(string);
                }
            }
            if (dTFrame == null) {
                dTFrame = desktop.getMainFrame();
            }
        }
        return dTFrame;
    }

    static {
        if (MJUtilities.isHighContrast()) {
            DEFAULT_BACKGROUND_COLOR = Color.black;
            GRAY_COLOR = Color.black;
        }
    }

    private static class DefaultTearOffCloser
    extends DTClientAdapter
    implements TearOffCloser {
        private TearOffDialog fTearOff;

        private DefaultTearOffCloser() {
        }

        @Override
        public void install(TearOffDialog tearOffDialog) {
            this.fTearOff = tearOffDialog;
            if (Matlab.isMatlabAvailable()) {
                MatlabDesktopServices.getDesktop().addClientListener((DTClientListener)this);
            }
        }

        @Override
        public void uninstall(TearOffDialog tearOffDialog) {
            if (Matlab.isMatlabAvailable()) {
                MatlabDesktopServices.getDesktop().removeClientListener((DTClientListener)this);
            }
            this.fTearOff = null;
        }

        public void clientActivated(DTClientEvent dTClientEvent) {
            this.closeTearOff();
        }

        public void clientRelocated(DTClientEvent dTClientEvent) {
            this.closeTearOff();
        }

        public void clientResized(DTClientEvent dTClientEvent) {
            this.closeTearOff();
        }

        private void closeTearOff() {
            if (this.fTearOff != null && !this.fTearOff.isFloating() && this.fTearOff.isVisible()) {
                this.fTearOff.close();
            }
        }
    }

    public static enum FloatingState {
        FLOATING,
        TRANSIENT;

    }
}

