/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.peermodel.synchronizer.utils.strategies;

import com.mathworks.peermodel.synchronizer.utils.ImageDifferenceStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ImageDifferenceStrategy2
implements ImageDifferenceStrategy {
    private static final double SHRINK_THRESHOLD = 0.25;
    private static final int MAX_DEPTH = 1;
    private Collection<Map<String, Object>> diffs;
    private BufferedImage newImage;
    private Raster oldRaster;
    private Raster newRaster;
    private Object oldPixels = null;
    private Object newPixels = null;

    @Override
    public void diffImages(BufferedImage oldImage, BufferedImage newImage, Collection<Map<String, Object>> diffs) {
        this.diffs = diffs;
        this.oldRaster = oldImage.getRaster();
        this.newImage = newImage;
        this.newRaster = newImage.getRaster();
        this.divideAndShrink(new Tile(0, 0, oldImage.getWidth(), oldImage.getHeight()), 0.0, 0);
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
    }

    protected void divideAndShrink(Tile tile, double lastShrinkage, int depth) {
        Tile newTile = this.shrinkTile(tile);
        if (newTile == null) {
            return;
        }
        double shrinkage = (double)(newTile.w * newTile.h) / (double)(tile.w * tile.h);
        if (shrinkage > 0.25 && lastShrinkage > 0.25 || depth > 1) {
            this.addTileImage(tile);
            return;
        }
        int w1 = newTile.w / 2;
        int h1 = newTile.h / 2;
        int w2 = newTile.w - newTile.w / 2;
        int h2 = newTile.h - newTile.h / 2;
        if (depth % 2 == 0) {
            this.divideAndShrink(new Tile(newTile.i, newTile.j, newTile.w, h1), shrinkage, depth + 1);
            this.divideAndShrink(new Tile(newTile.i, newTile.j + h1, newTile.w, h2), shrinkage, depth + 1);
        } else {
            this.divideAndShrink(new Tile(newTile.i, newTile.j, w1, newTile.h), shrinkage, depth + 1);
            this.divideAndShrink(new Tile(newTile.i + w1, newTile.j, w2, newTile.h), shrinkage, depth + 1);
        }
    }

    protected boolean isPixelChanged(int x, int y) {
        this.oldPixels = this.oldRaster.getDataElements(x, y, this.oldPixels);
        this.newPixels = this.newRaster.getDataElements(x, y, this.newPixels);
        if (this.oldPixels instanceof byte[]) {
            for (int i = 0; i < ((byte[])this.oldPixels).length; ++i) {
                if (((byte[])this.oldPixels)[i] == ((byte[])this.newPixels)[i]) continue;
                return true;
            }
        } else if (this.oldPixels instanceof int[]) {
            for (int i = 0; i < ((int[])this.oldPixels).length; ++i) {
                if (((int[])this.oldPixels)[i] == ((int[])this.newPixels)[i]) continue;
                return true;
            }
        } else {
            throw new IllegalStateException("pixel data format something other than int[] or byte[]");
        }
        return false;
    }

    protected Tile shrinkTile(Tile tile) {
        int i;
        int j;
        int newI = -1;
        int newJ = -1;
        int newW = -1;
        int newH = -1;
        block0: for (j = tile.j; j < tile.j + tile.h && newJ < 0; ++j) {
            for (i = tile.i; i < tile.i + tile.w; ++i) {
                if (!this.isPixelChanged(i, j)) continue;
                newJ = j;
                continue block0;
            }
        }
        if (newJ < 0) {
            return null;
        }
        block2: for (j = tile.j + tile.h - 1; j >= newJ && newH < 0; --j) {
            for (i = tile.i; i < tile.i + tile.w; ++i) {
                if (!this.isPixelChanged(i, j)) continue;
                newH = j - newJ + 1;
                continue block2;
            }
        }
        if (newH < 0) {
            return null;
        }
        block4: for (i = tile.i; i < tile.i + tile.w && newI < 0; ++i) {
            for (j = newJ; j < newJ + newH; ++j) {
                if (!this.isPixelChanged(i, j)) continue;
                newI = i;
                continue block4;
            }
        }
        if (newI < 0) {
            return null;
        }
        block6: for (i = tile.i + tile.w - 1; i >= newI && newW < 0; --i) {
            for (j = newJ; j < newJ + newH; ++j) {
                if (!this.isPixelChanged(i, j)) continue;
                newW = i - newI + 1;
                continue block6;
            }
        }
        if (newW < 0) {
            return null;
        }
        return new Tile(newI, newJ, newW, newH);
    }

    protected void addTileImage(Tile tile) {
        if (tile.w > 0 && tile.h > 0) {
            HashMap<String, Object> diff = new HashMap<String, Object>();
            diff.put("x", tile.i);
            diff.put("y", tile.j);
            diff.put("image", this.newImage.getSubimage(tile.i, tile.j, tile.w, tile.h));
            this.diffs.add(diff);
        }
    }

    private static class Tile {
        public final int i;
        public final int j;
        public final int w;
        public final int h;

        public Tile(int i, int j, int w, int h) {
            this.i = i;
            this.j = j;
            this.w = w;
            this.h = h;
        }

        public String toString() {
            return "{i:" + this.i + ",j:" + this.j + ",w:" + this.w + ",h:" + this.h + "}";
        }
    }
}

