/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.peermodel.synchronizer.utils.strategies;

import com.mathworks.peermodel.synchronizer.utils.ImageDifferenceStrategy;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ImageDifferenceStrategy1
implements ImageDifferenceStrategy {
    private WritableRaster oldRaster;
    private WritableRaster newRaster;
    private Object oldPixels;
    private Object newPixels;

    @Override
    public void diffImages(BufferedImage oldImage, BufferedImage newImage, Collection<Map<String, Object>> diffs) {
        this.oldRaster = oldImage.getRaster();
        this.newRaster = newImage.getRaster();
        assert (oldImage.getColorModel().getNumComponents() == newImage.getColorModel().getNumComponents());
        this.diffImages(newImage, 0, 0, newImage.getWidth() / 2, newImage.getHeight() / 2, diffs);
        this.diffImages(newImage, newImage.getWidth() / 2, 0, newImage.getWidth() / 2, newImage.getHeight() / 2, diffs);
        this.diffImages(newImage, 0, newImage.getHeight() / 2, newImage.getWidth() / 2, newImage.getHeight() / 2, diffs);
        this.diffImages(newImage, newImage.getWidth() / 2, newImage.getHeight() / 2, newImage.getWidth() / 2, newImage.getHeight() / 2, diffs);
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
    }

    private void diffImages(BufferedImage newImage, int x, int y, int width, int height, Collection<Map<String, Object>> diffs) {
        int xStart = width;
        int yStart = height;
        int xEnd = x;
        int yEnd = y;
        boolean different = false;
        for (int j = y; j < height + y; ++j) {
            for (int i = x; i < width + x; ++i) {
                if (!this.isPixelChanged(i, j)) continue;
                different = true;
                xStart = Math.min(xStart, i);
                xEnd = Math.max(xEnd, i);
                yStart = Math.min(yStart, j);
                yEnd = Math.max(yEnd, j);
            }
        }
        if (different) {
            int w = xEnd - xStart + 1;
            int h = yEnd - yStart + 1;
            HashMap<String, Object> diff = new HashMap<String, Object>();
            diff.put("x", xStart);
            diff.put("y", yStart);
            diff.put("image", newImage.getSubimage(xStart, yStart, w, h));
            diffs.add(diff);
        }
    }

    protected boolean isPixelChanged(int x, int y) {
        this.oldPixels = this.oldRaster.getDataElements(x, y, this.oldPixels);
        this.newPixels = this.newRaster.getDataElements(x, y, this.newPixels);
        if (this.oldPixels instanceof byte[]) {
            assert (((byte[])this.oldPixels).length == ((byte[])this.newPixels).length);
            for (int i = 0; i < ((byte[])this.oldPixels).length; ++i) {
                if (((byte[])this.oldPixels)[i] == ((byte[])this.newPixels)[i]) continue;
                return true;
            }
        } else if (this.oldPixels instanceof int[]) {
            for (int i = 0; i < ((int[])this.oldPixels).length; ++i) {
                if (((int[])this.oldPixels)[i] == ((int[])this.newPixels)[i]) continue;
                return true;
            }
        } else {
            throw new IllegalStateException("pixel data format something other than int[] or byte[]");
        }
        return false;
    }
}

