/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.event.GlobalEventListener;
import com.mathworks.util.event.GlobalEventManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import javax.swing.SwingUtilities;

public class RequestQueue {
    private final String fName;
    private final Queue<Runnable> fQueue;
    private Thread fThread;
    private static final long KEEP_ALIVE_MILLISECONDS = 10000L;
    public static final RequestQueue EDT = new RequestQueue("EDT RequestQueue"){

        @Override
        public void request(Runnable runnable) {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    };

    public RequestQueue(String string) {
        this.fName = string;
        this.fQueue = new LinkedList<Runnable>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(Runnable runnable) {
        Queue<Runnable> queue = this.fQueue;
        synchronized (queue) {
            this.fQueue.offer(runnable);
            this.startThreadIfNecessary();
            this.fQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThreadIfNecessary() {
        Queue<Runnable> queue = this.fQueue;
        synchronized (queue) {
            if (this.fThread == null) {
                this.fThread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            do {
                                RequestQueue.this.execute();
                            } while (RequestQueue.this.waitForRequestUntilTimeout());
                            Queue queue = RequestQueue.this.fQueue;
                            synchronized (queue) {
                                RequestQueue.this.fThread = null;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                    }
                });
                this.fThread.setName(this.fName);
                this.fThread.setDaemon(true);
                this.fThread.start();
                GlobalEventManager.addListener("shutdown", new GlobalEventListener(){

                    @Override
                    public void actionPerformed(String string) {
                        Thread thread = RequestQueue.this.fThread;
                        if (thread != null) {
                            thread.interrupt();
                            try {
                                thread.join();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() throws InterruptedException {
        ArrayList<Runnable> arrayList;
        Queue<Runnable> queue = this.fQueue;
        synchronized (queue) {
            arrayList = new ArrayList<Runnable>(this.fQueue);
            this.fQueue.clear();
        }
        for (Runnable runnable : arrayList) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForRequestUntilTimeout() throws InterruptedException {
        Queue<Runnable> queue = this.fQueue;
        synchronized (queue) {
            if (this.fQueue.isEmpty()) {
                this.fQueue.wait(10000L);
                return !this.fQueue.isEmpty();
            }
            return true;
        }
    }
}

