/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class CircularBuffer<E>
implements Iterable<E> {
    private Object[] fElements;
    private int fStartIndex;
    private int fCount;

    public CircularBuffer(int n) {
        this.fElements = new Object[n];
    }

    public void setCapacity(int n) {
        if (n == this.fElements.length) {
            return;
        }
        Object[] objectArray = new Object[n];
        if (n < this.fCount) {
            this.fStartIndex += this.fCount - n;
            this.fCount = n;
            if (this.fStartIndex > this.fElements.length) {
                this.fStartIndex -= this.fElements.length;
            }
        }
        int n2 = 0;
        int n3 = this.fCount;
        if (this.fStartIndex + this.fCount > this.fElements.length) {
            n3 = this.fElements.length - this.fStartIndex;
            System.arraycopy(this.fElements, this.fStartIndex, objectArray, 0, n3);
            this.fStartIndex = 0;
            n2 = n3;
            n3 = this.fCount - n3;
        }
        System.arraycopy(this.fElements, this.fStartIndex, objectArray, n2, n3);
        this.fElements = objectArray;
        this.fStartIndex = 0;
    }

    public int capacity() {
        return this.fElements.length;
    }

    public int size() {
        return this.fCount;
    }

    public boolean isEmpty() {
        return this.fCount == 0;
    }

    public void add(E e) {
        int n = this.fStartIndex + this.fCount;
        if (n >= this.fElements.length) {
            n -= this.fElements.length;
        }
        this.fElements[n] = e;
        if (this.fCount == this.fElements.length) {
            ++this.fStartIndex;
            if (this.fStartIndex == this.fElements.length) {
                this.fStartIndex = 0;
            }
        } else {
            ++this.fCount;
        }
    }

    public E get(int n) {
        return (E)this.fElements[this.incrementIndex(this.fStartIndex, n)];
    }

    public void insert(List<E> list, int[] nArray) {
        if (nArray.length > 0) {
            ListIterator<E> listIterator = list.listIterator(list.size());
            int n = this.incrementIndex(this.fStartIndex, this.fCount - 1);
            int n2 = this.incrementIndex(n, nArray.length);
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n3 = this.incrementIndex(this.fStartIndex, nArray[i]);
                for (int j = 0; n2 != n3 && j < this.fElements.length; ++j) {
                    this.fElements[n2] = this.fElements[n];
                    n2 = this.decrementIndex(n2);
                    n = this.decrementIndex(n);
                }
                this.fElements[n2] = listIterator.previous();
                n2 = this.decrementIndex(n2);
            }
            this.fCount += nArray.length;
            if (this.fCount > this.fElements.length) {
                this.fStartIndex = this.incrementIndex(this.fStartIndex, this.fCount - this.fElements.length);
                this.fCount = this.fElements.length;
            }
        }
    }

    public List<E> remove(int[] nArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (nArray.length > 0) {
            int n;
            int n2 = nArray[0];
            int n3 = n = this.incrementIndex(this.fStartIndex, n2);
            for (int i = 1; i <= nArray.length; ++i) {
                arrayList.add(this.fElements[n3]);
                n3 = this.incrementIndex(n3);
                int n4 = (i < nArray.length ? nArray[i] : this.fCount) - n2 - 1;
                for (int j = 0; j < n4; ++j) {
                    this.fElements[n] = this.fElements[n3];
                    n = this.incrementIndex(n);
                    n3 = this.incrementIndex(n3);
                }
                n2 += n4 + 1;
            }
            this.fCount -= nArray.length;
        }
        return arrayList;
    }

    public void clear() {
        this.fStartIndex = 0;
        this.fCount = 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new LocalIterator();
    }

    public ListIterator<E> listIterator() {
        return new LocalIterator();
    }

    public ListIterator<E> listIterator(int n) {
        return new LocalIterator(n);
    }

    private int incrementIndex(int n) {
        return this.incrementIndex(n, 1);
    }

    private int decrementIndex(int n) {
        return this.incrementIndex(n, -1);
    }

    private int incrementIndex(int n, int n2) {
        int n3 = n + n2;
        if (n3 >= this.fElements.length) {
            n3 -= this.fElements.length;
        }
        if (n3 < 0) {
            n3 += this.fElements.length;
        }
        return n3;
    }

    private class LocalIterator
    implements ListIterator<E> {
        private int iIndex;

        private LocalIterator() {
            this.iIndex = 0;
        }

        private LocalIterator(int n) {
            this.iIndex = n;
        }

        @Override
        public boolean hasNext() {
            return this.iIndex < CircularBuffer.this.fCount;
        }

        @Override
        public E next() {
            Object e = CircularBuffer.this.get(this.iIndex);
            ++this.iIndex;
            return e;
        }

        @Override
        public boolean hasPrevious() {
            return this.iIndex > 0;
        }

        @Override
        public E previous() {
            Object e = CircularBuffer.this.get(this.iIndex);
            --this.iIndex;
            return e;
        }

        @Override
        public int nextIndex() {
            return this.iIndex + 1;
        }

        @Override
        public int previousIndex() {
            return this.iIndex - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

