/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CategoricalVariable<T> {
    private final Map<T, String> fCategories;
    private List<T> fInvisibleCategoryValues = new ArrayList<T>();
    private Map<String, String> fLocalizedCategoryLookup;
    private final ICategoriesUpdater catUpdater;
    private final Comparator<T> categoryComparator;
    private volatile T value;
    private volatile String name;

    public CategoricalVariable(Map<T, String> map2, Map<String, String> map3, Comparator<T> comparator) {
        this(map2, comparator);
        this.fLocalizedCategoryLookup = map3;
    }

    public Map<String, String> getLocalizedCategoryMap() {
        return this.fLocalizedCategoryLookup;
    }

    public CategoricalVariable(Map<T, String> map2, Comparator<T> comparator) {
        this(map2, (ICategoriesUpdater)null, comparator);
        if (map2 == null || map2.isEmpty()) {
            throw new IllegalArgumentException("Category set must not be empty");
        }
    }

    public CategoricalVariable(ICategoriesUpdater<T> iCategoriesUpdater, Comparator<T> comparator) {
        this(null, iCategoriesUpdater, comparator);
        if (iCategoriesUpdater == null) {
            throw new IllegalArgumentException("Category updater must not be null");
        }
    }

    private CategoricalVariable(Map<T, String> map2, ICategoriesUpdater<T> iCategoriesUpdater, Comparator<T> comparator) {
        this.catUpdater = iCategoriesUpdater;
        this.categoryComparator = comparator;
        this.fCategories = comparator != null ? Collections.synchronizedSortedMap(new TreeMap(comparator)) : Collections.synchronizedMap(new HashMap());
        this.setCategories(map2);
        this.assignFirstElement();
    }

    private static CategoricalVariable<Integer> newInstance(int n, int[] nArray, int[] nArray2, String[] stringArray, String[] stringArray2) {
        assert (nArray != null);
        assert (stringArray != null);
        assert (nArray.length == stringArray.length);
        final ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length);
        Object object = nArray;
        int n2 = ((int[])object).length;
        for (int i = 0; i < n2; ++i) {
            Integer n3 = object[i];
            arrayList.add(n3);
        }
        object = new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                Integer n3 = arrayList.indexOf(n);
                assert (n3 != -1) : "" + n + " is not a valid category.";
                Integer n4 = arrayList.indexOf(n2);
                assert (n4 != -1) : "" + n2 + " is not a valid category.";
                return n3.compareTo(n4);
            }
        };
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>(nArray.length);
        HashMap<String, String> hashMap2 = new HashMap<String, String>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            hashMap.put(nArray[i], stringArray[i]);
            hashMap2.put(stringArray[i], stringArray2[i]);
        }
        CategoricalVariable<Integer> categoricalVariable = new CategoricalVariable<Integer>((Map<Integer, String>)hashMap, (Map<String, String>)hashMap2, (Comparator<Integer>)object);
        categoricalVariable.setValue(n);
        if (nArray2 != null) {
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (int i = 0; i < nArray2.length; ++i) {
                arrayList2.add(nArray2[i]);
            }
            super.setInvisibleCategories(arrayList2);
        }
        return categoricalVariable;
    }

    public CategoricalVariable(CategoricalVariable<T> categoricalVariable) {
        if (categoricalVariable == null) {
            throw new IllegalArgumentException("Input argument must not be null");
        }
        this.name = categoricalVariable.name;
        this.catUpdater = categoricalVariable.catUpdater;
        this.categoryComparator = categoricalVariable.categoryComparator;
        this.fLocalizedCategoryLookup = categoricalVariable.fLocalizedCategoryLookup;
        this.fCategories = this.categoryComparator != null ? Collections.synchronizedSortedMap(new TreeMap(this.categoryComparator)) : Collections.synchronizedMap(new HashMap());
        this.fCategories.putAll(categoricalVariable.fCategories);
        this.value = categoricalVariable.value;
    }

    public final synchronized T getValue() {
        return this.value;
    }

    public synchronized void setValue(T t) {
        assert (this.isValidValue(t)) : "Value is not a valid category: " + t;
        this.value = t;
    }

    public final synchronized boolean isValidValue(T t) {
        for (T t2 : this.fCategories.keySet()) {
            if (!t2.equals(t)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean equals(Object object) {
        if (!(object instanceof CategoricalVariable)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        CategoricalVariable categoricalVariable = (CategoricalVariable)object;
        if (categoricalVariable.value == this.value) {
            return true;
        }
        if (this.value == null) {
            return false;
        }
        return categoricalVariable.value.equals(this.value) && categoricalVariable.fCategories.keySet().equals(this.fCategories.keySet());
    }

    public static boolean equals(CategoricalVariable categoricalVariable, CategoricalVariable categoricalVariable2) {
        if (categoricalVariable == categoricalVariable2) {
            return true;
        }
        if (categoricalVariable != null && categoricalVariable2 != null) {
            return categoricalVariable.equals(categoricalVariable2);
        }
        return false;
    }

    public synchronized int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.value).append(this.fCategories.keySet()).toHashCode();
    }

    public final Map<T, String> getCategories() {
        HashMap<T, String> hashMap = new HashMap<T, String>(this.fCategories);
        this.removeInvisibleCategories(hashMap);
        return Collections.unmodifiableMap(hashMap);
    }

    public final Map<T, String> getLocalizedCategories() {
        if (this.fLocalizedCategoryLookup == null) {
            return this.getCategories();
        }
        HashMap<T, String> hashMap = new HashMap<T, String>();
        for (T t : this.fCategories.keySet()) {
            String string = this.fCategories.get(t);
            if (string == null || string.isEmpty()) continue;
            hashMap.put(t, this.fLocalizedCategoryLookup.get(string));
        }
        this.removeInvisibleCategories(hashMap);
        return hashMap;
    }

    private void removeInvisibleCategories(Map<T, String> map2) {
        if (this.fInvisibleCategoryValues != null) {
            for (T t : this.fInvisibleCategoryValues) {
                map2.remove(t);
            }
        }
    }

    private void setCategories(Map<T, String> map2) {
        if ((map2 == null || map2.isEmpty()) && this.catUpdater != null && ((map2 = this.catUpdater.updateCategories(this.fCategories)) == null || map2.isEmpty())) {
            return;
        }
        this.fCategories.clear();
        this.fCategories.putAll(map2);
        this.setCategoryLabels(this.fCategories);
    }

    private void setInvisibleCategories(List<T> list) {
        this.fInvisibleCategoryValues = list == null ? new ArrayList<T>() : list;
    }

    private void assignFirstElement() {
        block0: {
            Iterator<T> iterator = this.fCategories.keySet().iterator();
            if (!iterator.hasNext()) break block0;
            T t = iterator.next();
            this.setValue(t);
        }
    }

    private void setCategoryLabels(Map<T, String> map2) {
        if (map2 == null) {
            return;
        }
        for (T t : this.fCategories.keySet()) {
            assert (t != null);
            String string = map2.get(t);
            if (string != null) {
                this.fCategories.put(t, string);
                continue;
            }
            this.fCategories.put(t, t.toString());
        }
    }

    public final String getLabel() {
        return this.fCategories.get(this.getValue());
    }

    public final String getLocalizedLabel() {
        String string = this.fCategories.get(this.getValue());
        if (this.fLocalizedCategoryLookup == null || string == null || string.length() == 0) {
            return string;
        }
        return this.fLocalizedCategoryLookup.get(string);
    }

    public List<T> getInvisibleValues() {
        return this.fInvisibleCategoryValues;
    }

    public synchronized boolean updateCategories() {
        if (this.catUpdater == null) {
            return false;
        }
        Map<T, String> map2 = this.catUpdater.updateCategories(Collections.unmodifiableMap(this.fCategories));
        if (map2 == null || map2.isEmpty()) {
            return false;
        }
        this.setCategories(map2);
        if (!this.fCategories.containsKey(this.getValue())) {
            this.assignFirstElement();
        }
        return true;
    }

    public synchronized T findValueByLocalizedLabel(String string) {
        if (this.fLocalizedCategoryLookup != null) {
            for (String string2 : this.fLocalizedCategoryLookup.keySet()) {
                if (!string.equals(this.fLocalizedCategoryLookup.get(string2))) continue;
                return this.findValueByLabel(string2);
            }
        }
        return this.findValueByLabel(string);
    }

    public boolean isValueHidden() {
        return this.fInvisibleCategoryValues.contains(this.getValue());
    }

    public boolean isLocalized() {
        return this.fLocalizedCategoryLookup != null;
    }

    public synchronized T findValueByLabel(String string) {
        for (Map.Entry<T, String> entry : this.fCategories.entrySet()) {
            if (!StringUtils.equals((String)string, (String)entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("value", this.value).append("categories", this.fCategories).append("catUpdater", (Object)this.catUpdater).append("categoryComparator", this.categoryComparator).toString();
    }

    public static interface ICategoriesUpdater<T> {
        public Map<T, String> updateCategories(Map<T, String> var1);
    }
}

