/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.caching;

import com.mathworks.toolbox.javabuilder.caching.BidirectionalMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BidirectionalHashMap<K, V>
implements BidirectionalMap<K, V> {
    private Map<K, V> fMap = new HashMap();
    private Map<V, Set<K>> fReverseMap = new HashMap<V, Set<K>>();

    @Override
    public Set<K> getKeys(V v) {
        return this.fReverseMap.get(v);
    }

    @Override
    public Set<K> removeValue(V v) {
        Set<K> set = this.fReverseMap.get(v);
        if (null != set) {
            for (K k : set) {
                this.fMap.remove(k);
            }
            this.fReverseMap.remove(v);
        }
        return set;
    }

    @Override
    public int size() {
        return this.fMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.fMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.fMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.fReverseMap.containsKey(object);
    }

    @Override
    public V get(Object object) {
        return this.fMap.get(object);
    }

    private void removeFromKeySet(K k, V v) {
        Set<K> set = this.fReverseMap.get(v);
        assert (null != set) : "BidirectionalHashMap internal consistency problem";
        set.remove(k);
        if (set.isEmpty()) {
            this.fReverseMap.remove(v);
        }
    }

    @Override
    public V put(K k, V v) {
        Set<K> set;
        if (null == k || null == v) {
            throw new NullPointerException("BidirectionalHashMap does not accept null key or value");
        }
        V v2 = this.fMap.get(k);
        V v3 = this.fMap.put(k, v);
        if (null != v2 && !v.equals(v2)) {
            this.removeFromKeySet(k, v2);
        }
        if (null == (set = this.fReverseMap.get(v))) {
            set = new HashSet<K>();
        }
        if (null == v2 || !v.equals(v2)) {
            set.add(k);
        }
        this.fReverseMap.put((Set<K>)v, (Set<V>)set);
        return v3;
    }

    @Override
    public V remove(Object object) {
        V v = this.fMap.get(object);
        if (null != v) {
            this.removeFromKeySet(object, v);
            this.fMap.remove(object);
        }
        return v;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map2) {
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.fMap.clear();
        this.fReverseMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.fMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.fReverseMap.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.fMap.entrySet();
    }
}

