/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.AbstractFileLock;
import com.vladium.util.IFileLock;
import java.net.DatagramSocket;
import java.net.SocketException;

final class SocketMutex
extends AbstractFileLock {
    private final int m_port;
    private DatagramSocket m_socket;

    public synchronized void release() {
        if (this.m_socket != null) {
            this.m_socket.close();
            this.m_socket = null;
        }
    }

    public String toString() {
        return "socket mutex {timeout: " + this.m_timeout + ", retries: " + this.m_retries + ", port: " + this.m_port + "}";
    }

    protected void tryAcquire() throws IFileLock.FileLockException {
        DatagramSocket socket;
        if (this.m_socket != null) {
            throw new IFileLock.FileLockException("LOCK_ACQUIRED_ALREADY");
        }
        try {
            socket = new DatagramSocket(this.m_port);
        }
        catch (SocketException se) {
            throw new IFileLock.FileLockException("LOCK_ACQUISITION_FAILURE");
        }
        catch (SecurityException se) {
            throw new IFileLock.FileLockException("LOCK_ACQUISITION_SECURITY_FAILURE", new String[]{"EMMA"}, se);
        }
        this.m_socket = socket;
    }

    SocketMutex(long timeout, int retries, int port) {
        super(timeout, retries);
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port must be in [1, 65535] range: " + port);
        }
        this.m_port = port;
    }
}

