/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security.proxytrust;

import com.sun.jini.logging.Levels;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ProxyTrust;
import net.jini.security.proxytrust.ProxyTrustIterator;

public class ProxyTrustVerifier
implements TrustVerifier {
    private static final Logger logger = Logger.getLogger("net.jini.security.trust");
    private static Method gpvMethod;

    public boolean isTrustedObject(Object object, TrustVerifier.Context context) throws RemoteException {
        if (object == null || context == null) {
            throw new NullPointerException();
        }
        Iterator iterator = context.getCallerContext().iterator();
        while (iterator.hasNext()) {
            MethodConstraints methodConstraints;
            Object e = iterator.next();
            if (!(e instanceof MethodConstraints) || (methodConstraints = (MethodConstraints)e).getConstraints(gpvMethod).isEmpty()) continue;
            TrustVerifier trustVerifier = ProxyTrustVerifier.getVerifier(object, context, methodConstraints);
            return trustVerifier != null && trustVerifier.isTrustedObject(object, context);
        }
        return false;
    }

    private static TrustVerifier getVerifier(Object object, TrustVerifier.Context context, MethodConstraints methodConstraints) throws RemoteException {
        ProxyTrustIterator proxyTrustIterator;
        final Class<?> clazz = object.getClass();
        Method method = (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                    try {
                        Method method = clazz2.getDeclaredMethod("getProxyTrustIterator", new Class[0]);
                        if (ProxyTrustVerifier.usable(method, clazz2, clazz)) {
                            method.setAccessible(true);
                            return method;
                        }
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        continue;
                    }
                }
                return null;
            }
        });
        if (method == null) {
            if (Proxy.isProxyClass(clazz)) {
                return ProxyTrustVerifier.getVerifier(Proxy.getInvocationHandler(object), context, methodConstraints);
            }
            return null;
        }
        logger.log(Level.FINER, "{0} has ProxyTrustIterator", object);
        try {
            proxyTrustIterator = (ProxyTrustIterator)method.invoke(object, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        RemoteException remoteException = null;
        while (proxyTrustIterator.hasNext()) {
            object = null;
            try {
                TrustVerifier trustVerifier;
                object = proxyTrustIterator.next();
                logger.log(Level.FINER, "ProxyTrustIterator produces {0}", object);
                if (object instanceof ProxyTrust) {
                    if (!(object instanceof RemoteMethodControl) || !context.isTrustedObject(object)) continue;
                    object = ((RemoteMethodControl)object).setConstraints(methodConstraints);
                    trustVerifier = ((ProxyTrust)object).getProxyVerifier();
                    logger.log(Level.FINE, "verifier is {0}", trustVerifier);
                    return trustVerifier;
                }
                trustVerifier = ProxyTrustVerifier.getVerifier(object, context, methodConstraints);
                if (trustVerifier == null) continue;
                return trustVerifier;
            }
            catch (RemoteException remoteException2) {
                remoteException = remoteException2;
                if (!(object instanceof ProxyTrust)) continue;
                logger.log(Levels.HANDLED, "setting ProxyTrustIterator exception", remoteException2);
                proxyTrustIterator.setException(remoteException2);
            }
        }
        if (remoteException != null) {
            throw remoteException;
        }
        logger.log(Levels.FAILED, "no verifier obtained from ProxyTrustIterator");
        return null;
    }

    private static boolean usable(Method method, Class clazz, Class clazz2) {
        int n = method.getModifiers();
        return method.getReturnType() == ProxyTrustIterator.class && method.getExceptionTypes().length == 0 && (n & 8) == 0 && ((n & 5) != 0 || ((n & 2) != 0 ? clazz == clazz2 : ProxyTrustVerifier.samePackage(clazz, clazz2)));
    }

    private static boolean samePackage(Class clazz, Class clazz2) {
        if (clazz.getClassLoader() == clazz2.getClassLoader()) {
            String string;
            int n;
            String string2 = clazz.getName();
            int n2 = string2.lastIndexOf(46);
            return n2 == (n = (string = clazz2.getName()).lastIndexOf(46)) && (n2 < 0 || string2.regionMatches(0, string, 0, n2));
        }
        return false;
    }

    static {
        try {
            gpvMethod = ProxyTrust.class.getMethod("getProxyVerifier", new Class[0]);
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

