/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security;

import com.sun.jini.collection.WeakIdentityMap;
import com.sun.jini.logging.Levels;
import com.sun.jini.resource.Service;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import net.jini.security.GrantPermission;
import net.jini.security.IntegrityVerifier;
import net.jini.security.SecurityContext;
import net.jini.security.TrustVerifier;
import net.jini.security.policy.DynamicPolicy;
import net.jini.security.policy.SecurityContextSource;

public final class Security {
    private static final Logger trustLogger = Logger.getLogger("net.jini.security.trust");
    private static final Logger integrityLogger = Logger.getLogger("net.jini.security.integrity");
    private static final Logger policyLogger = Logger.getLogger("net.jini.security.policy");
    private static Map pathToURLsCache = new WeakHashMap(5);
    private static final WeakIdentityMap integrityMap = new WeakIdentityMap();
    private static final ClassContextAccess ctxAccess = (ClassContextAccess)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return new ClassContextAccess();
        }
    });
    static /* synthetic */ Class class$net$jini$security$IntegrityVerifier;
    static /* synthetic */ Class class$net$jini$security$TrustVerifier;

    private Security() {
    }

    public static void verifyObjectTrust(Object object, ClassLoader classLoader, Collection collection) throws RemoteException {
        if (collection == null) {
            throw new NullPointerException("collection cannot be null");
        }
        if (new Context(classLoader, collection).isTrustedObject(object)) {
            return;
        }
        SecurityException securityException = new SecurityException("object is not trusted: " + object);
        if (trustLogger.isLoggable(Levels.FAILED)) {
            Security.logThrow(trustLogger, Levels.FAILED, Security.class.getName(), "verifyObjectTrust", "no verifier trusts {0}", new Object[]{object}, securityException);
        }
        throw securityException;
    }

    public static void verifyCodebaseIntegrity(String string, ClassLoader classLoader) throws MalformedURLException {
        if (string == null) {
            return;
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        URL[] uRLArray = Security.pathToURLs(string);
        IntegrityVerifier[] integrityVerifierArray = Security.getIntegrityVerifiers(classLoader);
        int n = uRLArray.length;
        block0: while (--n >= 0) {
            for (int i = 0; i < integrityVerifierArray.length; ++i) {
                if (!integrityVerifierArray[i].providesIntegrity(uRLArray[n])) continue;
                if (!integrityLogger.isLoggable(Level.FINE)) continue block0;
                integrityLogger.log(Level.FINE, "{0} verifies {1}", new Object[]{integrityVerifierArray[i], uRLArray[n]});
                continue block0;
            }
            SecurityException securityException = new SecurityException("URL does not provide integrity: " + uRLArray[n]);
            if (integrityLogger.isLoggable(Levels.FAILED)) {
                Security.logThrow(integrityLogger, Levels.FAILED, Security.class.getName(), "verifyCodebaseIntegrity", "no verifier verifies {0}", new Object[]{uRLArray[n]}, securityException);
            }
            throw securityException;
        }
    }

    private static void logThrow(Logger logger, Level level, String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setLoggerName(logger.getName());
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setParameters(objectArray);
        logRecord.setThrown(throwable);
        logger.log(logRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL[] pathToURLs(String string) throws MalformedURLException {
        Object[] objectArray;
        Object object = pathToURLsCache;
        synchronized (object) {
            objectArray = (Object[])pathToURLsCache.get(string);
            if (objectArray != null) {
                return (URL[])objectArray[0];
            }
        }
        object = new StringTokenizer(string);
        objectArray = new URL[((StringTokenizer)object).countTokens()];
        int n = 0;
        while (((StringTokenizer)object).hasMoreTokens()) {
            objectArray[n] = new URL(((StringTokenizer)object).nextToken());
            ++n;
        }
        Map map = pathToURLsCache;
        synchronized (map) {
            pathToURLsCache.put(string, new Object[]{objectArray, new SoftReference<String>(string)});
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IntegrityVerifier[] getIntegrityVerifiers(final ClassLoader classLoader) {
        IntegrityVerifier[] integrityVerifierArray = integrityMap;
        synchronized (integrityMap) {
            SoftReference softReference = (SoftReference)integrityMap.get(classLoader);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            integrityVerifierArray = null;
            if (softReference != null) {
                integrityVerifierArray = (IntegrityVerifier[])softReference.get();
            }
            if (integrityVerifierArray == null) {
                final ArrayList arrayList = new ArrayList(1);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Iterator iterator = Service.providers(class$net$jini$security$IntegrityVerifier == null ? (class$net$jini$security$IntegrityVerifier = Security.class$("net.jini.security.IntegrityVerifier")) : class$net$jini$security$IntegrityVerifier, classLoader);
                        while (iterator.hasNext()) {
                            arrayList.add(iterator.next());
                        }
                        return null;
                    }
                });
                if (integrityLogger.isLoggable(Level.FINE)) {
                    integrityLogger.logp(Level.FINE, Security.class.getName(), "verifyCodebaseIntegrity", "integrity verifiers {0}", new Object[]{arrayList});
                }
                integrityVerifierArray = arrayList.toArray(new IntegrityVerifier[arrayList.size()]);
                WeakIdentityMap weakIdentityMap = integrityMap;
                synchronized (weakIdentityMap) {
                    integrityMap.put(classLoader, new SoftReference<IntegrityVerifier[]>(integrityVerifierArray));
                }
            }
            return integrityVerifierArray;
        }
    }

    public static SecurityContext getContext() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager instanceof SecurityContextSource) {
            return ((SecurityContextSource)((Object)securityManager)).getContext();
        }
        Policy policy = Security.getPolicy();
        if (policy instanceof SecurityContextSource) {
            return ((SecurityContextSource)((Object)policy)).getContext();
        }
        final AccessControlContext accessControlContext = AccessController.getContext();
        return new SecurityContext(){

            public PrivilegedAction wrap(PrivilegedAction privilegedAction) {
                if (privilegedAction == null) {
                    throw new NullPointerException();
                }
                return privilegedAction;
            }

            public PrivilegedExceptionAction wrap(PrivilegedExceptionAction privilegedExceptionAction) {
                if (privilegedExceptionAction == null) {
                    throw new NullPointerException();
                }
                return privilegedExceptionAction;
            }

            public AccessControlContext getAccessControlContext() {
                return accessControlContext;
            }
        };
    }

    public static Object doPrivileged(final PrivilegedAction privilegedAction) {
        final Class clazz = ctxAccess.getCaller();
        final AccessControlContext accessControlContext = AccessController.getContext();
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return AccessController.doPrivileged(privilegedAction, Security.createPrivilegedContext(clazz, accessControlContext));
            }
        });
    }

    public static Object doPrivileged(final PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        final Class clazz = ctxAccess.getCaller();
        final AccessControlContext accessControlContext = AccessController.getContext();
        return AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                try {
                    return AccessController.doPrivileged(privilegedExceptionAction, Security.createPrivilegedContext(clazz, accessControlContext));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw privilegedActionException.getException();
                }
            }
        });
    }

    private static AccessControlContext createPrivilegedContext(Class clazz, AccessControlContext accessControlContext) {
        ProtectionDomain[] protectionDomainArray;
        ProtectionDomain[] protectionDomainArray2;
        DomainCombiner domainCombiner = accessControlContext.getDomainCombiner();
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        if (protectionDomain != null) {
            ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[1];
            protectionDomainArray2 = protectionDomainArray3;
            protectionDomainArray3[0] = protectionDomain;
        } else {
            protectionDomainArray2 = protectionDomainArray = null;
        }
        if (domainCombiner != null) {
            protectionDomainArray = domainCombiner.combine(protectionDomainArray, null);
        }
        if (protectionDomainArray == null) {
            protectionDomainArray = new ProtectionDomain[]{};
        }
        return new AccessControlContext(new AccessControlContext(protectionDomainArray), domainCombiner);
    }

    public static boolean grantSupported() {
        Policy policy = Security.getPolicy();
        return policy instanceof DynamicPolicy && ((DynamicPolicy)((Object)policy)).grantSupported();
    }

    public static void grant(Class clazz, Permission[] permissionArray) {
        Security.grant(clazz, Security.getCurrentPrincipals(), permissionArray);
    }

    public static void grant(Class clazz, Principal[] principalArray, Permission[] permissionArray) {
        Policy policy = Security.getPolicy();
        if (!(policy instanceof DynamicPolicy)) {
            throw new UnsupportedOperationException("grants not supported");
        }
        ((DynamicPolicy)((Object)policy)).grant(clazz, principalArray, permissionArray);
        if (policyLogger.isLoggable(Level.FINER)) {
            policyLogger.log(Level.FINER, "granted {0} to {1}, {2}", new Object[]{permissionArray != null ? Arrays.asList(permissionArray) : null, clazz != null ? clazz.getName() : null, principalArray != null ? Arrays.asList(principalArray) : null});
        }
    }

    public static void grant(Class clazz, Class clazz2) {
        if (clazz == null || clazz2 == null) {
            throw new NullPointerException();
        }
        Policy policy = Security.getPolicy();
        if (!(policy instanceof DynamicPolicy)) {
            throw new UnsupportedOperationException("grants not supported");
        }
        DynamicPolicy dynamicPolicy = (DynamicPolicy)((Object)policy);
        Principal[] principalArray = Security.getCurrentPrincipals();
        Permission[] permissionArray = Security.grantablePermissions(dynamicPolicy.getGrants(clazz, principalArray));
        dynamicPolicy.grant(clazz2, principalArray, permissionArray);
        if (policyLogger.isLoggable(Level.FINER)) {
            policyLogger.log(Level.FINER, "granted {0} from {1} to {2}, {3}", new Object[]{permissionArray != null ? Arrays.asList(permissionArray) : null, clazz.getName(), clazz2.getName(), principalArray != null ? Arrays.asList(principalArray) : null});
        }
    }

    private static Policy getPolicy() {
        return (Policy)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Policy.getPolicy();
            }
        });
    }

    private static Permission[] grantablePermissions(Permission[] permissionArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null || permissionArray.length == 0) {
            return permissionArray;
        }
        try {
            securityManager.checkPermission(new GrantPermission(permissionArray));
            return permissionArray;
        }
        catch (SecurityException securityException) {
            ArrayList<Permission> arrayList = new ArrayList<Permission>(permissionArray.length);
            for (int i = 0; i < permissionArray.length; ++i) {
                try {
                    Permission permission = permissionArray[i];
                    securityManager.checkPermission(new GrantPermission(permission));
                    arrayList.add(permission);
                    continue;
                }
                catch (SecurityException securityException2) {
                    // empty catch block
                }
            }
            return arrayList.toArray(new Permission[arrayList.size()]);
        }
    }

    private static Principal[] getCurrentPrincipals() {
        final AccessControlContext accessControlContext = AccessController.getContext();
        Subject subject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Subject.getSubject(accessControlContext);
            }
        });
        if (subject != null) {
            Set<Principal> set = subject.getPrincipals();
            return set.toArray(new Principal[set.size()]);
        }
        return null;
    }

    private static class ClassContextAccess
    extends SecurityManager {
        private ClassContextAccess() {
        }

        Class getCaller() {
            return this.getClassContext()[2];
        }
    }

    private static class Context
    implements TrustVerifier.Context {
        private final TrustVerifier[] verifiers;
        private final ClassLoader cl;
        private final Collection context;
        private static final WeakIdentityMap map = new WeakIdentityMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Context(ClassLoader classLoader, Collection collection) {
            this.cl = classLoader;
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            TrustVerifier[] trustVerifierArray = map;
            synchronized (map) {
                SoftReference softReference = (SoftReference)map.get(classLoader);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                trustVerifierArray = null;
                if (softReference != null) {
                    trustVerifierArray = (TrustVerifier[])softReference.get();
                }
                if (trustVerifierArray == null) {
                    final ArrayList arrayList = new ArrayList(1);
                    final ClassLoader classLoader2 = classLoader;
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            Iterator iterator = Service.providers(class$net$jini$security$TrustVerifier == null ? (class$net$jini$security$TrustVerifier = Security.class$("net.jini.security.TrustVerifier")) : class$net$jini$security$TrustVerifier, classLoader2);
                            while (iterator.hasNext()) {
                                arrayList.add(iterator.next());
                            }
                            return null;
                        }
                    });
                    if (trustLogger.isLoggable(Level.FINE)) {
                        trustLogger.logp(Level.FINE, (class$net$jini$security$Security == null ? (class$net$jini$security$Security = Security.class$("net.jini.security.Security")) : class$net$jini$security$Security).getName(), "verifyObjectTrust", "trust verifiers {0}", arrayList);
                    }
                    trustVerifierArray = arrayList.toArray(new TrustVerifier[arrayList.size()]);
                    WeakIdentityMap weakIdentityMap = map;
                    synchronized (weakIdentityMap) {
                        map.put(classLoader, new SoftReference<TrustVerifier[]>(trustVerifierArray));
                    }
                }
                this.verifiers = trustVerifierArray;
                this.context = collection;
                return;
            }
        }

        public boolean isTrustedObject(Object object) throws RemoteException {
            if (object == null) {
                return true;
            }
            Exception exception = null;
            for (int i = 0; i < this.verifiers.length; ++i) {
                try {
                    if (!this.verifiers[i].isTrustedObject(object, this)) continue;
                    if (trustLogger.isLoggable(Level.FINE)) {
                        trustLogger.log(Level.FINE, "{0} trusts {1}", new Object[]{this.verifiers[i], object});
                    }
                    return true;
                }
                catch (Exception exception2) {
                    Level level;
                    boolean bl = exception2 instanceof RuntimeException && !(exception2 instanceof SecurityException);
                    Level level2 = level = bl ? Levels.FAILED : Levels.HANDLED;
                    if (trustLogger.isLoggable(level)) {
                        Security.logThrow(trustLogger, level, this.getClass().getName(), "isTrustedObject", "{0} checking {1} throws", new Object[]{this.verifiers[i], object}, exception2);
                    }
                    if (bl) {
                        throw (RuntimeException)exception2;
                    }
                    exception = exception2;
                }
            }
            if (exception != null) {
                if (trustLogger.isLoggable(Levels.FAILED)) {
                    Security.logThrow(trustLogger, Levels.FAILED, this.getClass().getName(), "isTrustedObject", "checking {0} throws", new Object[]{object}, exception);
                }
                if (exception instanceof RemoteException) {
                    throw (RemoteException)exception;
                }
                throw (SecurityException)exception;
            }
            if (trustLogger.isLoggable(Levels.FAILED)) {
                trustLogger.log(Levels.FAILED, "no verifier trusts {0}", object);
            }
            return false;
        }

        public ClassLoader getClassLoader() {
            return this.cl;
        }

        public Collection getCallerContext() {
            return this.context;
        }
    }
}

