/*
 * Decompiled with CFR 0.152.
 */
package net.jini.security;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public final class AuthenticationPermission
extends Permission {
    private static final long serialVersionUID = -4733723479228998183L;
    private static final int LISTEN = 1;
    private static final int CONNECT = 2;
    private static final int ACCEPT = 5;
    private static final int DELEGATE = 10;
    private String actions;
    private transient String[] me;
    private transient String[] peer;
    private transient int mask;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$ArrayList;

    public AuthenticationPermission(String string, String string2) {
        super(string);
        this.actions = string2;
        this.init();
    }

    public AuthenticationPermission(Set set, Set set2, String string) {
        this(AuthenticationPermission.parseName(set, set2), string);
    }

    private AuthenticationPermission(Data data, String string) {
        super(data.name);
        this.me = data.me;
        this.peer = data.peer;
        this.actions = string;
        this.parseActions();
    }

    private void init() {
        this.parseActions();
        this.parseName(new StringTokenizer(this.getName(), " ", true), false);
    }

    private void parseActions() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.actions, " ,", true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals(" ")) continue;
            if (bl) {
                if (!string.equals(",")) {
                    bl = false;
                    break;
                }
            } else if (string.equalsIgnoreCase("connect")) {
                this.mask |= 2;
            } else if (string.equalsIgnoreCase("accept")) {
                this.mask |= 5;
            } else if (string.equalsIgnoreCase("delegate")) {
                this.mask |= 0xA;
            } else {
                if (!string.equalsIgnoreCase("listen")) break;
                this.mask |= 1;
            }
            bl = !bl;
        }
        if (!bl) {
            throw new IllegalArgumentException("invalid actions");
        }
    }

    private void parseName(StringTokenizer stringTokenizer, boolean bl) {
        String[] stringArray;
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        block0: while (stringTokenizer.hasMoreTokens()) {
            String string;
            stringArray = stringTokenizer.nextToken();
            if (stringArray.equals(" ")) continue;
            if (!bl && stringArray.equalsIgnoreCase("peer")) {
                this.parseName(stringTokenizer, true);
                break;
            }
            if (stringArray.equals("*")) {
                if (bl) {
                    throw new IllegalArgumentException("peer class cannot be *");
                }
                stringArray = null;
                arrayList = null;
            }
            do {
                if (stringTokenizer.hasMoreTokens()) continue;
                throw new IllegalArgumentException("missing name after class");
            } while ((string = stringTokenizer.nextToken()).equals(" "));
            if (!string.startsWith("\"")) {
                throw new IllegalArgumentException("name must be in quotes");
            }
            while (!string.endsWith("\"")) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new IllegalArgumentException("name must be in quotes");
                }
                string = string + stringTokenizer.nextToken();
            }
            if (string.equals("\"*\"")) {
                if (bl) {
                    throw new IllegalArgumentException("peer name cannot be \"*\"");
                }
                if (stringArray == null) continue;
                string = null;
            } else {
                if (stringArray == null) {
                    throw new IllegalArgumentException("class cannot be * unless name is \"*\"");
                }
                string = string.substring(1, string.length() - 1);
            }
            if (arrayList == null) continue;
            int n = arrayList.size();
            while (n > 0) {
                String string2;
                String string3 = (String)arrayList.get(--n);
                if (!stringArray.equals(string2 = (String)arrayList.get(--n))) continue;
                if (string3 == null || string3 != null && string3.equals(string)) continue block0;
                if (string != null) continue;
                arrayList.remove(n);
                arrayList.remove(n);
            }
            arrayList.add(stringArray);
            arrayList.add(string);
        }
        stringArray = null;
        if (arrayList != null) {
            if (arrayList.isEmpty()) {
                throw new IllegalArgumentException("target name is missing elements");
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        }
        if (bl) {
            this.peer = stringArray;
        } else {
            this.me = stringArray;
        }
    }

    private static String[] cons(Set set, StringBuffer stringBuffer) {
        String[] stringArray = new String[set.size() * 2];
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Principal principal;
            try {
                principal = (Principal)iterator.next();
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("sets must contain Principals");
            }
            String string = principal.getClass().getName();
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string);
            stringArray[n++] = string;
            string = principal.getName();
            stringBuffer.append(" \"");
            stringBuffer.append(string);
            stringBuffer.append('\"');
            stringArray[n++] = string;
        }
        return stringArray;
    }

    private static Data parseName(Set set, Set set2) {
        if (set == null) {
            throw new NullPointerException("local principals must be non-empty");
        }
        if (set.isEmpty()) {
            throw new IllegalArgumentException("local principals must be non-empty");
        }
        Data data = new Data();
        StringBuffer stringBuffer = new StringBuffer();
        data.me = AuthenticationPermission.cons(set, stringBuffer);
        if (set2 != null && !set2.isEmpty()) {
            stringBuffer.append(" peer ");
            data.peer = AuthenticationPermission.cons(set2, stringBuffer);
        }
        data.name = stringBuffer.toString();
        return data;
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof AuthenticationPermission)) {
            return false;
        }
        AuthenticationPermission authenticationPermission = (AuthenticationPermission)permission;
        return (this.mask & authenticationPermission.mask) == authenticationPermission.mask && this.implies0(authenticationPermission);
    }

    private boolean implies0(AuthenticationPermission authenticationPermission) {
        return (this.me == null || authenticationPermission.me != null && AuthenticationPermission.covers(this.me, authenticationPermission.me)) && (authenticationPermission.mask == 1 || this.peer == null || authenticationPermission.peer != null && AuthenticationPermission.covers(authenticationPermission.peer, this.peer));
    }

    private static boolean covers(String[] stringArray, String[] stringArray2) {
        int n = stringArray2.length;
        block0: while (n > 0) {
            String string = stringArray2[--n];
            String string2 = stringArray2[--n];
            int n2 = stringArray.length;
            while (n2 > 0) {
                String string3;
                String string4 = stringArray[--n2];
                if (!(string3 = stringArray[--n2]).equals(string2) || string4 != null && (string == null || !string4.equals(string))) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public String getActions() {
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new AuthenticationPermissionCollection();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AuthenticationPermission)) {
            return false;
        }
        AuthenticationPermission authenticationPermission = (AuthenticationPermission)object;
        return this.mask == authenticationPermission.mask && AuthenticationPermission.same(this.me, authenticationPermission.me) && (this.mask == 1 || AuthenticationPermission.same(this.peer, authenticationPermission.peer));
    }

    private static boolean same(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2 == null;
        }
        if (stringArray2 == null || stringArray.length != stringArray2.length) {
            return false;
        }
        int n = stringArray2.length;
        block0: while (n > 0) {
            String string = stringArray2[--n];
            String string2 = stringArray2[--n];
            int n2 = stringArray.length;
            while (n2 > 0) {
                String string3;
                String string4 = stringArray[--n2];
                if (!(string3 = stringArray[--n2]).equals(string2) || !(string4 == null ? string == null : string4.equals(string))) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n;
        int n2 = this.mask;
        if (this.me != null) {
            n = this.me.length;
            while (--n >= 0) {
                if (this.me[n] == null) continue;
                n2 += this.me[n].hashCode();
            }
        }
        if (this.mask != 1 && this.peer != null) {
            n = this.peer.length;
            while (--n >= 0) {
                n2 += this.peer[n].hashCode();
            }
        }
        return n2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.init();
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException instanceof NullPointerException || runtimeException instanceof IllegalArgumentException) {
                InvalidObjectException invalidObjectException = new InvalidObjectException(runtimeException.getMessage());
                invalidObjectException.initCause(runtimeException);
                throw invalidObjectException;
            }
            throw runtimeException;
        }
    }

    static class AuthenticationPermissionCollection
    extends PermissionCollection {
        private static final long serialVersionUID = -2967578431368213049L;
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", class$java$util$List == null ? (class$java$util$List = AuthenticationPermission.class$("java.util.List")) : class$java$util$List, true)};
        private List permissions = new ArrayList();

        AuthenticationPermissionCollection() {
        }

        public synchronized void add(Permission permission) {
            if (!(permission instanceof AuthenticationPermission)) {
                throw new IllegalArgumentException("element must be an AuthenticationPermission");
            }
            if (this.isReadOnly()) {
                throw new SecurityException("collection is read-only");
            }
            this.permissions.add(permission);
        }

        public synchronized boolean implies(Permission permission) {
            if (!(permission instanceof AuthenticationPermission)) {
                return false;
            }
            AuthenticationPermission authenticationPermission = (AuthenticationPermission)permission;
            int n = authenticationPermission.mask;
            int n2 = this.permissions.size();
            while (--n2 >= 0) {
                AuthenticationPermission authenticationPermission2 = (AuthenticationPermission)this.permissions.get(n2);
                if ((n & authenticationPermission2.mask) == 0 || !authenticationPermission2.implies0(authenticationPermission) || (n &= ~authenticationPermission2.mask) != 0) continue;
                return true;
            }
            return false;
        }

        public synchronized Enumeration elements() {
            return Collections.enumeration(this.permissions);
        }

        public synchronized void setReadOnly() {
            super.setReadOnly();
        }

        public synchronized boolean isReadOnly() {
            return super.isReadOnly();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.permissions == null) {
                throw new InvalidObjectException("list cannot be null");
            }
            if (!this.permissions.getClass().equals(class$java$util$ArrayList == null ? (class$java$util$ArrayList = AuthenticationPermission.class$("java.util.ArrayList")) : class$java$util$ArrayList)) {
                this.permissions = new ArrayList(this.permissions);
            }
            int n = this.permissions.size();
            while (--n >= 0) {
                if (this.permissions.get(n) instanceof AuthenticationPermission) continue;
                throw new InvalidObjectException("element must be an AuthenticationPermission");
            }
        }

        private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
        }
    }

    private static final class Data {
        String name;
        String[] me;
        String[] peer;

        Data() {
        }
    }
}

