/*
 * Decompiled with CFR 0.152.
 */
package net.jini.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.jini.io.MarshalInputStream;
import net.jini.io.MarshalOutputStream;
import net.jini.io.MarshalledObject;
import net.jini.io.context.IntegrityEnforcement;

public class MarshalledInstance
implements Serializable {
    private byte[] objBytes = null;
    private byte[] locBytes = null;
    private int hash;
    static final long serialVersionUID = -5187033771082433496L;
    static /* synthetic */ Class class$net$jini$io$MarshalledObject;
    static /* synthetic */ Class class$java$rmi$MarshalledObject;

    public MarshalledInstance(Object object) throws IOException {
        this(object, Collections.EMPTY_SET);
    }

    public MarshalledInstance(Object object, Collection collection) throws IOException {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (object == null) {
            this.hash = 13;
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        MarshalledInstanceOutputStream marshalledInstanceOutputStream = new MarshalledInstanceOutputStream(byteArrayOutputStream, byteArrayOutputStream2, collection);
        marshalledInstanceOutputStream.writeObject(object);
        marshalledInstanceOutputStream.flush();
        this.objBytes = byteArrayOutputStream.toByteArray();
        this.locBytes = marshalledInstanceOutputStream.hadAnnotations() ? byteArrayOutputStream2.toByteArray() : null;
        int n = 0;
        for (int i = 0; i < this.objBytes.length; ++i) {
            n = 31 * n + this.objBytes[i];
        }
        this.hash = n;
    }

    public MarshalledInstance(java.rmi.MarshalledObject marshalledObject) {
        if (marshalledObject == null) {
            throw new NullPointerException();
        }
        MarshalledObject marshalledObject2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(marshalledObject);
            objectOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            FromMOInputStream fromMOInputStream = new FromMOInputStream(byteArrayInputStream);
            marshalledObject2 = (MarshalledObject)fromMOInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        this.objBytes = marshalledObject2.objBytes;
        this.locBytes = marshalledObject2.locBytes;
        this.hash = marshalledObject2.hash;
    }

    public java.rmi.MarshalledObject convertToMarshalledObject() {
        MarshalledObject marshalledObject = new MarshalledObject();
        marshalledObject.objBytes = this.objBytes;
        marshalledObject.locBytes = this.locBytes;
        marshalledObject.hash = this.hash;
        java.rmi.MarshalledObject marshalledObject2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(marshalledObject);
            objectOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ToMOInputStream toMOInputStream = new ToMOInputStream(byteArrayInputStream);
            marshalledObject2 = (java.rmi.MarshalledObject)toMOInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        return marshalledObject2;
    }

    public Object get(boolean bl) throws IOException, ClassNotFoundException {
        return this.get(null, bl, null, null);
    }

    public Object get(ClassLoader classLoader, final boolean bl, ClassLoader classLoader2, Collection set) throws IOException, ClassNotFoundException {
        if (this.objBytes == null) {
            return null;
        }
        if (set == null) {
            set = Collections.singleton(new IntegrityEnforcement(){

                public boolean integrityEnforced() {
                    return bl;
                }
            });
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.objBytes);
        ByteArrayInputStream byteArrayInputStream2 = this.locBytes == null ? null : new ByteArrayInputStream(this.locBytes);
        MarshalledInstanceInputStream marshalledInstanceInputStream = new MarshalledInstanceInputStream(byteArrayInputStream, byteArrayInputStream2, classLoader, bl, classLoader2, set);
        marshalledInstanceInputStream.useCodebaseAnnotations();
        Object object = marshalledInstanceInputStream.readObject();
        marshalledInstanceInputStream.close();
        return object;
    }

    public boolean fullyEquals(Object object) {
        if (this.equals(object)) {
            MarshalledInstance marshalledInstance = (MarshalledInstance)object;
            return Arrays.equals(this.locBytes, marshalledInstance.locBytes);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MarshalledInstance) {
            MarshalledInstance marshalledInstance = (MarshalledInstance)object;
            if (this.hash != marshalledInstance.hash) {
                return false;
            }
            return Arrays.equals(this.objBytes, marshalledInstance.objBytes);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.objBytes == null && (this.hash != 13 || this.locBytes != null)) {
            throw new InvalidObjectException("Bad hash or annotation");
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("Bad class hierarchy");
    }

    private static class ToMOInputStream
    extends ObjectInputStream {
        public ToMOInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            if (objectStreamClass.getName().equals("net.jini.io.MarshalledObject")) {
                return class$java$rmi$MarshalledObject == null ? (class$java$rmi$MarshalledObject = MarshalledInstance.class$("java.rmi.MarshalledObject")) : class$java$rmi$MarshalledObject;
            }
            return super.resolveClass(objectStreamClass);
        }
    }

    private static class FromMOInputStream
    extends ObjectInputStream {
        public FromMOInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            if (objectStreamClass.getName().equals("java.rmi.MarshalledObject")) {
                return class$net$jini$io$MarshalledObject == null ? (class$net$jini$io$MarshalledObject = MarshalledInstance.class$("net.jini.io.MarshalledObject")) : class$net$jini$io$MarshalledObject;
            }
            return super.resolveClass(objectStreamClass);
        }
    }

    private static class MarshalledInstanceInputStream
    extends MarshalInputStream {
        private ObjectInputStream locIn;

        MarshalledInstanceInputStream(InputStream inputStream, InputStream inputStream2, ClassLoader classLoader, boolean bl, ClassLoader classLoader2, Collection collection) throws IOException {
            super(inputStream, classLoader, bl, classLoader2, collection);
            this.locIn = inputStream2 == null ? null : new ObjectInputStream(inputStream2);
        }

        protected String readAnnotation() throws IOException, ClassNotFoundException {
            return this.locIn == null ? null : (String)this.locIn.readObject();
        }
    }

    private static class MarshalledInstanceOutputStream
    extends MarshalOutputStream {
        private ObjectOutputStream locOut;
        private boolean hadAnnotations;

        public MarshalledInstanceOutputStream(OutputStream outputStream, OutputStream outputStream2, Collection collection) throws IOException {
            super(outputStream, collection);
            this.locOut = new ObjectOutputStream(outputStream2);
            this.hadAnnotations = false;
        }

        public boolean hadAnnotations() {
            return this.hadAnnotations;
        }

        protected void writeAnnotation(String string) throws IOException {
            this.hadAnnotations |= string != null;
            this.locOut.writeObject(string);
        }

        public void flush() throws IOException {
            super.flush();
            this.locOut.flush();
        }
    }
}

