/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.config;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class KeyStores {
    private KeyStores() {
        new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore(String string, String string2) throws GeneralSecurityException, IOException {
        if (string == null) {
            throw new NullPointerException("location cannot be null");
        }
        InputStream inputStream = null;
        try {
            Object object;
            try {
                object = new URL(string);
                inputStream = ((URL)object).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                inputStream = new FileInputStream(string);
            }
            inputStream = new BufferedInputStream(inputStream);
            KeyStore keyStore = KeyStore.getInstance(string2 != null ? string2 : KeyStore.getDefaultType());
            keyStore.load(inputStream, null);
            object = keyStore;
            return object;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static X500Principal getX500Principal(String string, KeyStore keyStore) throws KeyStoreException {
        if (string == null) {
            throw new NullPointerException("alias is null");
        }
        if (keyStore == null) {
            throw new NullPointerException("keystore is null");
        }
        Certificate certificate = keyStore.getCertificate(string);
        if (certificate instanceof X509Certificate) {
            return ((X509Certificate)certificate).getSubjectX500Principal();
        }
        return null;
    }
}

