/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.wizard;

import com.mathworks.instutil.InstutilResourceKeys;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public final class ContextMenu
extends JPopupMenu {
    private final JMenuItem fCutItem = this.createItem(InstutilResourceKeys.CONTEXT_CUT, new DefaultEditorKit.CutAction(), 88);
    private final JMenuItem fCopyItem = this.createItem(InstutilResourceKeys.CONTEXT_COPY, new DefaultEditorKit.CopyAction(), 67);
    private final JMenuItem fPasteItem = this.createItem(InstutilResourceKeys.CONTEXT_PASTE, new DefaultEditorKit.PasteAction(), 86);

    public ContextMenu() {
        this.createItem(InstutilResourceKeys.CONTEXT_SELECT_ALL, new TextAction("select-all"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    jTextComponent.selectAll();
                }
            }
        }, 65);
    }

    private JMenuItem createItem(InstutilResourceKeys instutilResourceKeys, ActionListener actionListener, int n) {
        JMenuItem jMenuItem = new JMenuItem(instutilResourceKeys.getString(new Object[0]));
        jMenuItem.addActionListener(actionListener);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int n2 = toolkit.getMenuShortcutKeyMask();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, n2);
        jMenuItem.setAccelerator(keyStroke);
        this.add(jMenuItem);
        return jMenuItem;
    }

    @Override
    public void show(Component component, int n, int n2) {
        JTextComponent jTextComponent = (JTextComponent)component;
        boolean bl = jTextComponent.getSelectionStart() != jTextComponent.getSelectionEnd();
        boolean bl2 = jTextComponent.isEditable() && jTextComponent.isEnabled();
        this.fCutItem.setEnabled(bl && bl2);
        this.fCopyItem.setEnabled(bl);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        boolean bl3 = transferable.isDataFlavorSupported(DataFlavor.stringFlavor);
        this.fPasteItem.setEnabled(bl2 && bl3);
        super.show(jTextComponent, n, n2);
    }
}

