/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.logging;

import com.mathworks.instutil.logging.LoggingFilter;
import com.mathworks.instutil.logging.LoggingFilterStrategy;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class ArgumentLoggingFilterImpl
implements LoggingFilter {
    private Set<Pattern> patterns;
    private final LoggingFilterStrategy loggingFilterStrategy;

    public ArgumentLoggingFilterImpl(LoggingFilterStrategy loggingFilterStrategy) {
        this.loggingFilterStrategy = loggingFilterStrategy;
        this.generatePatterns();
    }

    private void generatePatterns() {
        this.patterns = new HashSet<Pattern>();
        for (String string : this.loggingFilterStrategy.getFilterPatterns()) {
            this.patterns.add(Pattern.compile(string, 2));
        }
    }

    @Override
    public boolean shouldLog(String string) {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(string).matches()) continue;
            return false;
        }
        return true;
    }
}

