/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.licensefiles;

import com.mathworks.instutil.Environment;
import com.mathworks.instutil.FolderUtilsImpl;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.MachineInfo;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.licensefiles.LicenseFileFinder;
import com.mathworks.instutil.licensefiles.LicenseFileLocation;
import com.mathworks.instutil.licensefiles.LicenseLocationFactory;
import com.mathworks.instutil.licensefiles.LicenseUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;

public class LicenseFileFinderDefault
implements LicenseFileFinder {
    private final String fMlRoot;
    private final String fLibPath;
    private final String fRel;
    private final Environment fEnv;
    private final String SNU_LICENSE_DIR = "_licenses";

    public LicenseFileFinderDefault(String string, String string2, Environment environment) {
        this.fMlRoot = string;
        this.fLibPath = string + File.separator + "bin" + File.separator + MachineInfo.getArch();
        this.fRel = string2;
        this.fEnv = environment;
    }

    public LicenseFileFinderDefault(String string, String string2, String string3, Environment environment) {
        this.fMlRoot = string;
        this.fLibPath = string2;
        this.fRel = string3;
        this.fEnv = environment;
    }

    @Override
    public Collection<File> findCurrentLicenseFiles(LicenseLocationFactory licenseLocationFactory) {
        Collection<File> collection = this.getUserLicenseFiles(licenseLocationFactory);
        Collection<File> collection2 = this.getMachineLicenseFiles(licenseLocationFactory);
        Collection<File> collection3 = this.getLMLicenseFiles();
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>(0);
        try {
            if (collection.size() > 0) {
                linkedHashSet.addAll(collection);
            }
            if (collection2.size() > 0) {
                linkedHashSet.addAll(collection2);
            }
            if (collection3.size() > 0) {
                linkedHashSet.addAll(collection3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return linkedHashSet;
    }

    @Override
    public Collection<File> findAllLicenseFiles(LicenseLocationFactory licenseLocationFactory) {
        Collection<File> collection = this.getUserLicenseFilesForAll(licenseLocationFactory);
        Collection<File> collection2 = this.getMachineLicenseFilesForAll(licenseLocationFactory);
        Collection<File> collection3 = this.getLMLicenseFiles();
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>(0);
        try {
            if (collection.size() > 0) {
                linkedHashSet.addAll(collection);
            }
            if (collection2.size() > 0) {
                linkedHashSet.addAll(collection2);
            }
            if (collection3.size() > 0) {
                linkedHashSet.addAll(collection3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return linkedHashSet;
    }

    Collection<File> getUserLicenseFiles(LicenseLocationFactory licenseLocationFactory) {
        LicenseFileLocation licenseFileLocation = licenseLocationFactory.getUserLicenseLocation(this.fLibPath, this.fRel, "");
        String string = licenseFileLocation.getLicenseLocation();
        String string2 = string;
        File[] fileArray = new File(string2).listFiles(new LicenseUtil.LicFileFilter());
        if (fileArray != null && fileArray.length > 0) {
            List<File> list = Arrays.asList(fileArray);
            return list;
        }
        return new ArrayList<File>(0);
    }

    Collection<File> getUserLicenseFilesForAll(LicenseLocationFactory licenseLocationFactory) {
        LicenseFileLocation licenseFileLocation = licenseLocationFactory.getUserLicenseLocation(this.fLibPath, this.fRel, "");
        String string = licenseFileLocation.getLicenseLocation();
        Collection<File> collection = this.getUserLicenseFiles(licenseLocationFactory);
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        linkedHashSet.addAll(collection);
        String string2 = "";
        try {
            string2 = new MachineInfo(this.fLibPath).getUName();
        }
        catch (JNIException jNIException) {
            jNIException.printStackTrace();
        }
        Pattern pattern = Pattern.compile(string2, 2);
        String[] stringArray = pattern.split(string);
        if (stringArray.length == 2) {
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            Collection<File> collection2 = this.findFilesInUserDir(string3, string4, string2);
            linkedHashSet.addAll(collection2);
        }
        return linkedHashSet;
    }

    Collection<File> getMachineLicenseFiles(LicenseLocationFactory licenseLocationFactory) {
        LicenseFileLocation licenseFileLocation = licenseLocationFactory.getMachineLicenseLocation(this.fMlRoot, this.fRel, "");
        String string = licenseFileLocation.getLicenseLocation();
        try {
            File[] fileArray = new File(string).listFiles(new LicenseUtil.LicFileFilter());
            if (fileArray != null && fileArray.length > 0) {
                List<File> list = Arrays.asList(fileArray);
                return list;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return new ArrayList<File>(0);
    }

    Collection<File> getMachineLicenseFilesForAll(LicenseLocationFactory licenseLocationFactory) {
        String[] stringArray;
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        Collection<File> collection = this.getMachineLicenseFiles(licenseLocationFactory);
        linkedHashSet.addAll(collection);
        String string = this.fEnv.getenv("PATH");
        if (string == null) {
            return linkedHashSet;
        }
        for (String string2 : stringArray = string.split(File.pathSeparator)) {
            File file;
            FolderUtilsImpl folderUtilsImpl;
            File file2 = new File(string2);
            if (!file2.isDirectory()) continue;
            String[] stringArray2 = this.getFileNamesToTest(string2);
            File file3 = new File(stringArray2[0]);
            File file4 = new File(stringArray2[1]);
            if (!file3.exists() || !file4.exists() || !(folderUtilsImpl = new FolderUtilsImpl()).hasParent(file = new File(string2))) continue;
            String string3 = folderUtilsImpl.getParent(file);
            LicenseFileLocation licenseFileLocation = licenseLocationFactory.getMachineLicenseLocation(string3, this.fRel, "");
            String string4 = licenseFileLocation.getLicenseLocation();
            try {
                File[] fileArray = new File(string4).listFiles(new LicenseUtil.LicFileFilter());
                if (fileArray == null || fileArray.length <= 0) continue;
                List<File> list = Arrays.asList(fileArray);
                try {
                    linkedHashSet.addAll(list);
                }
                catch (Exception exception) {}
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return linkedHashSet;
    }

    Collection<File> getLMLicenseFiles() {
        String string = this.fEnv.getenv("LM_LICENSE_FILE");
        String string2 = this.fEnv.getenv("MLM_LICENSE_FILE");
        ArrayList<File> arrayList = LicenseUtil.getLicenseFilesFromPath(string);
        ArrayList<File> arrayList2 = LicenseUtil.getLicenseFilesFromPath(string2);
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>(0);
        try {
            if (arrayList.size() > 0) {
                linkedHashSet.addAll(arrayList);
            }
            if (arrayList2.size() > 0) {
                linkedHashSet.addAll(arrayList2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return linkedHashSet;
    }

    private String[] getFileNamesToTest(String string) {
        String[] stringArray = new String[]{"", ""};
        String string2 = MachineInfo.getArch();
        if (new PlatformImpl().isWindows()) {
            stringArray[0] = string + File.separator + "matlab.exe";
            stringArray[1] = string + File.separator + string2 + File.separator + "instutil.dll";
        } else if (new PlatformImpl().isMac()) {
            stringArray[0] = string + File.separator + "matlab";
            stringArray[1] = string + File.separator + string2 + File.separator + "libinstutil.jnilib";
        } else {
            stringArray[0] = string + File.separator + "matlab";
            stringArray[1] = string + File.separator + string2 + File.separator + "libinstutil.so";
        }
        return stringArray;
    }

    private Collection<File> findFilesInUserDir(String string, String string2, String string3) {
        String string4;
        File file;
        File[] fileArray;
        ArrayList<File> arrayList = new ArrayList<File>();
        String string5 = string2.substring(0, string2.lastIndexOf(File.separator));
        if (string5.startsWith(File.separator)) {
            string5 = string5.substring(1);
        }
        if ((fileArray = (file = new File(string4 = string + string3 + File.separator + string5)).listFiles(new DirFileFilter())) != null && fileArray.length > 0) {
            for (File file2 : fileArray) {
                if (!file2.isDirectory()) continue;
                try {
                    File[] fileArray2 = file2.listFiles(new LicenseUtil.LicFileFilter());
                    if (fileArray2 == null || fileArray2.length <= 0) continue;
                    List<File> list = Arrays.asList(fileArray2);
                    arrayList.addAll(list);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return arrayList;
    }

    private boolean isLicDir(String string) {
        return string.endsWith("_licenses");
    }

    private class DirFileFilter
    implements FilenameFilter {
        private DirFileFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            return LicenseFileFinderDefault.this.isLicDir(string);
        }
    }
}

