/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.licensefiles;

public enum ActivationType {
    STANDALONE_NAMED_USER(186, "SNU", "Standalone Named User"),
    DESIGNATED_COMPUTER(187, "DC", "Designated Computer"),
    NETWORK_CONCURRENT_USER(200, "CN", "Network Concurrent User"),
    INVALID(715, "INVALID", "Invalid or not known"),
    NETWORK_NAMED_USER(276, "NNU", "Network Named User"),
    TEH_DESIGNATED_COMPUTER(277, "TEH-DC", "TEH Designated Computer"),
    TAH_DESIGNATED_COMPUTER(278, "TAH-DC", "TAH Designated Computer"),
    UNSET(287, "UNSET", "Unset"),
    TEH_NETWORK_CONCURRENT_USER(298, "TEH-CN", "TEH Network Concurrent User"),
    TAH_NETWORK_CONCURRENT_USER(299, "TAH-CN", "TAH Network Concurrent User"),
    TAH_STANDALONE_NAMED_USER(693, "TAH-SNU", "TAH Standalone Named User"),
    UNRECOGNIZED(-1, "XXX", "");

    private final int fATCodeI;
    private final String fATCodeC;
    private final String fATStr;

    private ActivationType(int n2, String string2, String string3) {
        this.fATCodeI = n2;
        this.fATCodeC = string2;
        this.fATStr = string3;
    }

    public static ActivationType getActivationType(int n) {
        for (ActivationType activationType : ActivationType.values()) {
            if (activationType.fATCodeI != n) continue;
            return activationType;
        }
        return UNRECOGNIZED;
    }

    public boolean isSNU() {
        return this.equals((Object)STANDALONE_NAMED_USER) || this.equals((Object)TAH_STANDALONE_NAMED_USER);
    }

    public boolean isDC() {
        return this.equals((Object)DESIGNATED_COMPUTER) || this.equals((Object)TEH_DESIGNATED_COMPUTER) || this.equals((Object)TAH_DESIGNATED_COMPUTER);
    }

    public boolean isNetwork() {
        return this.equals((Object)NETWORK_CONCURRENT_USER) || this.equals((Object)NETWORK_NAMED_USER) || this.equals((Object)TEH_NETWORK_CONCURRENT_USER) || this.equals((Object)TAH_NETWORK_CONCURRENT_USER);
    }

    public String getId() {
        return String.valueOf(this.fATCodeI);
    }

    public String toString() {
        return this.fATStr;
    }
}

