/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.internal.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZIPExtractor {
    private static final Logger a = LoggerProvider.getBrowserLogger();

    public void extract(File file, String object) {
        Object object2 = file;
        if (((File)object2).exists() && !((File)object2).isDirectory()) {
            throw new IllegalArgumentException("Cannot create directory to extract Chromium. File with the same name already exists: " + ((File)object2).getAbsolutePath());
        }
        object2 = object;
        Object object3 = ZIPExtractor.class.getResource((String)object2);
        a.info("The '" + (String)object2 + "' JAR resource URL is " + object3);
        if (object3 != null && ((URL)object3).getProtocol().startsWith("bundleresource")) {
            object3 = ZIPExtractor.a((URL)object3);
            a.info("Converting OSGi bundle URL to usual URL: " + object3);
        }
        if (object3 == null || !((URL)object3).getProtocol().startsWith("jar")) {
            throw new IllegalArgumentException("The " + (String)object2 + " resource cannot be found in JAR files.");
        }
        object2 = object3;
        FileUtil.createDirs(file);
        object = new File(file, (String)object);
        try {
            object3 = object;
            if (!((File)object3).createNewFile()) {
                throw new RuntimeException("Cannot create file: " + ((File)object3).getAbsolutePath());
            }
            Closeable closeable = ((URL)object2).openStream();
            object2 = new FileOutputStream((File)object3).getChannel();
            try {
                ZIPExtractor.a((InputStream)closeable, (FileChannel)object2);
            }
            finally {
                ((InputStream)closeable).close();
                ((AbstractInterruptibleChannel)object2).close();
            }
            object3 = object;
            object2 = file;
            closeable = new ZipFile((File)object3);
            ZIPExtractor.a((ZipFile)closeable, (File)object2);
            ((ZipFile)closeable).close();
            return;
        }
        catch (ZipException zipException) {
            throw new RuntimeException(zipException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            FileUtil.deleteFile((File)object);
        }
    }

    private static URL a(URL uRL) {
        try {
            GenericDeclaration genericDeclaration = Class.forName("org.eclipse.core.runtime.FileLocator");
            genericDeclaration = genericDeclaration.getMethod("resolve", URL.class);
            return (URL)((Method)genericDeclaration).invoke(null, uRL);
        }
        catch (Exception exception) {
            a.log(Level.SEVERE, "Cannot resolve OSGi Bundle URL with org.eclipse.core.runtime.FileLocator.", exception);
            try {
                GenericDeclaration genericDeclaration = Class.forName("org.eclipse.core.runtime.Platform");
                genericDeclaration = genericDeclaration.getMethod("resolve", URL.class);
                return (URL)((Method)genericDeclaration).invoke(null, uRL);
            }
            catch (Exception exception2) {
                a.log(Level.SEVERE, "Cannot resolve OSGi Bundle URL with org.eclipse.core.runtime.Platform.", exception2);
                return null;
            }
        }
    }

    private static void a(ZipFile zipFile, File file) {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            Object object2 = new File(file, ((ZipEntry)object).getName());
            if (((ZipEntry)object).isDirectory()) {
                FileUtil.createDirs((File)object2);
                continue;
            }
            object2 = new FileOutputStream((File)object2).getChannel();
            object = zipFile.getInputStream((ZipEntry)object);
            try {
                try {
                    ZIPExtractor.a((InputStream)object, (FileChannel)object2);
                }
                finally {
                    ((InputStream)object).close();
                    ((AbstractInterruptibleChannel)object2).close();
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    private static void a(InputStream inputStream, FileChannel fileChannel) {
        ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
        fileChannel.transferFrom(readableByteChannel, 0L, inputStream.available());
    }
}

