/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.BrowserException;
import com.teamdev.jxbrowser.chromium.BrowserView;
import com.teamdev.jxbrowser.chromium.KeyFilter;
import com.teamdev.jxbrowser.chromium.internal.CursorType;
import com.teamdev.jxbrowser.chromium.internal.DragAndDropSupport;
import com.teamdev.jxbrowser.chromium.internal.MacShortcutSupport;
import com.teamdev.jxbrowser.chromium.internal.MemoryImage;
import com.teamdev.jxbrowser.chromium.internal.MemoryImageListener;
import com.teamdev.jxbrowser.chromium.internal.SharedMemory;
import com.teamdev.jxbrowser.chromium.internal.Widget;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.LatchUtil;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCAdapter;
import com.teamdev.jxbrowser.chromium.internal.ipc.events.IPCListener;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnCursorChangeMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnPaintMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRenderViewCreatedMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnRenderViewGoneMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnTakeFocusMessage;
import com.teamdev.jxbrowser.chromium.internal.p;
import com.teamdev.jxbrowser.chromium.internal.q;
import com.teamdev.jxbrowser.chromium.internal.r;
import com.teamdev.jxbrowser.chromium.internal.t;
import com.teamdev.jxbrowser.chromium.internal.u;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class WidgetView
extends JComponent
implements BrowserView {
    private final Widget a;
    private final Dimension b;
    private final MemoryImage c;
    private final KeyListener d;
    private final c e;
    private final FocusListener f;
    private final ComponentListener g;
    private final IPCListener h;
    private DragAndDropSupport i;
    private MacShortcutSupport j;
    private KeyFilter k;

    public WidgetView(Widget object) {
        this.a = object;
        this.b = new Dimension();
        this.c = new MemoryImage();
        this.e = new c(this, null);
        this.d = new a(this, null);
        this.g = new e(this, null);
        this.f = new b(this, null);
        this.h = new d(this, null);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        object = this;
        ((WidgetView)object).getWidget().getIPC().addIPCListener(((WidgetView)object).h);
        object = this;
        ((WidgetView)object).a.getChannel().addChannelListener(new u((WidgetView)object));
    }

    public void setDragAndDropSupport(DragAndDropSupport dragAndDropSupport) {
        this.i = dragAndDropSupport;
    }

    public void setMacShortcutSupport(MacShortcutSupport macShortcutSupport) {
        this.j = macShortcutSupport;
    }

    private void a() {
        this.c.setVisible(false);
        this.removeFocusListener(this.f);
        this.removeComponentListener(this.g);
        this.removeKeyListener(this.d);
        this.removeMouseListener(this.e);
        this.removeMouseWheelListener(this.e);
        this.removeMouseMotionListener(this.e);
        this.repaint();
    }

    private void b() {
        if (!this.c.isVisible()) {
            this.addFocusListener(this.f);
            this.addMouseListener(this.e);
            this.addMouseWheelListener(this.e);
            this.addMouseMotionListener(this.e);
            this.addKeyListener(this.d);
            this.addComponentListener(this.g);
            this.c.setVisible(true);
            this.repaint();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.b();
    }

    public void removeNotify() {
        this.a();
        super.removeNotify();
    }

    public void dispose() {
        this.getWidget().getIPC().removeIPCListener(this.h);
    }

    public JComponent getComponent() {
        return this;
    }

    public Image getImage() {
        return this.c.getImage();
    }

    public void updateSize(int n2, int n3) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("The width parameter cannot be <= 0.");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("The height parameter cannot be <= 0.");
        }
        if (this.b.width == n2 && this.b.height == n3) {
            return;
        }
        this.b.setSize(n2, n3);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Object object = new Dimension(n2, n3);
        object = new p(this, (Dimension)object, countDownLatch);
        this.c.addMemoryImageListener((MemoryImageListener)object);
        this.getWidget().setBounds(new Rectangle(n2, n3));
        try {
            LatchUtil.await(countDownLatch, new BrowserException("Failed to update view bounds."));
            return;
        }
        finally {
            this.c.removeMemoryImageListener((MemoryImageListener)object);
        }
    }

    public Widget getWidget() {
        return this.a;
    }

    public void setKeyFilter(KeyFilter keyFilter) {
        this.k = keyFilter;
    }

    public void setDragAndDropEnabled(boolean bl) {
        if (this.i != null) {
            this.i.setDragEnabled(bl);
        }
    }

    public boolean isDragAndDropEnabled() {
        return this.i.isDragEnabled();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.c.isVisible() && this.c.isInitialized()) {
            int n2 = this.c.getWidth();
            int n3 = this.c.getHeight();
            graphics = (Graphics2D)graphics;
            double d2 = 1.0 / this.c.getDeviceScaleFactor();
            ((Graphics2D)graphics).scale(d2, d2);
            graphics.drawImage(this.c.getImage(), 0, 0, n2, n3, null);
        }
    }

    static /* synthetic */ void a(WidgetView widgetView, OnPaintMessage object) {
        String string;
        Object object2;
        long l2 = ((OnPaintMessage)object).getPid();
        long l3 = ((OnPaintMessage)object).getSharedMemoryHandle();
        int n2 = ((OnPaintMessage)object).getSharedMemoryCapacity();
        int n3 = ((OnPaintMessage)object).getClientWidth();
        int n4 = ((OnPaintMessage)object).getClientHeight();
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
        Object object3 = ((OnPaintMessage)object).getRects();
        object3 = new StringTokenizer((String)object3, ",", false);
        while (((StringTokenizer)object3).hasMoreTokens()) {
            object2 = ((StringTokenizer)object3).nextToken();
            string = ((StringTokenizer)object3).nextToken();
            String string2 = ((StringTokenizer)object3).nextToken();
            String string3 = ((StringTokenizer)object3).nextToken();
            arrayList.add(new Rectangle(Integer.valueOf((String)object2), Integer.valueOf(string), Integer.valueOf(string2), Integer.valueOf(string3)));
        }
        object2 = new Dimension(n3, n4);
        string = ((OnPaintMessage)object).getMemoryFilePath();
        double d2 = ((OnPaintMessage)object).getDeviceScaleFactor();
        object = new SharedMemory(l2, l3, n2, (Dimension)object2, string, d2);
        widgetView.c.resetMemory((SharedMemory)object);
        widgetView.c.updatePixels(arrayList.toArray(new Rectangle[arrayList.size()]));
        SwingUtilities.invokeLater(new q(widgetView));
    }

    static /* synthetic */ void a(WidgetView widgetView, OnCursorChangeMessage onCursorChangeMessage) {
        int n2 = onCursorChangeMessage.getCursorType();
        widgetView.setCursor(CursorType.toJavaCursor(n2));
    }

    static /* synthetic */ void a(WidgetView widgetView, OnRenderViewGoneMessage onRenderViewGoneMessage) {
        widgetView.a();
    }

    static /* synthetic */ void a(WidgetView widgetView, OnRenderViewCreatedMessage onRenderViewCreatedMessage) {
        widgetView.b();
    }

    static /* synthetic */ void a(OnTakeFocusMessage onTakeFocusMessage) {
        if (onTakeFocusMessage.isReverse()) {
            SwingUtilities.invokeLater(new t());
            return;
        }
        SwingUtilities.invokeLater(new r());
    }

    private final class d
    extends IPCAdapter {
        private /* synthetic */ WidgetView a;

        private d(WidgetView widgetView) {
            this.a = widgetView;
        }

        public final void onChannelRemoved(Channel channel) {
            boolean bl;
            Channel channel2 = this.a.getWidget().getChannel();
            boolean bl2 = channel.getChannelId() == channel2.getChannelId();
            boolean bl3 = bl = channel.getType() == channel2.getType();
            if (bl2 && bl) {
                this.a.a();
            }
        }

        /* synthetic */ d(WidgetView widgetView, u u2) {
            this(widgetView);
        }
    }

    private final class b
    extends FocusAdapter {
        private /* synthetic */ WidgetView a;

        private b(WidgetView widgetView) {
            this.a = widgetView;
        }

        public final void focusGained(FocusEvent focusEvent) {
            this.a.a.focus();
        }

        public final void focusLost(FocusEvent focusEvent) {
            this.a.a.unfocus();
        }

        /* synthetic */ b(WidgetView widgetView, u u2) {
            this(widgetView);
        }
    }

    private final class e
    extends ComponentAdapter {
        private /* synthetic */ WidgetView a;

        private e(WidgetView widgetView) {
            this.a = widgetView;
        }

        public final void componentResized(ComponentEvent serializable) {
            serializable = serializable.getComponent();
            serializable = ((Component)serializable).getBounds();
            this.a.a.setBounds((Rectangle)serializable);
        }

        /* synthetic */ e(WidgetView widgetView, u u2) {
            this(widgetView);
        }
    }

    private final class a
    extends KeyAdapter {
        private /* synthetic */ WidgetView a;

        private a(WidgetView widgetView) {
            this.a = widgetView;
        }

        public final void keyPressed(KeyEvent keyEvent) {
            if (this.a(keyEvent)) {
                this.a.a.forwardKeyPressedEvent(keyEvent);
            }
            if (this.a.j != null) {
                this.a.j.handleKeyPress(keyEvent);
            }
        }

        public final void keyTyped(KeyEvent keyEvent) {
            if (this.a(keyEvent)) {
                this.a.a.forwardKeyTypedEvent(keyEvent);
            }
        }

        public final void keyReleased(KeyEvent keyEvent) {
            if (this.a(keyEvent)) {
                this.a.a.forwardKeyReleasedEvent(keyEvent);
            }
        }

        private boolean a(KeyEvent keyEvent) {
            return this.a.k == null || !this.a.k.filter(keyEvent);
        }

        /* synthetic */ a(WidgetView widgetView, u u2) {
            this(widgetView);
        }
    }

    private final class c
    extends MouseAdapter {
        private /* synthetic */ WidgetView a;

        private c(WidgetView widgetView) {
            this.a = widgetView;
        }

        public final void mousePressed(MouseEvent mouseEvent) {
            this.a.a.forwardMouseEvent(mouseEvent);
            this.a.requestFocus();
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            this.a.a.forwardMouseEvent(mouseEvent);
        }

        public final void mouseMoved(MouseEvent mouseEvent) {
            this.a.a.forwardMouseEvent(mouseEvent);
        }

        public final void mouseDragged(MouseEvent mouseEvent) {
            this.a.a.forwardMouseEvent(mouseEvent);
        }

        public final void mouseEntered(MouseEvent mouseEvent) {
            this.a.a.forwardMouseEvent(mouseEvent);
        }

        public final void mouseExited(MouseEvent mouseEvent) {
            this.a.a.forwardMouseEvent(mouseEvent);
        }

        public final void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.a.a.forwardMouseWheelEvent(mouseWheelEvent);
            mouseWheelEvent.consume();
        }

        /* synthetic */ c(WidgetView widgetView, u u2) {
            this(widgetView);
        }
    }
}

