/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.internal.KeyCodes;
import com.teamdev.jxbrowser.chromium.internal.KeyCodesFactory;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.IPC;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.FocusMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardKeyboardMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardMouseMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ForwardMouseWheelMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.SetBoundsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.UnfocusMessage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.io.Serializable;
import javax.swing.SwingUtilities;

public class Widget {
    private final IPC a;
    private final Channel b;
    private final KeyCodes c;
    private int d;

    public Widget(Channel channel, IPC iPC) {
        this.b = channel;
        this.a = iPC;
        this.c = KeyCodesFactory.create();
    }

    public IPC getIPC() {
        return this.a;
    }

    public Channel getChannel() {
        return this.b;
    }

    public void forwardMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        Serializable serializable = mouseWheelEvent.getComponent();
        serializable = serializable.getLocationOnScreen();
        int n2 = ((Point)serializable).x;
        int n3 = ((Point)serializable).y;
        int n4 = mouseWheelEvent.getX();
        int n5 = mouseWheelEvent.getY();
        int n6 = mouseWheelEvent.getX();
        int n7 = mouseWheelEvent.getY();
        int n8 = -mouseWheelEvent.getUnitsToScroll();
        int n9 = -mouseWheelEvent.getWheelRotation();
        int n10 = mouseWheelEvent.getScrollType();
        long l2 = mouseWheelEvent.getWhen();
        int n11 = mouseWheelEvent.getModifiersEx();
        this.b.send(new ForwardMouseWheelMessage(MessageUIDGenerator.generate(), n4, n5, n6, n7, n2, n3, n10, n9, n8, l2, n11));
    }

    public void forwardMouseEvent(MouseEvent mouseEvent) {
        Serializable serializable = mouseEvent.getComponent();
        serializable = serializable.isShowing() ? serializable.getLocationOnScreen() : new Point();
        int n2 = mouseEvent.getID();
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        int n5 = ((Point)serializable).x + n3;
        int n6 = ((Point)serializable).y + n4;
        MouseEvent mouseEvent2 = mouseEvent;
        int n7 = SwingUtilities.isLeftMouseButton(mouseEvent2) ? 1 : (SwingUtilities.isMiddleMouseButton(mouseEvent2) ? 2 : (SwingUtilities.isRightMouseButton(mouseEvent2) ? 3 : 0));
        int n8 = mouseEvent.getClickCount();
        long l2 = mouseEvent.getWhen();
        int n9 = mouseEvent.getModifiersEx();
        this.b.send(new ForwardMouseMessage(MessageUIDGenerator.generate(), n2, n3, n4, n5, n6, n3, n4, n7, n8, l2, n9));
    }

    public void forwardKeyPressedEvent(KeyEvent keyEvent) {
        this.d = keyEvent.getKeyCode();
        this.a(keyEvent, 401, keyEvent.getWhen());
    }

    public void forwardKeyTypedEvent(KeyEvent keyEvent) {
        int n2 = this.d != 0 ? this.d : keyEvent.getKeyCode();
        this.a(new KeyEvent(keyEvent.getComponent(), 401, keyEvent.getWhen(), keyEvent.getModifiers(), n2, keyEvent.getKeyChar(), keyEvent.getKeyLocation()), 400, keyEvent.getWhen());
    }

    public void forwardKeyReleasedEvent(KeyEvent keyEvent) {
        this.d = 0;
        this.a(keyEvent, 402, keyEvent.getWhen());
    }

    private void a(KeyEvent keyEvent, int n2, long l2) {
        char c2 = keyEvent.getKeyChar();
        int n3 = keyEvent.getModifiersEx();
        int n4 = keyEvent.getKeyCode();
        n4 = this.c.toNativeKeyCode(n4);
        boolean bl = keyEvent.getKeyCode() == 10;
        this.b.send(new ForwardKeyboardMessage(MessageUIDGenerator.generate(), n2, n4, bl, c2, l2, n3));
    }

    public void setBounds(Rectangle rectangle) {
        if (!this.b.isClosed()) {
            this.b.send(new SetBoundsMessage(MessageUIDGenerator.generate(), rectangle));
        }
    }

    public void focus() {
        if (!this.b.isClosed()) {
            this.b.send(new FocusMessage(MessageUIDGenerator.generate()));
        }
    }

    public void unfocus() {
        if (!this.b.isClosed()) {
            this.b.send(new UnfocusMessage(MessageUIDGenerator.generate()));
        }
    }
}

