/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium.internal;

import com.teamdev.jxbrowser.chromium.JSValue;
import com.teamdev.jxbrowser.chromium.LoadParams;
import com.teamdev.jxbrowser.chromium.LoggerProvider;
import com.teamdev.jxbrowser.chromium.dom.DOMDocument;
import com.teamdev.jxbrowser.chromium.dom.DOMNodeAtPoint;
import com.teamdev.jxbrowser.chromium.dom.internal.DOMContext;
import com.teamdev.jxbrowser.chromium.dom.internal.DOMFactory;
import com.teamdev.jxbrowser.chromium.dom.internal.Document;
import com.teamdev.jxbrowser.chromium.internal.ChromiumEventQueue;
import com.teamdev.jxbrowser.chromium.internal.JSValueParser;
import com.teamdev.jxbrowser.chromium.internal.WebView;
import com.teamdev.jxbrowser.chromium.internal.WebViewManager;
import com.teamdev.jxbrowser.chromium.internal.ipc.Channel;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.ExecuteCommandMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetDocumentMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.GetNodeAtPointMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.IsCommandEnabledMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.MessageUIDGenerator;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnGetJSFunctionsMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnHandleLoadMessage;
import com.teamdev.jxbrowser.chromium.internal.ipc.message.OnInvokeJSFunctionMessage;
import com.teamdev.jxbrowser.chromium.internal.o;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RenderProcess {
    private static final Logger a = LoggerProvider.getBrowserLogger();
    private final Channel b;
    private final ChromiumEventQueue c;

    public RenderProcess(Channel channel) {
        this.b = channel;
        this.c = new ChromiumEventQueue();
        this.b.addChannelListener(new o(this));
    }

    public void dispose() {
        this.c.dispose();
    }

    public Channel getChannel() {
        return this.b;
    }

    public DOMDocument getDocument(int n2) {
        Object object = ((RenderProcess)((Object)dOMContext)).b.post(new GetDocumentMessage(MessageUIDGenerator.generate(), n2, 0L));
        long l2 = ((GetDocumentMessage)object).getDocumentPtr();
        DOMContext dOMContext = new DOMContext(((RenderProcess)((Object)dOMContext)).b, ((RenderProcess)((Object)dOMContext)).c);
        object = new DOMFactory(dOMContext);
        return new Document(l2, (DOMFactory)object, dOMContext);
    }

    public DOMNodeAtPoint getNodeAtPoint(int n2, int n3) {
        GetNodeAtPointMessage getNodeAtPointMessage = ((RenderProcess)object).b.post(new GetNodeAtPointMessage(MessageUIDGenerator.generate(), n2, n3, "", 0L, 0, 0, "", ""));
        Object object = new DOMContext(((RenderProcess)object).b, ((RenderProcess)object).c);
        object = new DOMFactory((DOMContext)object);
        return ((DOMFactory)object).createNodeAtPoint(getNodeAtPointMessage);
    }

    public boolean isCommandEnabled(String string) {
        IsCommandEnabledMessage isCommandEnabledMessage = ((RenderProcess)((Object)isCommandEnabledMessage)).b.post(new IsCommandEnabledMessage(MessageUIDGenerator.generate(), string));
        return isCommandEnabledMessage.getResult();
    }

    public boolean executeCommand(int n2, String string, String string2) {
        ExecuteCommandMessage executeCommandMessage = new ExecuteCommandMessage(MessageUIDGenerator.generate(), n2, string, string2);
        ExecuteCommandMessage executeCommandMessage2 = ((RenderProcess)((Object)executeCommandMessage2)).b.post(executeCommandMessage);
        return executeCommandMessage2.getResult();
    }

    static /* synthetic */ void a(RenderProcess renderProcess, OnGetJSFunctionsMessage onGetJSFunctionsMessage) {
        Object object = WebViewManager.INSTANCE.getWebView(renderProcess);
        if (object != null) {
            object = ((WebView)object).getBrowserFunctionNames();
            StringBuilder stringBuilder = new StringBuilder();
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                stringBuilder.append(string);
                stringBuilder.append(' ');
            }
            onGetJSFunctionsMessage.setFunctionNames(stringBuilder.toString());
        }
        renderProcess.b.send(onGetJSFunctionsMessage);
    }

    static /* synthetic */ void a(RenderProcess renderProcess, OnInvokeJSFunctionMessage onInvokeJSFunctionMessage) {
        Object object = WebViewManager.INSTANCE.getWebView(renderProcess);
        if (object != null) {
            Object object2 = onInvokeJSFunctionMessage.getName();
            object = ((WebView)object).getBrowserFunction((String)object2);
            object2 = JSValueParser.fromString(onInvokeJSFunctionMessage.getArgs());
            try {
                object = object.invoke(object2.toArray(new JSValue[object2.size()]));
                if (object == null) {
                    object = JSValue.createUndefined();
                }
                onInvokeJSFunctionMessage.setReturnValue(JSValueParser.toString((JSValue)object));
            }
            catch (Exception exception) {
                a.log(Level.SEVERE, "The Browser.invoke() method has thrown exception: ", exception);
                onInvokeJSFunctionMessage.setErrorMessage(exception.getMessage());
            }
        }
        renderProcess.b.send(onInvokeJSFunctionMessage);
    }

    static /* synthetic */ void a(RenderProcess renderProcess, OnHandleLoadMessage onHandleLoadMessage) {
        Object object = WebViewManager.INSTANCE.getWebView(renderProcess);
        if (object != null && (object = ((WebView)object).getLoadHandler()) != null) {
            String string = onHandleLoadMessage.getURL();
            LoadParams.LoadType loadType = LoadParams.LoadType.valueOf(onHandleLoadMessage.getLoadType());
            LoadParams.LoadPolicy loadPolicy = LoadParams.LoadPolicy.valueOf(onHandleLoadMessage.getLoadPpolicy());
            try {
                onHandleLoadMessage.setCancel(object.onLoad(new LoadParams(string, loadType, loadPolicy, onHandleLoadMessage.isRedirect())));
            }
            catch (Exception exception) {
                a.log(Level.SEVERE, "The LoadHandler.onLoad() method has thrown exception: ", exception);
            }
        }
        renderProcess.b.send(onHandleLoadMessage);
    }
}

