/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xom;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.java.JavaPlatform;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.xom.DocumentWrapper;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.ParsingException;

public class XomUriResolver
extends StandardURIResolver {
    public XomUriResolver(Configuration config) {
        super(config);
    }

    public Source resolve(String href, String base) throws XPathException {
        URI url;
        String relativeURI = href;
        int hash = href.indexOf(35);
        if (hash >= 0) {
            relativeURI = href.substring(0, hash);
        }
        try {
            relativeURI = ResolveURI.escapeSpaces((String)relativeURI);
            URI relative = new URI(relativeURI);
        }
        catch (URISyntaxException err) {
            throw new XPathException("Invalid relative URI " + Err.wrap((CharSequence)relativeURI), (Throwable)err);
        }
        JavaPlatform platform = JavaPlatform.getInstance();
        try {
            url = platform.makeAbsolute(relativeURI, base);
        }
        catch (URISyntaxException err) {
            String expandedBase = ResolveURI.tryToExpand((String)base);
            if (!expandedBase.equals(base)) {
                return this.resolve(href, expandedBase);
            }
            throw new XPathException("Invalid URI " + Err.wrap((CharSequence)relativeURI) + " - base " + Err.wrap((CharSequence)base), (Throwable)err);
        }
        try {
            Builder builder = new Builder();
            Document doc = builder.build(url.toString());
            if (this.getConfiguration() == null) {
                throw new XPathException("XomUriResolver requires access to the Configuration");
            }
            return new DocumentWrapper((Node)doc, url.toString(), this.getConfiguration());
        }
        catch (IOException io) {
            throw new XPathException((Throwable)io);
        }
        catch (ParsingException pe) {
            throw new XPathException((Throwable)pe);
        }
    }
}

