/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.source.impl;

import com.mathworks.comparisons.source.impl.ComparisonSourceImpl;
import com.mathworks.comparisons.source.type.CSTypeVariable;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;

public class VariableSource
extends ComparisonSourceImpl {
    private final String fName;
    private final String fDataAccessFcn;
    private final String fDataCleanupFcn;

    public VariableSource(String string, String string2) {
        this(string, string2, null);
    }

    public VariableSource(String string, String string2, String string3) {
        super(new CSTypeVariable());
        this.fName = string;
        this.fDataAccessFcn = string2;
        this.fDataCleanupFcn = string3;
    }

    @Override
    public void refresh() {
        this.dispose();
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.fDataCleanupFcn != null && !this.fDataAccessFcn.isEmpty() && Matlab.isMatlabAvailable()) {
            MatlabWorker matlabWorker = new MatlabWorker(){

                public Object runOnMatlabThread() throws Exception {
                    1.eval((String)VariableSource.this.fDataCleanupFcn);
                    return null;
                }

                public void runOnAWTEventDispatchThread(Object object) {
                }
            };
            matlabWorker.start();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public String getName() {
        return this.fName;
    }

    public String getShortTitle() {
        int n = this.fName.lastIndexOf(46);
        String string = n >= 0 ? this.fName.substring(n + 1) : this.fName;
        return ResourceManager.format("variable.sourcename", string);
    }

    private String getDataAccessFcn() {
        return this.fDataAccessFcn;
    }

    private String getDataCleanupFcn() {
        return this.fDataCleanupFcn;
    }
}

