/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.source.impl;

import com.mathworks.comparisons.source.impl.ComparisonSourceImpl;
import com.mathworks.comparisons.source.type.CSTypeString;
import com.mathworks.comparisons.util.LocalIOUtils;
import com.mathworks.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class StringSource
extends ComparisonSourceImpl {
    private final String fName;
    private final String fData;
    private final Charset fEncoding;
    private volatile File fTempFile = null;
    private volatile InputStream fInputStream = null;

    public StringSource(String string, String string2, Charset charset) {
        super(new CSTypeString());
        this.fName = string;
        this.fData = string2;
        this.fEncoding = charset == null ? Charset.defaultCharset() : charset;
    }

    @Override
    public void refresh() {
        this.dispose();
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.fTempFile != null) {
            this.fTempFile.delete();
            this.fTempFile = null;
        }
        if (this.fInputStream != null) {
            LocalIOUtils.closeQuietly(this.fInputStream);
            this.fInputStream = null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    private String getName() {
        return this.fName;
    }

    private String getText() {
        return this.fData;
    }

    private synchronized File getReadableLocation() {
        if (this.fTempFile == null) {
            String string = this.getName() + '_';
            try {
                this.fTempFile = LocalIOUtils.createTempFile(string, null);
                LocalIOUtils.writeStringToFile(this.fData, this.fTempFile, this.fEncoding);
            }
            catch (IOException iOException) {
                Log.logException((Exception)iOException);
            }
        }
        return this.fTempFile;
    }

    private synchronized InputStream getInputStream() {
        if (this.fInputStream == null) {
            try {
                this.fInputStream = new ByteArrayInputStream(this.fData.getBytes(this.fEncoding.name()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.logException((Exception)unsupportedEncodingException);
            }
        }
        return this.fInputStream;
    }
}

