/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.source.impl;

import com.mathworks.comparisons.collection.ComparisonCollection;
import com.mathworks.comparisons.collection.ComparisonCollectionFactory;
import com.mathworks.comparisons.collection.impl.LocalFolderCollection;
import com.mathworks.comparisons.source.ComparisonSourceType;
import com.mathworks.comparisons.source.impl.ComparisonSourceImpl;
import com.mathworks.comparisons.source.impl.ComparisonSourceListener;
import com.mathworks.comparisons.source.info.CSPInfoIncludeRelativeFrom;
import com.mathworks.comparisons.source.info.CSPInfoIncludeSubFolders;
import com.mathworks.comparisons.source.type.CSTypeFile;
import com.mathworks.comparisons.source.type.CSTypeFolder;
import com.mathworks.comparisons.util.ExceptionHandler;
import com.mathworks.comparisons.util.FileChangedNotifier;
import com.mathworks.comparisons.util.LocalIOUtils;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.toolbox.shared.computils.confinement.ThreadCheck;
import com.mathworks.toolbox.shared.computils.confinement.predicates.NotEDT;
import com.mathworks.toolbox.shared.computils.file.ChecksumGenerator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.Validate;

public class LocalFileSource
extends ComparisonSourceImpl {
    private final Object fSyncingSynchronizer = new Object();
    private final String fName;
    private final File fFile;
    private final FileChangedNotifier fFileChangedNotifier;
    private final AtomicReference<Long> fBaselineChecksum;
    private volatile InputStream fInputStream;

    public LocalFileSource(File file, String string) throws FileNotFoundException {
        super(LocalFileSource.getComparisonSourceType(file));
        Validate.notNull((Object)string);
        LocalFileSource.throwExceptionIfFileDoesNotExist(file);
        LocalFileSource.throwExceptionIfFilePathIsNotAbsolute(file);
        this.fFile = file;
        this.fName = string;
        this.fFileChangedNotifier = this.createFileChangedNotifier(file);
        this.fBaselineChecksum = new AtomicReference<Long>(this.generateChecksumForFile());
    }

    private static ComparisonSourceType getComparisonSourceType(File file) {
        Validate.notNull((Object)file);
        return file.isDirectory() ? new CSTypeFolder() : new CSTypeFile();
    }

    private FileChangedNotifier createFileChangedNotifier(File file) {
        if (file.isDirectory()) {
            return null;
        }
        FileChangedNotifier fileChangedNotifier = null;
        try {
            fileChangedNotifier = new FileChangedNotifier(this.fFile);
            fileChangedNotifier.addListener(new FileChangedNotifier.ChangeListener(){

                @Override
                public void fileChanged() {
                    LocalFileSource.this.notifyListenersOfChangedOnDisk();
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileChangedNotifier;
    }

    @ThreadCheck(access=NotEDT.class)
    private long generateChecksumForFile() {
        try {
            return ChecksumGenerator.getCRC32Checksum((File)this.fFile);
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    @Override
    public void addListener(ComparisonSourceListener comparisonSourceListener) {
        super.addListener(comparisonSourceListener);
        this.startMonitoringIfFirstListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOutOfSync() {
        Object object = this.fSyncingSynchronizer;
        synchronized (object) {
            long l = this.fBaselineChecksum.get();
            return l != this.generateChecksumForFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync() {
        Object object = this.fSyncingSynchronizer;
        synchronized (object) {
            this.fBaselineChecksum.set(this.generateChecksumForFile());
        }
    }

    private void startMonitoringIfFirstListener() {
        if (this.getListeners().size() == 1 && this.fFileChangedNotifier != null) {
            this.fFileChangedNotifier.startMonitoring();
        }
    }

    @Override
    public void removeListener(ComparisonSourceListener comparisonSourceListener) {
        super.removeListener(comparisonSourceListener);
        this.stopMonitoringIfLastListenerRemoved();
    }

    private void stopMonitoringIfLastListenerRemoved() {
        if (this.getListeners().isEmpty() && this.fFileChangedNotifier != null) {
            this.fFileChangedNotifier.stopMonitoring();
        }
    }

    @Override
    public synchronized void refresh() {
        this.disposeInputStream();
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        this.disposeInputStream();
        this.stopListeningToFileSystemChanges();
    }

    private void disposeInputStream() {
        if (this.fInputStream != null) {
            LocalIOUtils.closeQuietly(this.fInputStream);
            this.fInputStream = null;
        }
    }

    private void stopListeningToFileSystemChanges() {
        if (this.fFileChangedNotifier != null) {
            this.fFileChangedNotifier.stopMonitoring();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    private String getName() {
        return this.fName;
    }

    private String getAbsoluteName() {
        return this.fFile.getAbsolutePath();
    }

    private long getSize() {
        long l = 0L;
        if (this.fFile.exists() && !this.fFile.isDirectory()) {
            l = this.fFile.length();
        }
        return l;
    }

    private Date getLastModifiedDate() {
        Date date = null;
        if (this.fFile.exists()) {
            long l = this.fFile.lastModified();
            date = new Date(l);
        }
        return date;
    }

    private String getTitle() {
        return LocalIOUtils.truncatePathName(this.fName);
    }

    private String getShortTitle() {
        return this.fFile.getName();
    }

    private File getReadableLocation() {
        if (!this.fFile.exists()) {
            throw new IllegalStateException(ResourceManager.format("exception.filenotfound", this.fFile.getPath()));
        }
        return this.fFile;
    }

    private synchronized InputStream getInputStream() {
        if (this.fInputStream == null) {
            try {
                this.fInputStream = new BufferedInputStream(new FileInputStream(this.fFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = ResourceManager.format("exception.readfilefailure", fileNotFoundException.getMessage());
                throw new IllegalStateException(string);
            }
        }
        return this.fInputStream;
    }

    private ComparisonCollection getComparisonCollection(CSPInfoIncludeSubFolders cSPInfoIncludeSubFolders, CSPInfoIncludeRelativeFrom cSPInfoIncludeRelativeFrom) {
        if (!this.fFile.exists()) {
            ExceptionHandler.rethrow(new FileNotFoundException(ResourceManager.format("exception.filenotfound", this.fFile.getPath())));
        }
        return ComparisonCollectionFactory.createFromFile(LocalFolderCollection.class, this.fName, this.fFile, cSPInfoIncludeSubFolders, cSPInfoIncludeRelativeFrom);
    }

    private static void throwExceptionIfFileDoesNotExist(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(ResourceManager.format("exception.filenotfound", file.getPath()));
        }
    }

    private static void throwExceptionIfFilePathIsNotAbsolute(File file) {
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException(ResourceManager.format("exception.absolutefilename", file.getPath()));
        }
    }
}

