/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.selection.file;

import com.mathworks.comparisons.selection.InvalidConversionException;
import com.mathworks.comparisons.selection.ValidSourceSelectionPolicy;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.impl.LocalFileSource;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.explorer.FileLocation;
import java.io.File;
import java.io.IOException;

public class ValidFileSelectionPolicy
implements ValidSourceSelectionPolicy<File> {
    @Override
    public ComparisonSource convertToComparisonSource(File file) throws InvalidConversionException {
        if (file != null) {
            File file2 = this.resolveSelection(file);
            try {
                return new LocalFileSource(file2, file.getPath());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return null;
    }

    private File resolveSelection(File file) throws InvalidConversionException {
        assert (file != null);
        String string = file.getPath();
        File file2 = file;
        if (!FileLocation.isPathString((String)string)) {
            FileLocation fileLocation = new FileLocation(MatlabPath.getCWD());
            file2 = new FileLocation(fileLocation, string).toFile();
        }
        if (!file2.exists()) {
            throw new InvalidConversionException(file2, ResourceManager.getString("fileselectionpolicy.invalidpath"));
        }
        if (file2.isFile() && !file2.canRead()) {
            throw new InvalidConversionException(file2, ResourceManager.getString("fileselectionpolicy.cannotopen"));
        }
        return file2;
    }
}

